/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.identity;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.IdentityConfig;
import org.openziti.util.CertsKt;
import org.openziti.util.ZitiLog;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\"\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a0\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0000\u00a8\u0006\u001a"}, d2={"findIdentityAlias", "", "ks", "Ljava/security/KeyStore;", "keystoreFromConfig", "id", "Lorg/openziti/IdentityConfig;", "loadKeystore", "i", "", "f", "Ljava/io/File;", "pwd", "", "stream", "Ljava/io/InputStream;", "log", "Lorg/openziti/util/ZitiLog;", "makeSSLContext", "Ljavax/net/ssl/SSLContext;", "key", "Ljava/security/PrivateKey;", "certs", "", "Ljava/security/cert/X509Certificate;", "ca", "ziti"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\norg/openziti/identity/UtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,163:1\n1563#2:164\n1634#2,3:165\n774#2:168\n865#2,2:169\n1563#2:171\n1634#2,3:172\n37#3:175\n36#3,3:176\n37#3:179\n36#3,3:180\n*S KotlinDebug\n*F\n+ 1 util.kt\norg/openziti/identity/UtilKt\n*L\n57#1:164\n57#1:165,3\n58#1:168\n58#1:169,2\n59#1:171\n59#1:172,3\n64#1:175\n64#1:176,3\n144#1:179\n144#1:180,3\n*E\n"})
public final class UtilKt {
    @NotNull
    public static final String findIdentityAlias(@NotNull KeyStore ks) {
        Intrinsics.checkNotNullParameter((Object)ks, (String)"ks");
        Enumeration<String> enumeration = ks.aliases();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"aliases(...)");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        while (iterator.hasNext()) {
            String a = (String)iterator.next();
            if (!ks.isKeyEntry(a)) continue;
            Intrinsics.checkNotNull((Object)a);
            return a;
        }
        throw new IllegalStateException("no suitable key entry".toString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KeyStore keystoreFromConfig(@NotNull IdentityConfig id) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(null);
        String string = id.getId().getCert();
        Intrinsics.checkNotNull((Object)string);
        List<X509Certificate> certs = CertsKt.readCerts(string);
        URI ztAPI = URI.create(id.getController());
        String name = certs.get(0).getSubjectX500Principal().getName();
        Intrinsics.checkNotNull((Object)name);
        Object object = new String[]{","};
        object = StringsKt.split$default((CharSequence)name, (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith((String)it, (String)"cn=", (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"="};
            collection.add((String)StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)2, (int)2, null).get(1));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        String alias = "ziti://" + ztAPI.getHost() + ":" + ztAPI.getPort() + "/" + name;
        String string3 = id.getId().getKey();
        Intrinsics.checkNotNull((Object)string3);
        PrivateKey key = CertsKt.readKey(string3);
        Collection $this$toTypedArray$iv = certs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        KeyStore.PrivateKeyEntry keyEntry = new KeyStore.PrivateKeyEntry(key, thisCollection$iv.toArray(new X509Certificate[0]));
        ks.setEntry(alias, keyEntry, new KeyStore.PasswordProtection(new char[0]));
        List<X509Certificate> caCerts = CertsKt.readCerts(id.getId().getCa());
        for (X509Certificate ca : caCerts) {
            String caAlias = alias + "-ca-" + ca.getSerialNumber();
            ks.setCertificateEntry(caAlias, ca);
        }
        Intrinsics.checkNotNull((Object)ks);
        return ks;
    }

    @NotNull
    public static final KeyStore loadKeystore(@NotNull byte[] i) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        ZitiLog log = new ZitiLog();
        try {
            IdentityConfig id = IdentityConfig.Companion.load(new ByteArrayInputStream(i));
            return UtilKt.keystoreFromConfig(id);
        }
        catch (Exception ex) {
            log.w("failed to load identity config: " + ex.getLocalizedMessage());
            throw new IllegalArgumentException("unsupported format");
        }
    }

    @NotNull
    public static final KeyStore loadKeystore(@NotNull File f, @NotNull char[] pwd) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        Intrinsics.checkNotNullParameter((Object)pwd, (String)"pwd");
        ZitiLog log = new ZitiLog();
        if (!f.exists() || !f.canRead()) {
            throw new IllegalArgumentException("Failed to parse keystore.  " + f.getAbsolutePath() + " does not exist or can not be read");
        }
        KeyStore ks = UtilKt.loadKeystore(new FileInputStream(f), pwd, log);
        if (ks != null) {
            return ks;
        }
        log.t("Trying to load it as a plain identity config");
        try {
            IdentityConfig id = IdentityConfig.Companion.load(f);
            return UtilKt.keystoreFromConfig(id);
        }
        catch (Exception ex) {
            log.w("failed to load identity config: " + ex.getLocalizedMessage());
            throw new IllegalArgumentException("unsupported format");
        }
    }

    @NotNull
    public static final KeyStore loadKeystore(@NotNull InputStream stream, @NotNull char[] pwd) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)pwd, (String)"pwd");
        ZitiLog log = new ZitiLog();
        byte[] bytes = stream.readNBytes(16384);
        Intrinsics.checkNotNull((Object)bytes);
        KeyStore ks = UtilKt.loadKeystore(new ByteArrayInputStream(bytes), pwd, log);
        if (ks != null) {
            return ks;
        }
        IdentityConfig id = IdentityConfig.Companion.load(new ByteArrayInputStream(bytes));
        return UtilKt.keystoreFromConfig(id);
    }

    @Nullable
    public static final KeyStore loadKeystore(@NotNull InputStream stream, @NotNull char[] pwd, @NotNull ZitiLog log) {
        KeyStore keyStore;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)pwd, (String)"pwd");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        KeyStore ks = KeyStore.getInstance("PKCS12");
        try {
            ks.load(stream, pwd);
            keyStore = ks;
        }
        catch (Exception ex) {
            log.t("Failed to parse identity file as a keystore: " + ex.getLocalizedMessage());
            keyStore = null;
        }
        return keyStore;
    }

    @NotNull
    public static final SSLContext makeSSLContext(@Nullable PrivateKey key, @Nullable Collection<? extends X509Certificate> certs, @NotNull Collection<? extends X509Certificate> ca) {
        SSLContext sSLContext;
        TrustManagerFactory trustManagerFactory;
        Intrinsics.checkNotNullParameter(ca, (String)"ca");
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        Object $this$makeSSLContext_u24lambda_u244 = keyStore;
        boolean bl = false;
        ((KeyStore)$this$makeSSLContext_u24lambda_u244).load(null, null);
        PrivateKey privateKey = key;
        if (privateKey != null) {
            X509Certificate[] x509CertificateArray;
            PrivateKey privateKey2 = privateKey;
            boolean bl2 = false;
            Key key2 = privateKey2;
            Collection<? extends X509Certificate> collection = certs;
            if (collection != null) {
                Collection<? extends X509Certificate> $this$toTypedArray$iv = collection;
                boolean $i$f$toTypedArray = false;
                Collection<? extends X509Certificate> thisCollection$iv = $this$toTypedArray$iv;
                x509CertificateArray = thisCollection$iv.toArray(new X509Certificate[0]);
            } else {
                x509CertificateArray = null;
            }
            ((KeyStore)$this$makeSSLContext_u24lambda_u244).setKeyEntry("identity", key2, null, x509CertificateArray);
        }
        for (X509Certificate sSLContext2 : ca) {
            ((KeyStore)$this$makeSSLContext_u24lambda_u244).setCertificateEntry(sSLContext2.getSubjectX500Principal().getName() + "-" + CertsKt.fingerprint(sSLContext2), sSLContext2);
        }
        KeyStore ks = keyStore;
        Object $this$makeSSLContext_u24lambda_u245 = $this$makeSSLContext_u24lambda_u244 = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        boolean bl2 = false;
        ((KeyManagerFactory)$this$makeSSLContext_u24lambda_u245).init(ks, null);
        Object kmf = $this$makeSSLContext_u24lambda_u244;
        TrustManagerFactory trustManagerFactory2 = trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        boolean bl4 = false;
        trustManagerFactory2.init(ks);
        TrustManagerFactory tmf = trustManagerFactory;
        SSLContext $this$makeSSLContext_u24lambda_u247 = sSLContext = SSLContext.getInstance("TLS");
        boolean bl5 = false;
        $this$makeSSLContext_u24lambda_u247.init(((KeyManagerFactory)kmf).getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
        SSLContext sSLContext3 = sSLContext;
        Intrinsics.checkNotNullExpressionValue((Object)sSLContext3, (String)"apply(...)");
        return sSLContext3;
    }
}

