/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.internal;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketImpl;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelector;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002NOB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u0012\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0013H\u0016J\u001a\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u0018H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\u0003H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\nH\u0016J\b\u0010(\u001a\u00020\nH\u0016J\u0018\u0010)\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u0018H\u0016J\b\u0010+\u001a\u00020\u0018H\u0016J\u0010\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0018H\u0016J\u0010\u0010.\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\nH\u0016J\b\u0010/\u001a\u00020\nH\u0016J\u0010\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u0018H\u0016J\b\u00102\u001a\u00020\u0018H\u0016J\u0010\u00103\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u0018H\u0016J\b\u00104\u001a\u00020\u0018H\u0016J\u0010\u00105\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\nH\u0016J\b\u00106\u001a\u00020\nH\u0016J\u0010\u00107\u001a\u00020\u00112\u0006\u00108\u001a\u00020\u0018H\u0016J\b\u00109\u001a\u00020\u0018H\u0016J\u0010\u0010:\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\nH\u0016J\b\u0010;\u001a\u00020\nH\u0016J\b\u0010<\u001a\u00020\u0011H\u0016J\b\u0010=\u001a\u00020\u0011H\u0016J\b\u0010>\u001a\u00020\nH\u0016J\b\u0010?\u001a\u00020\nH\u0016J\b\u0010@\u001a\u00020\nH\u0016J\b\u0010A\u001a\u00020\nH\u0016J\b\u0010B\u001a\u00020\nH\u0016J1\u0010C\u001a\u00020\u0001\"\n\b\u0000\u0010D*\u0004\u0018\u00010E2\u000e\u0010F\u001a\n\u0012\u0004\u0012\u0002HD\u0018\u00010G2\u0006\u0010H\u001a\u0002HDH\u0016\u00a2\u0006\u0002\u0010IJ)\u0010J\u001a\u0002HD\"\n\b\u0000\u0010D*\u0004\u0018\u00010E2\u000e\u0010F\u001a\n\u0012\u0004\u0012\u0002HD\u0018\u00010GH\u0016\u00a2\u0006\u0002\u0010KJ\u0012\u0010L\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030G0MH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lorg/openziti/net/internal/SocketChannelSocket;", "Ljava/net/Socket;", "ch", "Ljava/nio/channels/SocketChannel;", "<init>", "(Ljava/nio/channels/SocketChannel;)V", "()V", "getCh", "()Ljava/nio/channels/SocketChannel;", "inputShut", "", "outputShut", "sel", "Ljava/nio/channels/Selector;", "selKey", "Ljava/nio/channels/SelectionKey;", "bind", "", "bindpoint", "Ljava/net/SocketAddress;", "close", "connect", "endpoint", "timeout", "", "getInetAddress", "Ljava/net/InetAddress;", "getLocalAddress", "getPort", "getLocalPort", "getRemoteSocketAddress", "Ljava/net/InetSocketAddress;", "getLocalSocketAddress", "getChannel", "getInputStream", "Ljava/io/InputStream;", "getOutputStream", "Ljava/io/OutputStream;", "setTcpNoDelay", "on", "getTcpNoDelay", "setSoLinger", "linger", "getSoLinger", "sendUrgentData", "data", "setOOBInline", "getOOBInline", "setSendBufferSize", "size", "getSendBufferSize", "setReceiveBufferSize", "getReceiveBufferSize", "setKeepAlive", "getKeepAlive", "setTrafficClass", "tc", "getTrafficClass", "setReuseAddress", "getReuseAddress", "shutdownInput", "shutdownOutput", "isConnected", "isBound", "isClosed", "isInputShutdown", "isOutputShutdown", "setOption", "T", "", "name", "Ljava/net/SocketOption;", "value", "(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/net/Socket;", "getOption", "(Ljava/net/SocketOption;)Ljava/lang/Object;", "supportedOptions", "", "Output", "Input", "ziti"})
@SourceDebugExtension(value={"SMAP\nSocketChannelSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketChannelSocket.kt\norg/openziti/net/internal/SocketChannelSocket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
public final class SocketChannelSocket
extends Socket {
    @NotNull
    private final SocketChannel ch;
    private boolean inputShut;
    private boolean outputShut;
    @NotNull
    private final Selector sel;
    @NotNull
    private final SelectionKey selKey;

    public SocketChannelSocket(@NotNull SocketChannel ch) {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        super((SocketImpl)null);
        this.ch = ch;
        this.ch.configureBlocking(false);
        AbstractSelector abstractSelector = this.ch.provider().openSelector();
        Intrinsics.checkNotNullExpressionValue((Object)abstractSelector, (String)"openSelector(...)");
        this.sel = abstractSelector;
        SelectionKey selectionKey = this.ch.register(this.sel, 8);
        Intrinsics.checkNotNullExpressionValue((Object)selectionKey, (String)"register(...)");
        this.selKey = selectionKey;
    }

    @NotNull
    public final SocketChannel getCh() {
        return this.ch;
    }

    public SocketChannelSocket() {
        SocketChannel socketChannel = SocketChannel.open();
        Intrinsics.checkNotNullExpressionValue((Object)socketChannel, (String)"open(...)");
        this(socketChannel);
    }

    @Override
    public void bind(@Nullable SocketAddress bindpoint) {
        this.ch.bind(bindpoint);
    }

    @Override
    public void close() {
        Object object;
        Object $this$close_u24lambda_u240;
        Closeable closeable = this.sel;
        try {
            $this$close_u24lambda_u240 = closeable;
            boolean bl = false;
            ((Selector)$this$close_u24lambda_u240).close();
            $this$close_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$close_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        closeable = this.ch;
        try {
            Closeable $this$close_u24lambda_u241 = closeable;
            boolean bl = false;
            ((AbstractInterruptibleChannel)$this$close_u24lambda_u241).close();
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    @Override
    public void connect(@Nullable SocketAddress endpoint) {
        this.connect(endpoint, 0);
    }

    @Override
    public void connect(@Nullable SocketAddress endpoint, int timeout) {
        if (timeout == 0) {
            this.ch.configureBlocking(true);
            this.ch.connect(endpoint);
            this.ch.configureBlocking(false);
            this.selKey.interestOps(1);
            return;
        }
        this.ch.configureBlocking(false);
        if (this.ch.connect(endpoint)) {
            this.selKey.interestOps(1);
            return;
        }
        long start2 = System.currentTimeMillis();
        do {
            this.sel.select(timeout);
            if (!this.selKey.isConnectable()) continue;
            if (this.ch.finishConnect()) {
                this.selKey.interestOps(1);
            } else {
                this.close();
            }
            return;
        } while (System.currentTimeMillis() - start2 <= (long)timeout);
        this.close();
        throw new SocketTimeoutException();
    }

    @Override
    @Nullable
    public InetAddress getInetAddress() {
        return this.getRemoteSocketAddress().getAddress();
    }

    @Override
    @Nullable
    public InetAddress getLocalAddress() {
        SocketAddress socketAddress = this.ch.getLocalAddress();
        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        return ((InetSocketAddress)socketAddress).getAddress();
    }

    @Override
    public int getPort() {
        return this.getRemoteSocketAddress().getPort();
    }

    @Override
    public int getLocalPort() {
        return this.getLocalSocketAddress().getPort();
    }

    @Override
    @NotNull
    public InetSocketAddress getRemoteSocketAddress() {
        SocketAddress socketAddress = this.ch.getRemoteAddress();
        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        return (InetSocketAddress)socketAddress;
    }

    @Override
    @NotNull
    public InetSocketAddress getLocalSocketAddress() {
        SocketAddress socketAddress = this.ch.getLocalAddress();
        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        return (InetSocketAddress)socketAddress;
    }

    @Override
    @NotNull
    public SocketChannel getChannel() {
        return this.ch;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return new Input();
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        return new Output();
    }

    @Override
    public void setTcpNoDelay(boolean on) {
        this.ch.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)on);
    }

    @Override
    public boolean getTcpNoDelay() {
        Boolean bl = this.ch.getOption(StandardSocketOptions.TCP_NODELAY);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getOption(...)");
        return bl;
    }

    @Override
    public void setSoLinger(boolean on, int linger) {
        this.ch.setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)linger);
    }

    @Override
    public int getSoLinger() {
        Integer n = this.ch.getOption(StandardSocketOptions.SO_LINGER);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOption(...)");
        return ((Number)n).intValue();
    }

    @Override
    public void sendUrgentData(int data2) {
        throw new IllegalStateException("not supported".toString());
    }

    @Override
    public void setOOBInline(boolean on) {
        throw new IllegalStateException("not supported".toString());
    }

    @Override
    public boolean getOOBInline() {
        throw new IllegalStateException("not supported".toString());
    }

    @Override
    public void setSendBufferSize(int size) {
        this.ch.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)size);
    }

    @Override
    public int getSendBufferSize() {
        Integer n = this.ch.getOption(StandardSocketOptions.SO_SNDBUF);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOption(...)");
        return ((Number)n).intValue();
    }

    @Override
    public void setReceiveBufferSize(int size) {
        this.ch.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)size);
    }

    @Override
    public int getReceiveBufferSize() {
        Integer n = this.ch.getOption(StandardSocketOptions.SO_RCVBUF);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOption(...)");
        return ((Number)n).intValue();
    }

    @Override
    public void setKeepAlive(boolean on) {
        this.ch.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)on);
    }

    @Override
    public boolean getKeepAlive() {
        Boolean bl = this.ch.getOption(StandardSocketOptions.SO_KEEPALIVE);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getOption(...)");
        return bl;
    }

    @Override
    public void setTrafficClass(int tc) {
        this.ch.setOption((SocketOption)StandardSocketOptions.IP_TOS, (Object)tc);
    }

    @Override
    public int getTrafficClass() {
        Integer n = this.ch.getOption(StandardSocketOptions.IP_TOS);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOption(...)");
        return ((Number)n).intValue();
    }

    @Override
    public void setReuseAddress(boolean on) {
        this.ch.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)on);
    }

    @Override
    public boolean getReuseAddress() {
        Boolean bl = this.ch.getOption(StandardSocketOptions.SO_REUSEADDR);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getOption(...)");
        return bl;
    }

    @Override
    public void shutdownInput() {
        this.ch.shutdownInput();
        this.inputShut = true;
    }

    @Override
    public void shutdownOutput() {
        this.ch.shutdownOutput();
        this.outputShut = true;
    }

    @Override
    public boolean isConnected() {
        return this.ch.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.ch.getLocalAddress() != null;
    }

    @Override
    public boolean isClosed() {
        return !this.ch.isOpen();
    }

    @Override
    public boolean isInputShutdown() {
        return this.ch.isConnected() && this.inputShut;
    }

    @Override
    public boolean isOutputShutdown() {
        return this.ch.isConnected() && this.outputShut;
    }

    @Override
    @NotNull
    public <T> Socket setOption(@Nullable SocketOption<T> name, T value) {
        SocketChannelSocket socketChannelSocket;
        SocketChannelSocket $this$setOption_u24lambda_u242 = socketChannelSocket = this;
        boolean bl = false;
        $this$setOption_u24lambda_u242.ch.setOption((SocketOption)name, (Object)value);
        return socketChannelSocket;
    }

    @Override
    public <T> T getOption(@Nullable SocketOption<T> name) {
        return this.ch.getOption(name);
    }

    @Override
    @NotNull
    public Set<SocketOption<?>> supportedOptions() {
        Set<SocketOption<?>> set = this.ch.supportedOptions();
        Intrinsics.checkNotNullExpressionValue(set, (String)"supportedOptions(...)");
        return set;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/openziti/net/internal/SocketChannelSocket$Input;", "Ljava/io/InputStream;", "<init>", "(Lorg/openziti/net/internal/SocketChannelSocket;)V", "read", "", "b", "", "off", "len", "close", "", "ziti"})
    public final class Input
    extends InputStream {
        @Override
        public int read() {
            byte[] b = new byte[1];
            int rc = this.read(b);
            if (rc == -1) {
                return rc;
            }
            return b[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            if (SocketChannelSocket.this.isInputShutdown()) {
                return -1;
            }
            ByteBuffer buf = ByteBuffer.wrap(b, off, len);
            long start2 = System.currentTimeMillis();
            int timeout = SocketChannelSocket.this.getSoTimeout();
            SelectionKey selectionKey = SocketChannelSocket.this.selKey;
            SocketChannelSocket socketChannelSocket = SocketChannelSocket.this;
            SelectionKey selectionKey2 = selectionKey;
            synchronized (selectionKey2) {
                int count;
                block9: {
                    boolean bl = false;
                    int rc = socketChannelSocket.getCh().read(buf);
                    if (rc == 0) break block9;
                    int n = rc;
                    return n;
                }
                block4: while (true) {
                    SelectionKey k;
                    long toRemaining = 0L;
                    if (timeout > 0) {
                        long elapsed = System.currentTimeMillis() - start2;
                        if (elapsed >= (long)timeout) {
                            throw new SocketTimeoutException();
                        }
                        toRemaining = (long)timeout - elapsed;
                    }
                    socketChannelSocket.sel.select(toRemaining);
                    Iterator<SelectionKey> iterator = socketChannelSocket.sel.selectedKeys().iterator();
                    do {
                        if (!iterator.hasNext()) continue block4;
                    } while (!(k = iterator.next()).isReadable() || (count = socketChannelSocket.getCh().read(buf)) == 0);
                    break;
                }
                int n = count;
                return n;
            }
        }

        @Override
        public void close() {
            SocketChannelSocket.this.shutdownInput();
            SocketChannelSocket.this.sel.close();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/openziti/net/internal/SocketChannelSocket$Output;", "Ljava/io/OutputStream;", "<init>", "(Lorg/openziti/net/internal/SocketChannelSocket;)V", "write", "", "b", "", "", "off", "len", "ziti"})
    public final class Output
    extends OutputStream {
        @Override
        public void write(int b) {
            byte[] byArray = new byte[]{(byte)b};
            this.write(byArray);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            ByteBuffer buf = ByteBuffer.wrap(b, off, len);
            int timeout = SocketChannelSocket.this.getSoTimeout();
            long start2 = System.currentTimeMillis();
            while (buf.hasRemaining()) {
                if (SocketChannelSocket.this.getCh().write(buf) != 0) continue;
                long toRemaining = (long)timeout - (System.currentTimeMillis() - start2);
                if (toRemaining <= 0L) {
                    this.close();
                    throw new SocketTimeoutException();
                }
                SocketChannelSocket.this.sel.select(toRemaining);
            }
        }
    }
}

