/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.util;

import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Signature;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\u00120\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/openziti/util/PrivateKeySigner;", "Lorg/bouncycastle/operator/ContentSigner;", "key", "Ljava/security/PrivateKey;", "sigAlg", "", "<init>", "(Ljava/security/PrivateKey;Ljava/lang/String;)V", "getKey", "()Ljava/security/PrivateKey;", "getSigAlg", "()Ljava/lang/String;", "sig", "Ljava/security/Signature;", "kotlin.jvm.PlatformType", "getSig", "()Ljava/security/Signature;", "getAlgorithmIdentifier", "Lorg/bouncycastle/asn1/x509/AlgorithmIdentifier;", "getOutputStream", "Ljava/io/OutputStream;", "getSignature", "", "ziti"})
public final class PrivateKeySigner
implements ContentSigner {
    @NotNull
    private final PrivateKey key;
    @NotNull
    private final String sigAlg;
    private final Signature sig;

    public PrivateKeySigner(@NotNull PrivateKey key, @NotNull String sigAlg) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)sigAlg, (String)"sigAlg");
        this.key = key;
        this.sigAlg = sigAlg;
        this.sig = Signature.getInstance(this.sigAlg);
        this.sig.initSign(this.key);
    }

    @NotNull
    public final PrivateKey getKey() {
        return this.key;
    }

    @NotNull
    public final String getSigAlg() {
        return this.sigAlg;
    }

    public final Signature getSig() {
        return this.sig;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return new DefaultSignatureAlgorithmIdentifierFinder().find(this.sigAlg);
    }

    @NotNull
    public OutputStream getOutputStream() {
        return new OutputStream(this){
            final /* synthetic */ PrivateKeySigner this$0;
            {
                this.this$0 = $receiver;
            }

            public void write(int b) {
                this.this$0.getSig().update((byte)b);
            }

            public void write(byte[] b) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                this.this$0.getSig().update(b);
            }

            public void write(byte[] b, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                this.this$0.getSig().update(b, off, len);
            }
        };
    }

    @NotNull
    public byte[] getSignature() {
        byte[] byArray = this.sig.sign();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sign(...)");
        return byArray;
    }
}

