/*
 * Decompiled with CFR 0.152.
 */
package org.openziti;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.Identity;
import org.openziti.identity.UtilKt;
import org.openziti.util.CertsKt;

@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0087\b\u0018\u0000 ,2\u00020\u0001:\u0002+,B+\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000f\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0000\u00a2\u0006\u0002\b\u001dJ\u0013\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0000\u00a2\u0006\u0002\b\u001fJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J/\u0010#\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006-"}, d2={"Lorg/openziti/IdentityConfig;", "Lorg/openziti/Identity;", "controller", "", "apiEndpoints", "", "id", "Lorg/openziti/IdentityConfig$Id;", "<init>", "(Ljava/lang/String;Ljava/util/Collection;Lorg/openziti/IdentityConfig$Id;)V", "getController", "()Ljava/lang/String;", "getApiEndpoints", "()Ljava/util/Collection;", "getId", "()Lorg/openziti/IdentityConfig$Id;", "store", "", "output", "Ljava/io/OutputStream;", "controllers", "sslContext", "Ljavax/net/ssl/SSLContext;", "key", "Ljava/security/PrivateKey;", "key$ziti", "cert", "", "Ljava/security/cert/X509Certificate;", "cert$ziti", "caCerts", "caCerts$ziti", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Id", "Companion", "ziti"})
@SourceDebugExtension(value={"SMAP\nIdentityConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdentityConfig.kt\norg/openziti/IdentityConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
public final class IdentityConfig
implements Identity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String controller;
    @Nullable
    private final Collection<String> apiEndpoints;
    @NotNull
    private final Id id;
    @NotNull
    private static final ObjectMapper jsonMapper;

    public IdentityConfig(@JsonProperty(value="ztAPI") @NotNull String controller, @JsonProperty(value="ztAPIs") @Nullable Collection<String> apiEndpoints, @NotNull Id id) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.controller = controller;
        this.apiEndpoints = apiEndpoints;
        this.id = id;
    }

    public /* synthetic */ IdentityConfig(String string, Collection collection, Id id, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            collection = CollectionsKt.listOf((Object)string);
        }
        this(string, collection, id);
    }

    @NotNull
    public final String getController() {
        return this.controller;
    }

    @Nullable
    public final Collection<String> getApiEndpoints() {
        return this.apiEndpoints;
    }

    @NotNull
    public final Id getId() {
        return this.id;
    }

    public final void store(@NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        jsonMapper.writeValue(output, (Object)this);
    }

    @Override
    @NotNull
    public Collection<String> controllers() {
        Collection collection = this.apiEndpoints;
        if (collection == null) {
            collection = CollectionsKt.listOf((Object)this.controller);
        }
        return collection;
    }

    @Override
    @NotNull
    public SSLContext sslContext() {
        return UtilKt.makeSSLContext(this.key$ziti(), (Collection<? extends X509Certificate>)this.cert$ziti(), (Collection<? extends X509Certificate>)this.caCerts$ziti());
    }

    @Nullable
    public final PrivateKey key$ziti() {
        PrivateKey privateKey;
        String string = this.id.getKey();
        if (string != null) {
            String it = string;
            boolean bl = false;
            privateKey = CertsKt.readKey(it);
        } else {
            privateKey = null;
        }
        return privateKey;
    }

    @NotNull
    public final List<X509Certificate> cert$ziti() {
        Object object;
        block3: {
            block2: {
                object = this.id.getCert();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                List<X509Certificate> list = CertsKt.readCerts(it);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<X509Certificate> caCerts$ziti() {
        return CertsKt.readCerts(this.id.getCa());
    }

    @NotNull
    public final String component1() {
        return this.controller;
    }

    @Nullable
    public final Collection<String> component2() {
        return this.apiEndpoints;
    }

    @NotNull
    public final Id component3() {
        return this.id;
    }

    @NotNull
    public final IdentityConfig copy(@JsonProperty(value="ztAPI") @NotNull String controller, @JsonProperty(value="ztAPIs") @Nullable Collection<String> apiEndpoints, @NotNull Id id) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new IdentityConfig(controller, apiEndpoints, id);
    }

    public static /* synthetic */ IdentityConfig copy$default(IdentityConfig identityConfig, String string, Collection collection, Id id, int n, Object object) {
        if ((n & 1) != 0) {
            string = identityConfig.controller;
        }
        if ((n & 2) != 0) {
            collection = identityConfig.apiEndpoints;
        }
        if ((n & 4) != 0) {
            id = identityConfig.id;
        }
        return identityConfig.copy(string, collection, id);
    }

    @NotNull
    public String toString() {
        return "IdentityConfig(controller=" + this.controller + ", apiEndpoints=" + this.apiEndpoints + ", id=" + this.id + ")";
    }

    public int hashCode() {
        int result = this.controller.hashCode();
        result = result * 31 + (this.apiEndpoints == null ? 0 : ((Object)this.apiEndpoints).hashCode());
        result = result * 31 + this.id.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IdentityConfig)) {
            return false;
        }
        IdentityConfig identityConfig = (IdentityConfig)other;
        if (!Intrinsics.areEqual((Object)this.controller, (Object)identityConfig.controller)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.apiEndpoints, identityConfig.apiEndpoints)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.id, (Object)identityConfig.id);
    }

    @JvmStatic
    @NotNull
    public static final IdentityConfig load(@NotNull InputStream input) {
        return Companion.load(input);
    }

    @JvmStatic
    @NotNull
    public static final IdentityConfig load(@NotNull byte[] cfg) {
        return Companion.load(cfg);
    }

    @JvmStatic
    @NotNull
    public static final IdentityConfig load(@NotNull File f) {
        return Companion.load(f);
    }

    @JvmStatic
    @NotNull
    public static final IdentityConfig load(@NotNull String cfg) {
        return Companion.load(cfg);
    }

    static {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)ExtensionsKt.kotlinModule$default(null, (int)1, null));
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"registerModule(...)");
        jsonMapper = objectMapper;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0010H\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/openziti/IdentityConfig$Companion;", "", "<init>", "()V", "jsonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJsonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "load", "Lorg/openziti/IdentityConfig;", "input", "Ljava/io/InputStream;", "cfg", "", "f", "Ljava/io/File;", "", "ziti"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectMapper getJsonMapper() {
            return jsonMapper;
        }

        @JvmStatic
        @NotNull
        public final IdentityConfig load(@NotNull InputStream input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Object object = this.getJsonMapper().readValue(input, IdentityConfig.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            return (IdentityConfig)object;
        }

        @JvmStatic
        @NotNull
        public final IdentityConfig load(@NotNull byte[] cfg) {
            Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
            return this.load(new ByteArrayInputStream(cfg));
        }

        @JvmStatic
        @NotNull
        public final IdentityConfig load(@NotNull File f) {
            Intrinsics.checkNotNullParameter((Object)f, (String)"f");
            return this.load(new FileInputStream(f));
        }

        @JvmStatic
        @NotNull
        public final IdentityConfig load(@NotNull String cfg) {
            Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
            File file = new File(cfg);
            if (file.exists()) {
                return this.load(file);
            }
            String string = cfg;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return this.load(byArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J+\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/openziti/IdentityConfig$Id;", "", "key", "", "cert", "ca", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "getCert", "getCa", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "ziti"})
    public static final class Id {
        @Nullable
        private final String key;
        @Nullable
        private final String cert;
        @NotNull
        private final String ca;

        public Id(@Nullable String key, @Nullable String cert, @NotNull String ca) {
            Intrinsics.checkNotNullParameter((Object)ca, (String)"ca");
            this.key = key;
            this.cert = cert;
            this.ca = ca;
        }

        public /* synthetic */ Id(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2, string3);
        }

        @Nullable
        public final String getKey() {
            return this.key;
        }

        @Nullable
        public final String getCert() {
            return this.cert;
        }

        @NotNull
        public final String getCa() {
            return this.ca;
        }

        @Nullable
        public final String component1() {
            return this.key;
        }

        @Nullable
        public final String component2() {
            return this.cert;
        }

        @NotNull
        public final String component3() {
            return this.ca;
        }

        @NotNull
        public final Id copy(@Nullable String key, @Nullable String cert, @NotNull String ca) {
            Intrinsics.checkNotNullParameter((Object)ca, (String)"ca");
            return new Id(key, cert, ca);
        }

        public static /* synthetic */ Id copy$default(Id id, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = id.key;
            }
            if ((n & 2) != 0) {
                string2 = id.cert;
            }
            if ((n & 4) != 0) {
                string3 = id.ca;
            }
            return id.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Id(key=" + this.key + ", cert=" + this.cert + ", ca=" + this.ca + ")";
        }

        public int hashCode() {
            int result = this.key == null ? 0 : this.key.hashCode();
            result = result * 31 + (this.cert == null ? 0 : this.cert.hashCode());
            result = result * 31 + this.ca.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Id)) {
                return false;
            }
            Id id = (Id)other;
            if (!Intrinsics.areEqual((Object)this.key, (Object)id.key)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cert, (Object)id.cert)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.ca, (Object)id.ca);
        }
    }
}

