/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.identity;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.Key;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.Enrollment;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0003!\"#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0016\u001a\u00020\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0010\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001b\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014R\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Lorg/openziti/identity/ZitiJWT;", "", "cl", "Lio/jsonwebtoken/Claims;", "serverKey", "Ljava/security/Key;", "<init>", "(Lio/jsonwebtoken/Claims;Ljava/security/Key;)V", "getServerKey", "()Ljava/security/Key;", "claims", "controller", "Ljava/net/URI;", "getController", "()Ljava/net/URI;", "controller$delegate", "Lkotlin/Lazy;", "token", "", "getToken", "()Ljava/lang/String;", "token$delegate", "method", "Lorg/openziti/Enrollment$Method;", "getMethod", "()Lorg/openziti/Enrollment$Method;", "method$delegate", "name", "getName", "enrollmentURL", "Ljava/net/URL;", "getEnrollmentURL", "()Ljava/net/URL;", "Companion", "JwtTrustManager", "KeyResolver", "ziti"})
public final class ZitiJWT {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Key serverKey;
    @NotNull
    private final Claims claims;
    @NotNull
    private final Lazy controller$delegate;
    @NotNull
    private final Lazy token$delegate;
    @NotNull
    private final Lazy method$delegate;

    public ZitiJWT(@NotNull Claims cl, @NotNull Key serverKey) {
        Intrinsics.checkNotNullParameter((Object)cl, (String)"cl");
        Intrinsics.checkNotNullParameter((Object)serverKey, (String)"serverKey");
        this.serverKey = serverKey;
        this.claims = cl;
        this.controller$delegate = LazyKt.lazy(() -> ZitiJWT.controller_delegate$lambda$0(this));
        this.token$delegate = LazyKt.lazy(() -> ZitiJWT.token_delegate$lambda$1(this));
        this.method$delegate = LazyKt.lazy(() -> ZitiJWT.method_delegate$lambda$2(this));
    }

    @NotNull
    public final Key getServerKey() {
        return this.serverKey;
    }

    @NotNull
    public final URI getController() {
        Lazy lazy = this.controller$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (URI)object;
    }

    @NotNull
    public final String getToken() {
        Lazy lazy = this.token$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (String)object;
    }

    @NotNull
    public final Enrollment.Method getMethod() {
        Lazy lazy = this.method$delegate;
        return (Enrollment.Method)((Object)lazy.getValue());
    }

    @NotNull
    public final String getName() {
        Object object = this.claims.get("sub", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (String)object;
    }

    @NotNull
    public final URL getEnrollmentURL() {
        URL uRL = this.getController().resolve("/enroll?method=" + this.getMethod() + "&token=" + this.getToken()).toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    private static final URI controller_delegate$lambda$0(ZitiJWT this$0) {
        return URI.create((String)this$0.claims.get("iss", String.class));
    }

    private static final String token_delegate$lambda$1(ZitiJWT this$0) {
        return (String)this$0.claims.get("jti", String.class);
    }

    private static final Enrollment.Method method_delegate$lambda$2(ZitiJWT this$0) {
        String s = (String)this$0.claims.get("em", String.class);
        Intrinsics.checkNotNull((Object)s);
        return Enrollment.Method.valueOf(s);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/openziti/identity/ZitiJWT$Companion;", "", "<init>", "()V", "fromJWT", "Lorg/openziti/identity/ZitiJWT;", "jwt", "", "ziti"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ZitiJWT fromJWT(@NotNull String jwt) {
            Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
            JwtTrustManager tm = new JwtTrustManager();
            JwtParser jwtParser = Jwts.parser().setSigningKeyResolver((SigningKeyResolver)new KeyResolver(tm)).build();
            Object object = jwtParser.parse((CharSequence)jwt).getBody();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.jsonwebtoken.Claims");
            Claims claims = (Claims)object;
            return new ZitiJWT(claims, tm.getServerKey());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000e\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J'\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0014\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0018R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/openziti/identity/ZitiJWT$JwtTrustManager;", "Ljavax/net/ssl/X509TrustManager;", "<init>", "()V", "serverKey", "Ljava/security/Key;", "getServerKey", "()Ljava/security/Key;", "setServerKey", "(Ljava/security/Key;)V", "checkClientTrusted", "", "p0", "", "Ljava/security/cert/X509Certificate;", "p1", "", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)Ljava/lang/Void;", "checkServerTrusted", "", "certs", "authType", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)V", "getAcceptedIssuers", "()[Ljava/security/cert/X509Certificate;", "ziti"})
    public static final class JwtTrustManager
    implements X509TrustManager {
        public Key serverKey;

        @NotNull
        public final Key getServerKey() {
            Key key = this.serverKey;
            if (key != null) {
                return key;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverKey");
            return null;
        }

        public final void setServerKey(@NotNull Key key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"<set-?>");
            this.serverKey = key;
        }

        @NotNull
        public Void checkClientTrusted(@Nullable X509Certificate[] p0, @Nullable String p1) {
            String string = "not needed";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void checkServerTrusted(@Nullable X509Certificate[] certs, @NotNull String authType) {
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
            Object object = certs;
            PublicKey publicKey = certs != null && (object = (X509Certificate)ArraysKt.first((Object[])object)) != null ? ((Certificate)object).getPublicKey() : null;
            if (publicKey == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            this.setServerKey(publicKey);
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\b\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/openziti/identity/ZitiJWT$KeyResolver;", "Lio/jsonwebtoken/SigningKeyResolver;", "tm", "Lorg/openziti/identity/ZitiJWT$JwtTrustManager;", "<init>", "(Lorg/openziti/identity/ZitiJWT$JwtTrustManager;)V", "getTm", "()Lorg/openziti/identity/ZitiJWT$JwtTrustManager;", "resolveSigningKey", "Ljava/security/Key;", "header", "Lio/jsonwebtoken/JwsHeader;", "claims", "Lio/jsonwebtoken/Claims;", "", "content", "", "ziti"})
    public static final class KeyResolver
    implements SigningKeyResolver {
        @NotNull
        private final JwtTrustManager tm;

        public KeyResolver(@NotNull JwtTrustManager tm) {
            Intrinsics.checkNotNullParameter((Object)tm, (String)"tm");
            this.tm = tm;
        }

        @NotNull
        public final JwtTrustManager getTm() {
            return this.tm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Key resolveSigningKey(@NotNull JwsHeader header, @NotNull Claims claims) {
            SSLContext sSLContext;
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            Intrinsics.checkNotNullParameter((Object)claims, (String)"claims");
            SSLContext $this$resolveSigningKey_u24lambda_u240 = sSLContext = SSLContext.getInstance("TLSv1.2");
            boolean bl = false;
            JwtTrustManager[] jwtTrustManagerArray = new JwtTrustManager[]{this.tm};
            $this$resolveSigningKey_u24lambda_u240.init(null, jwtTrustManagerArray, new SecureRandom());
            SSLContext ssl = sSLContext;
            URL url = URI.create(String.valueOf(claims.get((Object)"iss"))).toURL();
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
            HttpsURLConnection conn = (HttpsURLConnection)uRLConnection;
            conn.setSSLSocketFactory(ssl.getSocketFactory());
            try {
                conn.connect();
                Key key = this.tm.getServerKey();
                return key;
            }
            finally {
                conn.disconnect();
            }
        }

        @NotNull
        public Void resolveSigningKey(@Nullable JwsHeader header, @Nullable byte[] content) {
            throw new NotImplementedError(null, 1, null);
        }
    }
}

