/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.InterruptedByTimeoutException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.net.internal.Sockets;
import org.openziti.net.nio.AsyncSocketImpl;
import org.openziti.net.nio.NetUtilsKt;
import org.openziti.util.Logged;
import org.openziti.util.ZitiLog;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0003PQRB\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u001a\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0012\u0010!\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0014J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020 H\u0014J\b\u0010%\u001a\u00020\u001eH\u0014J\b\u0010&\u001a\u00020 H\u0014J\b\u0010'\u001a\u00020 H\u0014J\b\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020)H\u0014J\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020-H\u0014J\u0018\u0010.\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020/2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0018\u0010.\u001a\u00020)2\u0006\u00100\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0018\u0010.\u001a\u00020)2\u0006\u00100\u001a\u0002012\u0006\u0010\u0017\u001a\u00020 H\u0014J\b\u00102\u001a\u000203H\u0016J\r\u00104\u001a\u00020-H\u0000\u00a2\u0006\u0002\b5J\u0006\u00106\u001a\u00020-J\b\u00107\u001a\u00020)H\u0014J\r\u00108\u001a\u00020)H\u0000\u00a2\u0006\u0002\b9J\u0012\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020 H\u0016J\u001a\u0010=\u001a\u00020)2\u0006\u0010<\u001a\u00020 2\b\u0010>\u001a\u0004\u0018\u00010;H\u0016J\b\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u00020 H\u0014J\u0010\u0010B\u001a\u00020)2\u0006\u0010C\u001a\u00020 H\u0014J\u0010\u0010D\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020FH\u0002J\u0011\u0010G\u001a\u00020)2\u0006\u0010H\u001a\u00020/H\u0096\u0001J\u001b\u0010G\u001a\u00020)2\u0010\u0010H\u001a\f\u0012\u0004\u0012\u00020/0Ij\u0002`JH\u0096\u0001J\u0011\u0010K\u001a\u00020)2\u0006\u0010H\u001a\u00020/H\u0096\u0001J\u0019\u0010K\u001a\u00020)2\u0006\u0010H\u001a\u00020/2\u0006\u0010L\u001a\u00020FH\u0096\u0001J\u001b\u0010K\u001a\u00020)2\u0010\u0010H\u001a\f\u0012\u0004\u0012\u00020/0Ij\u0002`JH\u0096\u0001J%\u0010K\u001a\u00020)2\b\u0010E\u001a\u0004\u0018\u00010F2\u0010\u0010H\u001a\f\u0012\u0004\u0012\u00020/0Ij\u0002`JH\u0096\u0001J\u0011\u0010M\u001a\u00020)2\u0006\u0010H\u001a\u00020/H\u0096\u0001J\u001b\u0010M\u001a\u00020)2\u0010\u0010H\u001a\f\u0012\u0004\u0012\u00020/0Ij\u0002`JH\u0096\u0001J\u0011\u0010L\u001a\u00020)2\u0006\u0010H\u001a\u00020/H\u0096\u0001J\u001b\u0010L\u001a\u00020)2\u0010\u0010H\u001a\f\u0012\u0004\u0012\u00020/0Ij\u0002`JH\u0096\u0001J\u0011\u0010N\u001a\u00020)2\u0006\u0010H\u001a\u00020/H\u0096\u0001J\u001b\u0010N\u001a\u00020)2\u0010\u0010H\u001a\f\u0012\u0004\u0012\u00020/0Ij\u0002`JH\u0096\u0001J\u0011\u0010O\u001a\u00020)2\u0006\u0010H\u001a\u00020/H\u0096\u0001J\u001b\u0010O\u001a\u00020)2\u0010\u0010H\u001a\f\u0012\u0004\u0012\u00020/0Ij\u0002`JH\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\bX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006S"}, d2={"Lorg/openziti/net/nio/AsyncSocketImpl;", "Ljava/net/SocketImpl;", "Lorg/openziti/util/Logged;", "connector", "Lorg/openziti/net/nio/AsyncSocketImpl$Connector;", "<init>", "(Lorg/openziti/net/nio/AsyncSocketImpl$Connector;)V", "ch", "Ljava/nio/channels/AsynchronousSocketChannel;", "(Ljava/nio/channels/AsynchronousSocketChannel;)V", "channel", "getChannel$ziti", "()Ljava/nio/channels/AsynchronousSocketChannel;", "setChannel$ziti", "inputLock", "Ljava/util/concurrent/Semaphore;", "getInputLock$ziti", "()Ljava/util/concurrent/Semaphore;", "input", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "getInput$ziti", "()Ljava/nio/ByteBuffer;", "timeout", "Ljava/util/concurrent/atomic/AtomicInteger;", "getTimeout$ziti", "()Ljava/util/concurrent/atomic/AtomicInteger;", "bind", "", "host", "Ljava/net/InetAddress;", "port", "", "accept", "s", "listen", "backlog", "getInetAddress", "getPort", "getLocalPort", "shutdownInput", "", "shutdownOutput", "create", "stream", "", "connect", "", "address", "Ljava/net/SocketAddress;", "getInputStream", "Ljava/io/InputStream;", "isConnected", "isConnected$ziti", "isClosed", "close", "closeInternal", "closeInternal$ziti", "getOption", "", "optID", "setOption", "value", "getOutputStream", "Ljava/io/OutputStream;", "available", "sendUrgentData", "data", "throwIOException", "ex", "", "d", "msg", "Lkotlin/Function0;", "Lorg/openziti/util/LogMsg;", "e", "t", "i", "v", "w", "Connector", "DefaultConnector", "channelConnector", "ziti"})
@SourceDebugExtension(value={"SMAP\nAsyncSocketImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncSocketImpl.kt\norg/openziti/net/nio/AsyncSocketImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n1#2:254\n*E\n"})
public final class AsyncSocketImpl
extends SocketImpl
implements Logged {
    private final /* synthetic */ ZitiLog $$delegate_0;
    @NotNull
    private final Connector connector;
    public AsynchronousSocketChannel channel;
    @NotNull
    private final Semaphore inputLock;
    private final ByteBuffer input;
    @NotNull
    private final AtomicInteger timeout;

    /*
     * WARNING - void declaration
     */
    public AsyncSocketImpl(@NotNull Connector connector) {
        void $this$input_u24lambda_u240;
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        this.$$delegate_0 = new ZitiLog();
        this.connector = connector;
        this.inputLock = new Semaphore(1);
        ByteBuffer byteBuffer2 = byteBuffer = ByteBuffer.allocate(32768);
        AsyncSocketImpl asyncSocketImpl = this;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$input_u24lambda_u240, (String)"null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)$this$input_u24lambda_u240).flip();
        asyncSocketImpl.input = byteBuffer;
        this.timeout = new AtomicInteger(Sockets.INSTANCE.getDefaultSoTimeout());
    }

    public /* synthetic */ AsyncSocketImpl(Connector connector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            connector = DefaultConnector.INSTANCE;
        }
        this(connector);
    }

    public AsyncSocketImpl(@NotNull AsynchronousSocketChannel ch) {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        this(new channelConnector(ch));
        this.setChannel$ziti(ch);
    }

    @NotNull
    public final AsynchronousSocketChannel getChannel$ziti() {
        AsynchronousSocketChannel asynchronousSocketChannel = this.channel;
        if (asynchronousSocketChannel != null) {
            return asynchronousSocketChannel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"channel");
        return null;
    }

    public final void setChannel$ziti(@NotNull AsynchronousSocketChannel asynchronousSocketChannel) {
        Intrinsics.checkNotNullParameter((Object)asynchronousSocketChannel, (String)"<set-?>");
        this.channel = asynchronousSocketChannel;
    }

    @NotNull
    public final Semaphore getInputLock$ziti() {
        return this.inputLock;
    }

    public final ByteBuffer getInput$ziti() {
        return this.input;
    }

    @NotNull
    public final AtomicInteger getTimeout$ziti() {
        return this.timeout;
    }

    @NotNull
    protected Void bind(@Nullable InetAddress host, int port) {
        throw new IllegalStateException("only client sockets are supported".toString());
    }

    @NotNull
    protected Void accept(@Nullable SocketImpl s) {
        throw new IllegalStateException("only client sockets are supported".toString());
    }

    @NotNull
    protected Void listen(int backlog) {
        throw new IllegalStateException("only client sockets are supported".toString());
    }

    @Override
    @NotNull
    protected InetAddress getInetAddress() {
        InetAddress inetAddress;
        SocketAddress addr = this.getChannel$ziti().getRemoteAddress();
        if (addr instanceof InetSocketAddress) {
            InetAddress inetAddress2 = ((InetSocketAddress)addr).getAddress();
            inetAddress = inetAddress2;
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"getAddress(...)");
        } else {
            InetAddress inetAddress3 = InetAddress.getLoopbackAddress();
            inetAddress = inetAddress3;
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress3, (String)"getLoopbackAddress(...)");
        }
        return inetAddress;
    }

    @Override
    protected int getPort() {
        SocketAddress addr = this.getChannel$ziti().getRemoteAddress();
        return addr instanceof InetSocketAddress ? ((InetSocketAddress)addr).getPort() : 0;
    }

    @Override
    protected int getLocalPort() {
        SocketAddress addr = this.getChannel$ziti().getLocalAddress();
        return addr instanceof InetSocketAddress ? ((InetSocketAddress)addr).getPort() : 0;
    }

    @Override
    protected void shutdownInput() {
        this.getChannel$ziti().shutdownInput();
    }

    @Override
    protected void shutdownOutput() {
        this.getChannel$ziti().shutdownOutput();
    }

    @Override
    protected void create(boolean stream) {
        if (!stream) {
            boolean bl = false;
            String string = "only stream sockets are supported";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    protected void connect(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.connect(new InetSocketAddress(host, port), 0);
    }

    @Override
    protected void connect(@NotNull InetAddress address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.connect(new InetSocketAddress(address, port), 0);
    }

    @Override
    protected void connect(@NotNull SocketAddress address, int timeout) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        if (this.channel == null) {
            try {
                this.setChannel$ziti(this.connector.connect(address, timeout));
            }
            catch (IOException cex) {
                if (!Intrinsics.areEqual((Object)this.connector, (Object)DefaultConnector.INSTANCE)) {
                    this.setChannel$ziti(DefaultConnector.INSTANCE.connect(address, timeout));
                }
                throw cex;
            }
        } else {
            Object object;
            long longTO = timeout > 0 ? (long)timeout : Long.MAX_VALUE;
            Object object2 = this.getChannel$ziti().connect(address);
            try {
                Future<Void> $this$connect_u24lambda_u242 = object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)$this$connect_u24lambda_u242.get(longTO, TimeUnit.MILLISECONDS));
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl = false;
                this.throwIOException((Throwable)it);
                throw new KotlinNothingValueException();
            }
            Result.box-impl((Object)object2);
        }
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return new InputStream(this){
            final /* synthetic */ AsyncSocketImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public int read() {
                byte[] oneByte = new byte[1];
                int rc = this.read(oneByte, 0, 1);
                if (rc < 0) {
                    return -1;
                }
                return oneByte[0];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(byte[] b, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                ByteBuffer byteBuffer = this.this$0.getInput$ziti();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"<get-input>(...)");
                ByteBuffer byteBuffer2 = byteBuffer;
                AsyncSocketImpl asyncSocketImpl = this.this$0;
                ByteBuffer byteBuffer3 = byteBuffer2;
                synchronized (byteBuffer3) {
                    Object $this$read_u24lambda_u243_u24lambda_u240;
                    block8: {
                        boolean bl = false;
                        asyncSocketImpl.getInputLock$ziti().acquire();
                        int count = Math.min(len, asyncSocketImpl.getInput$ziti().remaining());
                        if (count <= 0) break block8;
                        asyncSocketImpl.getInput$ziti().get(b, off, count);
                        asyncSocketImpl.getInputLock$ziti().release();
                        int n = count;
                        return n;
                    }
                    asyncSocketImpl.getInput$ziti().compact();
                    Object object = asyncSocketImpl.getOption(4102);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
                    long to = ((Number)object).longValue();
                    Object object2 = asyncSocketImpl.getChannel$ziti();
                    try {
                        $this$read_u24lambda_u243_u24lambda_u240 = object2;
                        boolean bl = false;
                        $this$read_u24lambda_u243_u24lambda_u240 = Result.constructor-impl((Object)((Number)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>((AsynchronousSocketChannel)$this$read_u24lambda_u243_u24lambda_u240, asyncSocketImpl, to, null){
                            int label;
                            final /* synthetic */ AsynchronousSocketChannel $this_runCatching;
                            final /* synthetic */ AsyncSocketImpl this$0;
                            final /* synthetic */ long $to;
                            {
                                this.$this_runCatching = $receiver;
                                this.this$0 = $receiver2;
                                this.$to = $to;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        ByteBuffer byteBuffer = this.this$0.getInput$ziti();
                                        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"<get-input>(...)");
                                        this.label = 1;
                                        Object object3 = NetUtilsKt.readSuspend(this.$this_runCatching, byteBuffer, this.$to, TimeUnit.MILLISECONDS, (Continuation<? super Integer>)((Continuation)this));
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null)).intValue());
                    }
                    catch (Throwable bl) {
                        $this$read_u24lambda_u243_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    Object readCount2 = $this$read_u24lambda_u243_u24lambda_u240;
                    asyncSocketImpl.getInput$ziti().flip();
                    object2 = readCount2;
                    if (Result.isSuccess-impl((Object)object2)) {
                        int it = ((Number)object2).intValue();
                        boolean bl = false;
                        asyncSocketImpl.getInput$ziti().get(b, off, it);
                    }
                    asyncSocketImpl.getInputLock$ziti().release();
                    object2 = readCount2;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                    if (throwable != null) {
                        Throwable it = throwable;
                        boolean bl = false;
                        AsyncSocketImpl.access$throwIOException(asyncSocketImpl, it);
                        throw new KotlinNothingValueException();
                    }
                    int n = ((Number)object2).intValue();
                    return n;
                }
            }

            public int available() {
                return this.this$0.getInput$ziti().remaining();
            }
        };
    }

    public final boolean isConnected$ziti() {
        return this.channel != null && this.getChannel$ziti().getRemoteAddress() != null;
    }

    public final boolean isClosed() {
        return this.channel != null && !this.getChannel$ziti().isOpen();
    }

    @Override
    protected void close() {
        this.closeInternal$ziti();
    }

    public final void closeInternal$ziti() {
        if (this.channel == null) {
            this.setChannel$ziti(AsynchronousSocketChannel.open());
        }
        this.getChannel$ziti().close();
    }

    @Override
    @Nullable
    public Object getOption(int optID) {
        if (optID == 4102) {
            return this.timeout.get();
        }
        if (optID == 4099) {
            return false;
        }
        return null;
    }

    @Override
    public void setOption(int optID, @Nullable Object value) {
        if (optID == 4102) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Number");
            this.timeout.set(((Number)value).intValue());
        }
        if (optID == 4099) {
            throw new SocketException("SO_OOBINLINE is not supported");
        }
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        return new OutputStream(this){
            final /* synthetic */ AsyncSocketImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void write(int b) {
                byte[] byArray = new byte[]{(byte)b};
                this.write(byArray);
            }

            public void write(byte[] b, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                ByteBuffer buf = ByteBuffer.wrap(b, off, len);
                while (buf.hasRemaining()) {
                    Object object;
                    Object object2 = this.this$0.getChannel$ziti().write(buf);
                    AsyncSocketImpl asyncSocketImpl = this.this$0;
                    try {
                        Future<Integer> $this$write_u24lambda_u240 = object2;
                        boolean bl = false;
                        object = Result.constructor-impl((Object)(asyncSocketImpl.getTimeout$ziti().longValue() > 0L ? $this$write_u24lambda_u240.get(asyncSocketImpl.getTimeout$ziti().longValue(), TimeUnit.MILLISECONDS) : $this$write_u24lambda_u240.get()));
                    }
                    catch (Throwable bl) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    object2 = object;
                    asyncSocketImpl = this.this$0;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                    if (throwable == null) continue;
                    Object ex = object = throwable;
                    boolean bl = false;
                    asyncSocketImpl.w((Function0<String>)((Function0)() -> getOutputStream.1.write$lambda$2$lambda$1((Throwable)ex, b, off, len)));
                    AsyncSocketImpl.access$throwIOException(asyncSocketImpl, (Throwable)ex);
                    throw new KotlinNothingValueException();
                }
            }

            private static final String write$lambda$2$lambda$1(Throwable $ex, byte[] $b, int $off, int $len) {
                return "unexpected exception[" + $ex.getMessage() + "] during write[buf.len=" + $b.length + ", off=" + $off + ", len=" + $len + "]";
            }
        };
    }

    @Override
    protected int available() {
        return this.input.remaining();
    }

    @Override
    protected void sendUrgentData(int data2) {
        this.getOutputStream().write(data2);
    }

    private final Void throwIOException(Throwable ex) {
        if (ex instanceof InterruptedByTimeoutException) {
            throw new SocketTimeoutException(ex.getMessage());
        }
        if (ex instanceof IOException) {
            throw ex;
        }
        if (ex instanceof TimeoutException) {
            throw new SocketTimeoutException(ex.getMessage());
        }
        Throwable cause = ex.getCause();
        if (cause instanceof IOException) {
            throw cause;
        }
        throw new IOException("unexpected exception", ex);
    }

    @Override
    public void e(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.e(msg);
    }

    @Override
    public void e(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.e(msg);
    }

    @Override
    public void e(@NotNull String msg, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.$$delegate_0.e(msg, t);
    }

    @Override
    public void e(@Nullable Throwable ex, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.e(ex, msg);
    }

    @Override
    public void w(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.w(msg);
    }

    @Override
    public void w(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.w(msg);
    }

    @Override
    public void i(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.i(msg);
    }

    @Override
    public void i(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.i(msg);
    }

    @Override
    public void d(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.d(msg);
    }

    @Override
    public void d(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.d(msg);
    }

    @Override
    public void v(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.v(msg);
    }

    @Override
    public void v(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.v(msg);
    }

    @Override
    public void t(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.t(msg);
    }

    @Override
    public void t(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.t(msg);
    }

    public AsyncSocketImpl() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Void access$throwIOException(AsyncSocketImpl $this, Throwable ex) {
        return $this.throwIOException(ex);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J \u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/openziti/net/nio/AsyncSocketImpl$Connector;", "", "connect", "Ljava/nio/channels/AsynchronousSocketChannel;", "addr", "Ljava/net/SocketAddress;", "timeout", "", "doConnect", "ch", "ziti"})
    public static interface Connector {
        @NotNull
        public AsynchronousSocketChannel connect(@NotNull SocketAddress var1, int var2);

        @NotNull
        public AsynchronousSocketChannel doConnect(@NotNull AsynchronousSocketChannel var1, @NotNull SocketAddress var2, int var3);

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @NotNull
            public static AsynchronousSocketChannel doConnect(@NotNull Connector $this, @NotNull AsynchronousSocketChannel ch, @NotNull SocketAddress addr, int timeout) {
                Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
                try {
                    Future<Void> connOp = ch.connect(addr);
                    Void void_ = timeout > 0 ? connOp.get(timeout, TimeUnit.MILLISECONDS) : connOp.get();
                }
                catch (TimeoutException tox) {
                    throw new SocketTimeoutException(tox.getLocalizedMessage());
                }
                catch (ExecutionException xex) {
                    throw new IOException(xex.getCause());
                }
                return ch;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/openziti/net/nio/AsyncSocketImpl$DefaultConnector;", "Lorg/openziti/net/nio/AsyncSocketImpl$Connector;", "<init>", "()V", "connect", "Ljava/nio/channels/AsynchronousSocketChannel;", "addr", "Ljava/net/SocketAddress;", "timeout", "", "ziti"})
    public static final class DefaultConnector
    implements Connector {
        @NotNull
        public static final DefaultConnector INSTANCE = new DefaultConnector();

        private DefaultConnector() {
        }

        @Override
        @NotNull
        public AsynchronousSocketChannel connect(@NotNull SocketAddress addr, int timeout) {
            Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
            AsynchronousSocketChannel asynchronousSocketChannel = AsynchronousSocketChannel.open();
            Intrinsics.checkNotNullExpressionValue((Object)asynchronousSocketChannel, (String)"open(...)");
            return this.doConnect(asynchronousSocketChannel, addr, timeout);
        }

        @Override
        @NotNull
        public AsynchronousSocketChannel doConnect(@NotNull AsynchronousSocketChannel ch, @NotNull SocketAddress addr, int timeout) {
            return Connector.DefaultImpls.doConnect(this, ch, addr, timeout);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/openziti/net/nio/AsyncSocketImpl$channelConnector;", "Lorg/openziti/net/nio/AsyncSocketImpl$Connector;", "ch", "Ljava/nio/channels/AsynchronousSocketChannel;", "<init>", "(Ljava/nio/channels/AsynchronousSocketChannel;)V", "getCh", "()Ljava/nio/channels/AsynchronousSocketChannel;", "connect", "addr", "Ljava/net/SocketAddress;", "timeout", "", "ziti"})
    public static final class channelConnector
    implements Connector {
        @NotNull
        private final AsynchronousSocketChannel ch;

        public channelConnector(@NotNull AsynchronousSocketChannel ch) {
            Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
            this.ch = ch;
        }

        @NotNull
        public final AsynchronousSocketChannel getCh() {
            return this.ch;
        }

        @Override
        @NotNull
        public AsynchronousSocketChannel connect(@NotNull SocketAddress addr, int timeout) {
            Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
            return this.doConnect(this.ch, addr, timeout);
        }

        @Override
        @NotNull
        public AsynchronousSocketChannel doConnect(@NotNull AsynchronousSocketChannel ch, @NotNull SocketAddress addr, int timeout) {
            return Connector.DefaultImpls.doConnect(this, ch, addr, timeout);
        }
    }
}

