/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.commons.logging;

import org.operaton.commons.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public abstract class BaseLogger {
    protected Logger delegateLogger;
    protected String projectCode;
    protected String componentId;

    protected BaseLogger() {
    }

    public static <T extends BaseLogger> T createLogger(Class<T> loggerClass, String projectCode, String name, String componentId) {
        try {
            BaseLogger logger = (BaseLogger)loggerClass.newInstance();
            logger.projectCode = projectCode;
            logger.componentId = componentId;
            logger.delegateLogger = LoggerFactory.getLogger((String)name);
            return (T)logger;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate logger '" + loggerClass.getName() + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to instantiate logger '" + loggerClass.getName() + "'", e);
        }
    }

    protected void log(String level, String id, String messageTemplate, Object ... parameters) {
        this.log(level, Level.DEBUG, id, messageTemplate, parameters);
    }

    protected void log(String level, Level defaultLevel, String id, String messageTemplate, Object ... parameters) {
        switch (Level.parse(level, defaultLevel)) {
            case ERROR: {
                this.logError(id, messageTemplate, parameters);
                break;
            }
            case WARN: {
                this.logWarn(id, messageTemplate, parameters);
                break;
            }
            case INFO: {
                this.logInfo(id, messageTemplate, parameters);
                break;
            }
            case DEBUG: {
                this.logDebug(id, messageTemplate, parameters);
                break;
            }
            case TRACE: {
                this.logTrace(id, messageTemplate, parameters);
            }
        }
    }

    protected void logTrace(String id, String messageTemplate, Object ... parameters) {
        if (this.delegateLogger.isTraceEnabled()) {
            String msg = this.formatMessageTemplate(id, messageTemplate);
            this.delegateLogger.trace(msg, parameters);
        }
    }

    protected void logDebug(String id, String messageTemplate, Object ... parameters) {
        if (this.delegateLogger.isDebugEnabled()) {
            String msg = this.formatMessageTemplate(id, messageTemplate);
            this.delegateLogger.debug(msg, parameters);
        }
    }

    protected void logInfo(String id, String messageTemplate, Object ... parameters) {
        if (this.delegateLogger.isInfoEnabled()) {
            String msg = this.formatMessageTemplate(id, messageTemplate);
            this.delegateLogger.info(msg, parameters);
        }
    }

    protected void logWarn(String id, String messageTemplate, Object ... parameters) {
        if (this.delegateLogger.isWarnEnabled()) {
            String msg = this.formatMessageTemplate(id, messageTemplate);
            this.delegateLogger.warn(msg, parameters);
        }
    }

    protected void logError(String id, String messageTemplate, Object ... parameters) {
        if (this.delegateLogger.isErrorEnabled()) {
            String msg = this.formatMessageTemplate(id, messageTemplate);
            this.delegateLogger.error(msg, parameters);
        }
    }

    public boolean isDebugEnabled() {
        return this.delegateLogger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.delegateLogger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.delegateLogger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.delegateLogger.isErrorEnabled();
    }

    protected String formatMessageTemplate(String id, String messageTemplate) {
        return this.projectCode + "-" + this.componentId + id + " " + messageTemplate;
    }

    protected String exceptionMessage(String id, String messageTemplate, Object ... parameters) {
        String formattedTemplate = this.formatMessageTemplate(id, messageTemplate);
        if (parameters == null || parameters.length == 0) {
            return formattedTemplate;
        }
        return MessageFormatter.arrayFormat((String)formattedTemplate, (Object[])parameters).getMessage();
    }
}

