package org.opfab.cards.model;

import java.util.Objects;
import java.util.ArrayList;
import java.util.List;
import org.opfab.cards.model.FilterModel;

import com.fasterxml.jackson.annotation.JsonInclude;
/**
 * FilterModel
 */


@JsonInclude(JsonInclude.Include.NON_NULL)
public class FilterModel   {
  private String columnName = null;

  private org.opfab.cards.model.FilterMatchTypeEnum matchType = null;

  
  private List<String> filter = null;

  private FilterModel condition1 = null;

  private FilterModel condition2 = null;

  private org.opfab.cards.model.FilterOperationTypeEnum operation = null;

  public FilterModel columnName(String columnName) {
    this.columnName = columnName;
    return this;
  }

  /**
   * Get columnName
   * @return columnName
  **/
  //@ApiModelProperty(value = "")
  public String getColumnName() {
    return columnName;
  }

  public void setColumnName(String columnName) {
    this.columnName = columnName;
  }

  public FilterModel matchType(org.opfab.cards.model.FilterMatchTypeEnum matchType) {
    this.matchType = matchType;
    return this;
  }

  /**
   * Get matchType
   * @return matchType
  **/
  //@ApiModelProperty(value = "")
  public org.opfab.cards.model.FilterMatchTypeEnum getMatchType() {
    return matchType;
  }

  public void setMatchType(org.opfab.cards.model.FilterMatchTypeEnum matchType) {
    this.matchType = matchType;
  }

  public FilterModel filter(List<String> filter) {
    this.filter = filter;
    return this;
  }

  public FilterModel addFilterItem(String filterItem) {
    if (this.filter == null) {
      this.filter = new ArrayList<>();
    }
    this.filter.add(filterItem);
    return this;
  }

  /**
   * Get filter
   * @return filter
  **/
  //@ApiModelProperty(value = "")
  public List<String> getFilter() {
    return filter;
  }

  public void setFilter(List<String> filter) {
    this.filter = filter;
  }

  public FilterModel condition1(FilterModel condition1) {
    this.condition1 = condition1;
    return this;
  }

  /**
   * Get condition1
   * @return condition1
  **/
  //@ApiModelProperty(value = "")
  public FilterModel getCondition1() {
    return condition1;
  }

  public void setCondition1(FilterModel condition1) {
    this.condition1 = condition1;
  }

  public FilterModel condition2(FilterModel condition2) {
    this.condition2 = condition2;
    return this;
  }

  /**
   * Get condition2
   * @return condition2
  **/
  //@ApiModelProperty(value = "")
  public FilterModel getCondition2() {
    return condition2;
  }

  public void setCondition2(FilterModel condition2) {
    this.condition2 = condition2;
  }

  public FilterModel operation(org.opfab.cards.model.FilterOperationTypeEnum operation) {
    this.operation = operation;
    return this;
  }

  /**
   * Get operation
   * @return operation
  **/
  //@ApiModelProperty(value = "")
  public org.opfab.cards.model.FilterOperationTypeEnum getOperation() {
    return operation;
  }

  public void setOperation(org.opfab.cards.model.FilterOperationTypeEnum operation) {
    this.operation = operation;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FilterModel filterModel = (FilterModel) o;
    return Objects.equals(this.columnName, filterModel.columnName) &&
        Objects.equals(this.matchType, filterModel.matchType) &&
        Objects.equals(this.filter, filterModel.filter) &&
        Objects.equals(this.condition1, filterModel.condition1) &&
        Objects.equals(this.condition2, filterModel.condition2) &&
        Objects.equals(this.operation, filterModel.operation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(columnName, matchType, filter, condition1, condition2, operation);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FilterModel {\n");
    
    sb.append("    columnName: ").append(toIndentedString(columnName)).append("\n");
    sb.append("    matchType: ").append(toIndentedString(matchType)).append("\n");
    sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
    sb.append("    condition1: ").append(toIndentedString(condition1)).append("\n");
    sb.append("    condition2: ").append(toIndentedString(condition2)).append("\n");
    sb.append("    operation: ").append(toIndentedString(operation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

