/*
 * Decompiled with CFR 0.152.
 */
package org.opfab.avro;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversion;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.opfab.avro.Recurrence;

@AvroGenerated
public class TimeSpan
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 9178127238066191195L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"TimeSpan\",\"namespace\":\"org.opfab.avro\",\"fields\":[{\"name\":\"start\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"end\",\"type\":[\"null\",{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}],\"default\":null},{\"name\":\"recurrence\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Recurrence\",\"fields\":[{\"name\":\"hoursAndMinutes\",\"type\":{\"type\":\"record\",\"name\":\"HoursAndMinutes\",\"fields\":[{\"name\":\"hours\",\"type\":\"int\"},{\"name\":\"minutes\",\"type\":\"int\"}]}},{\"name\":\"daysOfWeek\",\"type\":[\"null\",{\"type\":\"array\",\"items\":\"int\"}],\"default\":null},{\"name\":\"timeZone\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"durationInMinutes\",\"type\":[\"null\",\"int\"],\"default\":null}]}],\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<TimeSpan> ENCODER;
    private static final BinaryMessageDecoder<TimeSpan> DECODER;
    private Instant start;
    private Instant end;
    private Recurrence recurrence;
    private static final Conversion<?>[] conversions;
    private static final DatumWriter<TimeSpan> WRITER$;
    private static final DatumReader<TimeSpan> READER$;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<TimeSpan> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<TimeSpan> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<TimeSpan> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static TimeSpan fromByteBuffer(ByteBuffer b) throws IOException {
        return (TimeSpan)((Object)DECODER.decode(b));
    }

    public TimeSpan() {
    }

    public TimeSpan(Instant start, Instant end, Recurrence recurrence) {
        this.start = start.truncatedTo(ChronoUnit.MILLIS);
        this.end = end;
        this.recurrence = recurrence;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.start;
            }
            case 1: {
                return this.end;
            }
            case 2: {
                return this.recurrence;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public Conversion<?> getConversion(int field) {
        return conversions[field];
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.start = (Instant)value$;
                break;
            }
            case 1: {
                this.end = (Instant)value$;
                break;
            }
            case 2: {
                this.recurrence = (Recurrence)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public Instant getStart() {
        return this.start;
    }

    public void setStart(Instant value) {
        this.start = value.truncatedTo(ChronoUnit.MILLIS);
    }

    public Instant getEnd() {
        return this.end;
    }

    public void setEnd(Instant value) {
        this.end = value;
    }

    public Recurrence getRecurrence() {
        return this.recurrence;
    }

    public void setRecurrence(Recurrence value) {
        this.recurrence = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(TimeSpan other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    static {
        MODEL$.addLogicalTypeConversion((Conversion)new TimeConversions.TimestampMillisConversion());
        ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
        DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
        conversions = new Conversion[]{new TimeConversions.TimestampMillisConversion(), null, null, null};
        WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
        READER$ = MODEL$.createDatumReader(SCHEMA$);
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<TimeSpan>
    implements RecordBuilder<TimeSpan> {
        private Instant start;
        private Instant end;
        private Recurrence recurrence;
        private Recurrence.Builder recurrenceBuilder;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.start)) {
                this.start = (Instant)this.data().deepCopy(this.fields()[0].schema(), (Object)other.start);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.end)) {
                this.end = (Instant)this.data().deepCopy(this.fields()[1].schema(), (Object)other.end);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.recurrence))) {
                this.recurrence = (Recurrence)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.recurrence));
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (other.hasRecurrenceBuilder()) {
                this.recurrenceBuilder = Recurrence.newBuilder(other.getRecurrenceBuilder());
            }
        }

        private Builder(TimeSpan other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.start)) {
                this.start = (Instant)this.data().deepCopy(this.fields()[0].schema(), (Object)other.start);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.end)) {
                this.end = (Instant)this.data().deepCopy(this.fields()[1].schema(), (Object)other.end);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.recurrence))) {
                this.recurrence = (Recurrence)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.recurrence));
                this.fieldSetFlags()[2] = true;
            }
            this.recurrenceBuilder = null;
        }

        public Instant getStart() {
            return this.start;
        }

        public Builder setStart(Instant value) {
            this.validate(this.fields()[0], value);
            this.start = value.truncatedTo(ChronoUnit.MILLIS);
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasStart() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearStart() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Instant getEnd() {
            return this.end;
        }

        public Builder setEnd(Instant value) {
            this.validate(this.fields()[1], value);
            this.end = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasEnd() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearEnd() {
            this.end = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Recurrence getRecurrence() {
            return this.recurrence;
        }

        public Builder setRecurrence(Recurrence value) {
            this.validate(this.fields()[2], (Object)value);
            this.recurrenceBuilder = null;
            this.recurrence = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasRecurrence() {
            return this.fieldSetFlags()[2];
        }

        public Recurrence.Builder getRecurrenceBuilder() {
            if (this.recurrenceBuilder == null) {
                if (this.hasRecurrence()) {
                    this.setRecurrenceBuilder(Recurrence.newBuilder(this.recurrence));
                } else {
                    this.setRecurrenceBuilder(Recurrence.newBuilder());
                }
            }
            return this.recurrenceBuilder;
        }

        public Builder setRecurrenceBuilder(Recurrence.Builder value) {
            this.clearRecurrence();
            this.recurrenceBuilder = value;
            return this;
        }

        public boolean hasRecurrenceBuilder() {
            return this.recurrenceBuilder != null;
        }

        public Builder clearRecurrence() {
            this.recurrence = null;
            this.recurrenceBuilder = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public TimeSpan build() {
            try {
                TimeSpan record = new TimeSpan();
                record.start = this.fieldSetFlags()[0] ? this.start : (Instant)this.defaultValue(this.fields()[0]);
                Instant instant = record.end = this.fieldSetFlags()[1] ? this.end : (Instant)this.defaultValue(this.fields()[1]);
                if (this.recurrenceBuilder != null) {
                    try {
                        record.recurrence = this.recurrenceBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("recurrence"));
                        throw e;
                    }
                } else {
                    record.recurrence = this.fieldSetFlags()[2] ? this.recurrence : (Recurrence)((Object)this.defaultValue(this.fields()[2]));
                }
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

