package org.opfab.cards.model;

import java.util.Objects;
import java.util.ArrayList;
import java.util.List;
import org.opfab.cards.model.Card;

import com.fasterxml.jackson.annotation.JsonInclude;
/**
 * InlineResponse200
 */


@JsonInclude(JsonInclude.Include.NON_NULL)
public class InlineResponse200   {
  private Card card = null;

  
  private List<Card> childCards = null;

  public InlineResponse200 card(Card card) {
    this.card = card;
    return this;
  }

  /**
   * Get card
   * @return card
  **/
  //@ApiModelProperty(value = "")
  public Card getCard() {
    return card;
  }

  public void setCard(Card card) {
    this.card = card;
  }

  public InlineResponse200 childCards(List<Card> childCards) {
    this.childCards = childCards;
    return this;
  }

  public InlineResponse200 addChildCardsItem(Card childCardsItem) {
    if (this.childCards == null) {
      this.childCards = new ArrayList<>();
    }
    this.childCards.add(childCardsItem);
    return this;
  }

  /**
   * Get childCards
   * @return childCards
  **/
  //@ApiModelProperty(value = "")
  public List<Card> getChildCards() {
    return childCards;
  }

  public void setChildCards(List<Card> childCards) {
    this.childCards = childCards;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InlineResponse200 inlineResponse200 = (InlineResponse200) o;
    return Objects.equals(this.card, inlineResponse200.card) &&
        Objects.equals(this.childCards, inlineResponse200.childCards);
  }

  @Override
  public int hashCode() {
    return Objects.hash(card, childCards);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InlineResponse200 {\n");
    
    sb.append("    card: ").append(toIndentedString(card)).append("\n");
    sb.append("    childCards: ").append(toIndentedString(childCards)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

