/*
 * Decompiled with CFR 0.152.
 */
package org.opfab.avro;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversion;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.opfab.avro.I18n;
import org.opfab.avro.PublisherTypeEnum;
import org.opfab.avro.SeverityType;
import org.opfab.avro.TimeSpan;

@AvroGenerated
public class ResponseCard
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -3849180323456972239L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"ResponseCard\",\"namespace\":\"org.opfab.avro\",\"fields\":[{\"name\":\"id\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"uid\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"parentCardId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"initialParentCardUid\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"externalRecipients\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"default\":null},{\"name\":\"publisher\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"processVersion\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"process\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"processInstanceId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"state\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"publishDate\",\"type\":[\"null\",{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}],\"default\":null},{\"name\":\"lttd\",\"type\":[\"null\",{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}],\"default\":null},{\"name\":\"startDate\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"endDate\",\"type\":[\"null\",{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}],\"default\":null},{\"name\":\"expirationDate\",\"type\":[\"null\",{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}],\"default\":null},{\"name\":\"severity\",\"type\":{\"type\":\"enum\",\"name\":\"SeverityType\",\"symbols\":[\"ALARM\",\"ACTION\",\"COMPLIANT\",\"INFORMATION\"]}},{\"name\":\"tags\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"default\":null},{\"name\":\"timeSpans\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"TimeSpan\",\"fields\":[{\"name\":\"start\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"end\",\"type\":[\"null\",{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}],\"default\":null}]}}],\"default\":null},{\"name\":\"title\",\"type\":{\"type\":\"record\",\"name\":\"I18n\",\"fields\":[{\"name\":\"key\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"parameters\",\"type\":[\"null\",{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"}],\"default\":null}]}},{\"name\":\"summary\",\"type\":\"I18n\"},{\"name\":\"titleTranslated\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"summaryTranslated\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"userRecipients\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"default\":null},{\"name\":\"groupRecipients\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"default\":null},{\"name\":\"entitiesAllowedToRespond\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"default\":null},{\"name\":\"entitiesRequiredToRespond\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"default\":null},{\"name\":\"entityRecipients\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"default\":null},{\"name\":\"entitiesAllowedToEdit\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"default\":null},{\"name\":\"wktGeometry\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"wktProjection\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"data\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"hasBeenAcknowledged\",\"type\":[\"null\",\"boolean\"],\"default\":null},{\"name\":\"hasBeenRead\",\"type\":[\"null\",\"boolean\"],\"default\":null},{\"name\":\"publisherType\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"PublisherTypeEnum\",\"symbols\":[\"EXTERNAL\",\"ENTITY\"]}],\"default\":null},{\"name\":\"representative\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"representativeType\",\"type\":[\"null\",\"PublisherTypeEnum\"],\"default\":null},{\"name\":\"secondsBeforeTimeSpanForReminder\",\"type\":[\"null\",\"int\"],\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<ResponseCard> ENCODER;
    private static final BinaryMessageDecoder<ResponseCard> DECODER;
    private String id;
    private String uid;
    private String parentCardId;
    private String initialParentCardUid;
    private List<String> externalRecipients;
    private String publisher;
    private String processVersion;
    private String process;
    private String processInstanceId;
    private String state;
    private Instant publishDate;
    private Instant lttd;
    private Instant startDate;
    private Instant endDate;
    private Instant expirationDate;
    private SeverityType severity;
    private List<String> tags;
    private List<TimeSpan> timeSpans;
    private I18n title;
    private I18n summary;
    private String titleTranslated;
    private String summaryTranslated;
    private List<String> userRecipients;
    private List<String> groupRecipients;
    private List<String> entitiesAllowedToRespond;
    private List<String> entitiesRequiredToRespond;
    private List<String> entityRecipients;
    private List<String> entitiesAllowedToEdit;
    private String wktGeometry;
    private String wktProjection;
    private String data;
    private Boolean hasBeenAcknowledged;
    private Boolean hasBeenRead;
    private PublisherTypeEnum publisherType;
    private String representative;
    private PublisherTypeEnum representativeType;
    private Integer secondsBeforeTimeSpanForReminder;
    private static final Conversion<?>[] conversions;
    private static final DatumWriter<ResponseCard> WRITER$;
    private static final DatumReader<ResponseCard> READER$;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<ResponseCard> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<ResponseCard> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<ResponseCard> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static ResponseCard fromByteBuffer(ByteBuffer b) throws IOException {
        return (ResponseCard)((Object)DECODER.decode(b));
    }

    public ResponseCard() {
    }

    public ResponseCard(String id, String uid, String parentCardId, String initialParentCardUid, List<String> externalRecipients, String publisher, String processVersion, String process, String processInstanceId, String state, Instant publishDate, Instant lttd, Instant startDate, Instant endDate, Instant expirationDate, SeverityType severity, List<String> tags, List<TimeSpan> timeSpans, I18n title, I18n summary, String titleTranslated, String summaryTranslated, List<String> userRecipients, List<String> groupRecipients, List<String> entitiesAllowedToRespond, List<String> entitiesRequiredToRespond, List<String> entityRecipients, List<String> entitiesAllowedToEdit, String wktGeometry, String wktProjection, String data, Boolean hasBeenAcknowledged, Boolean hasBeenRead, PublisherTypeEnum publisherType, String representative, PublisherTypeEnum representativeType, Integer secondsBeforeTimeSpanForReminder) {
        this.id = id;
        this.uid = uid;
        this.parentCardId = parentCardId;
        this.initialParentCardUid = initialParentCardUid;
        this.externalRecipients = externalRecipients;
        this.publisher = publisher;
        this.processVersion = processVersion;
        this.process = process;
        this.processInstanceId = processInstanceId;
        this.state = state;
        this.publishDate = publishDate;
        this.lttd = lttd;
        this.startDate = startDate.truncatedTo(ChronoUnit.MILLIS);
        this.endDate = endDate;
        this.expirationDate = expirationDate;
        this.severity = severity;
        this.tags = tags;
        this.timeSpans = timeSpans;
        this.title = title;
        this.summary = summary;
        this.titleTranslated = titleTranslated;
        this.summaryTranslated = summaryTranslated;
        this.userRecipients = userRecipients;
        this.groupRecipients = groupRecipients;
        this.entitiesAllowedToRespond = entitiesAllowedToRespond;
        this.entitiesRequiredToRespond = entitiesRequiredToRespond;
        this.entityRecipients = entityRecipients;
        this.entitiesAllowedToEdit = entitiesAllowedToEdit;
        this.wktGeometry = wktGeometry;
        this.wktProjection = wktProjection;
        this.data = data;
        this.hasBeenAcknowledged = hasBeenAcknowledged;
        this.hasBeenRead = hasBeenRead;
        this.publisherType = publisherType;
        this.representative = representative;
        this.representativeType = representativeType;
        this.secondsBeforeTimeSpanForReminder = secondsBeforeTimeSpanForReminder;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.uid;
            }
            case 2: {
                return this.parentCardId;
            }
            case 3: {
                return this.initialParentCardUid;
            }
            case 4: {
                return this.externalRecipients;
            }
            case 5: {
                return this.publisher;
            }
            case 6: {
                return this.processVersion;
            }
            case 7: {
                return this.process;
            }
            case 8: {
                return this.processInstanceId;
            }
            case 9: {
                return this.state;
            }
            case 10: {
                return this.publishDate;
            }
            case 11: {
                return this.lttd;
            }
            case 12: {
                return this.startDate;
            }
            case 13: {
                return this.endDate;
            }
            case 14: {
                return this.expirationDate;
            }
            case 15: {
                return this.severity;
            }
            case 16: {
                return this.tags;
            }
            case 17: {
                return this.timeSpans;
            }
            case 18: {
                return this.title;
            }
            case 19: {
                return this.summary;
            }
            case 20: {
                return this.titleTranslated;
            }
            case 21: {
                return this.summaryTranslated;
            }
            case 22: {
                return this.userRecipients;
            }
            case 23: {
                return this.groupRecipients;
            }
            case 24: {
                return this.entitiesAllowedToRespond;
            }
            case 25: {
                return this.entitiesRequiredToRespond;
            }
            case 26: {
                return this.entityRecipients;
            }
            case 27: {
                return this.entitiesAllowedToEdit;
            }
            case 28: {
                return this.wktGeometry;
            }
            case 29: {
                return this.wktProjection;
            }
            case 30: {
                return this.data;
            }
            case 31: {
                return this.hasBeenAcknowledged;
            }
            case 32: {
                return this.hasBeenRead;
            }
            case 33: {
                return this.publisherType;
            }
            case 34: {
                return this.representative;
            }
            case 35: {
                return this.representativeType;
            }
            case 36: {
                return this.secondsBeforeTimeSpanForReminder;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public Conversion<?> getConversion(int field) {
        return conversions[field];
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.id = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.uid = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.parentCardId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.initialParentCardUid = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.externalRecipients = (List)value$;
                break;
            }
            case 5: {
                this.publisher = value$ != null ? value$.toString() : null;
                break;
            }
            case 6: {
                this.processVersion = value$ != null ? value$.toString() : null;
                break;
            }
            case 7: {
                this.process = value$ != null ? value$.toString() : null;
                break;
            }
            case 8: {
                this.processInstanceId = value$ != null ? value$.toString() : null;
                break;
            }
            case 9: {
                this.state = value$ != null ? value$.toString() : null;
                break;
            }
            case 10: {
                this.publishDate = (Instant)value$;
                break;
            }
            case 11: {
                this.lttd = (Instant)value$;
                break;
            }
            case 12: {
                this.startDate = (Instant)value$;
                break;
            }
            case 13: {
                this.endDate = (Instant)value$;
                break;
            }
            case 14: {
                this.expirationDate = (Instant)value$;
                break;
            }
            case 15: {
                this.severity = (SeverityType)((Object)value$);
                break;
            }
            case 16: {
                this.tags = (List)value$;
                break;
            }
            case 17: {
                this.timeSpans = (List)value$;
                break;
            }
            case 18: {
                this.title = (I18n)((Object)value$);
                break;
            }
            case 19: {
                this.summary = (I18n)((Object)value$);
                break;
            }
            case 20: {
                this.titleTranslated = value$ != null ? value$.toString() : null;
                break;
            }
            case 21: {
                this.summaryTranslated = value$ != null ? value$.toString() : null;
                break;
            }
            case 22: {
                this.userRecipients = (List)value$;
                break;
            }
            case 23: {
                this.groupRecipients = (List)value$;
                break;
            }
            case 24: {
                this.entitiesAllowedToRespond = (List)value$;
                break;
            }
            case 25: {
                this.entitiesRequiredToRespond = (List)value$;
                break;
            }
            case 26: {
                this.entityRecipients = (List)value$;
                break;
            }
            case 27: {
                this.entitiesAllowedToEdit = (List)value$;
                break;
            }
            case 28: {
                this.wktGeometry = value$ != null ? value$.toString() : null;
                break;
            }
            case 29: {
                this.wktProjection = value$ != null ? value$.toString() : null;
                break;
            }
            case 30: {
                this.data = value$ != null ? value$.toString() : null;
                break;
            }
            case 31: {
                this.hasBeenAcknowledged = (Boolean)value$;
                break;
            }
            case 32: {
                this.hasBeenRead = (Boolean)value$;
                break;
            }
            case 33: {
                this.publisherType = (PublisherTypeEnum)((Object)value$);
                break;
            }
            case 34: {
                this.representative = value$ != null ? value$.toString() : null;
                break;
            }
            case 35: {
                this.representativeType = (PublisherTypeEnum)((Object)value$);
                break;
            }
            case 36: {
                this.secondsBeforeTimeSpanForReminder = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String value) {
        this.uid = value;
    }

    public String getParentCardId() {
        return this.parentCardId;
    }

    public void setParentCardId(String value) {
        this.parentCardId = value;
    }

    public String getInitialParentCardUid() {
        return this.initialParentCardUid;
    }

    public void setInitialParentCardUid(String value) {
        this.initialParentCardUid = value;
    }

    public List<String> getExternalRecipients() {
        return this.externalRecipients;
    }

    public void setExternalRecipients(List<String> value) {
        this.externalRecipients = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public String getProcessVersion() {
        return this.processVersion;
    }

    public void setProcessVersion(String value) {
        this.processVersion = value;
    }

    public String getProcess() {
        return this.process;
    }

    public void setProcess(String value) {
        this.process = value;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String value) {
        this.processInstanceId = value;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String value) {
        this.state = value;
    }

    public Instant getPublishDate() {
        return this.publishDate;
    }

    public void setPublishDate(Instant value) {
        this.publishDate = value;
    }

    public Instant getLttd() {
        return this.lttd;
    }

    public void setLttd(Instant value) {
        this.lttd = value;
    }

    public Instant getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Instant value) {
        this.startDate = value.truncatedTo(ChronoUnit.MILLIS);
    }

    public Instant getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Instant value) {
        this.endDate = value;
    }

    public Instant getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Instant value) {
        this.expirationDate = value;
    }

    public SeverityType getSeverity() {
        return this.severity;
    }

    public void setSeverity(SeverityType value) {
        this.severity = value;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> value) {
        this.tags = value;
    }

    public List<TimeSpan> getTimeSpans() {
        return this.timeSpans;
    }

    public void setTimeSpans(List<TimeSpan> value) {
        this.timeSpans = value;
    }

    public I18n getTitle() {
        return this.title;
    }

    public void setTitle(I18n value) {
        this.title = value;
    }

    public I18n getSummary() {
        return this.summary;
    }

    public void setSummary(I18n value) {
        this.summary = value;
    }

    public String getTitleTranslated() {
        return this.titleTranslated;
    }

    public void setTitleTranslated(String value) {
        this.titleTranslated = value;
    }

    public String getSummaryTranslated() {
        return this.summaryTranslated;
    }

    public void setSummaryTranslated(String value) {
        this.summaryTranslated = value;
    }

    public List<String> getUserRecipients() {
        return this.userRecipients;
    }

    public void setUserRecipients(List<String> value) {
        this.userRecipients = value;
    }

    public List<String> getGroupRecipients() {
        return this.groupRecipients;
    }

    public void setGroupRecipients(List<String> value) {
        this.groupRecipients = value;
    }

    public List<String> getEntitiesAllowedToRespond() {
        return this.entitiesAllowedToRespond;
    }

    public void setEntitiesAllowedToRespond(List<String> value) {
        this.entitiesAllowedToRespond = value;
    }

    public List<String> getEntitiesRequiredToRespond() {
        return this.entitiesRequiredToRespond;
    }

    public void setEntitiesRequiredToRespond(List<String> value) {
        this.entitiesRequiredToRespond = value;
    }

    public List<String> getEntityRecipients() {
        return this.entityRecipients;
    }

    public void setEntityRecipients(List<String> value) {
        this.entityRecipients = value;
    }

    public List<String> getEntitiesAllowedToEdit() {
        return this.entitiesAllowedToEdit;
    }

    public void setEntitiesAllowedToEdit(List<String> value) {
        this.entitiesAllowedToEdit = value;
    }

    public String getWktGeometry() {
        return this.wktGeometry;
    }

    public void setWktGeometry(String value) {
        this.wktGeometry = value;
    }

    public String getWktProjection() {
        return this.wktProjection;
    }

    public void setWktProjection(String value) {
        this.wktProjection = value;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String value) {
        this.data = value;
    }

    public Boolean getHasBeenAcknowledged() {
        return this.hasBeenAcknowledged;
    }

    public void setHasBeenAcknowledged(Boolean value) {
        this.hasBeenAcknowledged = value;
    }

    public Boolean getHasBeenRead() {
        return this.hasBeenRead;
    }

    public void setHasBeenRead(Boolean value) {
        this.hasBeenRead = value;
    }

    public PublisherTypeEnum getPublisherType() {
        return this.publisherType;
    }

    public void setPublisherType(PublisherTypeEnum value) {
        this.publisherType = value;
    }

    public String getRepresentative() {
        return this.representative;
    }

    public void setRepresentative(String value) {
        this.representative = value;
    }

    public PublisherTypeEnum getRepresentativeType() {
        return this.representativeType;
    }

    public void setRepresentativeType(PublisherTypeEnum value) {
        this.representativeType = value;
    }

    public Integer getSecondsBeforeTimeSpanForReminder() {
        return this.secondsBeforeTimeSpanForReminder;
    }

    public void setSecondsBeforeTimeSpanForReminder(Integer value) {
        this.secondsBeforeTimeSpanForReminder = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(ResponseCard other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    static {
        MODEL$.addLogicalTypeConversion((Conversion)new TimeConversions.TimestampMillisConversion());
        ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
        DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
        conversions = new Conversion[]{null, null, null, null, null, null, null, null, null, null, null, null, new TimeConversions.TimestampMillisConversion(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
        READER$ = MODEL$.createDatumReader(SCHEMA$);
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<ResponseCard>
    implements RecordBuilder<ResponseCard> {
        private String id;
        private String uid;
        private String parentCardId;
        private String initialParentCardUid;
        private List<String> externalRecipients;
        private String publisher;
        private String processVersion;
        private String process;
        private String processInstanceId;
        private String state;
        private Instant publishDate;
        private Instant lttd;
        private Instant startDate;
        private Instant endDate;
        private Instant expirationDate;
        private SeverityType severity;
        private List<String> tags;
        private List<TimeSpan> timeSpans;
        private I18n title;
        private I18n.Builder titleBuilder;
        private I18n summary;
        private I18n.Builder summaryBuilder;
        private String titleTranslated;
        private String summaryTranslated;
        private List<String> userRecipients;
        private List<String> groupRecipients;
        private List<String> entitiesAllowedToRespond;
        private List<String> entitiesRequiredToRespond;
        private List<String> entityRecipients;
        private List<String> entitiesAllowedToEdit;
        private String wktGeometry;
        private String wktProjection;
        private String data;
        private Boolean hasBeenAcknowledged;
        private Boolean hasBeenRead;
        private PublisherTypeEnum publisherType;
        private String representative;
        private PublisherTypeEnum representativeType;
        private Integer secondsBeforeTimeSpanForReminder;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.id);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.uid)) {
                this.uid = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.uid);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.parentCardId)) {
                this.parentCardId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.parentCardId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.initialParentCardUid)) {
                this.initialParentCardUid = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.initialParentCardUid);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], other.externalRecipients)) {
                this.externalRecipients = (List)this.data().deepCopy(this.fields()[4].schema(), other.externalRecipients);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.publisher)) {
                this.publisher = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.publisher);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.processVersion)) {
                this.processVersion = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.processVersion);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.process)) {
                this.process = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.process);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.processInstanceId)) {
                this.processInstanceId = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.processInstanceId);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.state)) {
                this.state = (String)this.data().deepCopy(this.fields()[9].schema(), (Object)other.state);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.publishDate)) {
                this.publishDate = (Instant)this.data().deepCopy(this.fields()[10].schema(), (Object)other.publishDate);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.lttd)) {
                this.lttd = (Instant)this.data().deepCopy(this.fields()[11].schema(), (Object)other.lttd);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.startDate)) {
                this.startDate = (Instant)this.data().deepCopy(this.fields()[12].schema(), (Object)other.startDate);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.endDate)) {
                this.endDate = (Instant)this.data().deepCopy(this.fields()[13].schema(), (Object)other.endDate);
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.expirationDate)) {
                this.expirationDate = (Instant)this.data().deepCopy(this.fields()[14].schema(), (Object)other.expirationDate);
                this.fieldSetFlags()[14] = other.fieldSetFlags()[14];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)((Object)other.severity))) {
                this.severity = (SeverityType)((Object)this.data().deepCopy(this.fields()[15].schema(), (Object)other.severity));
                this.fieldSetFlags()[15] = other.fieldSetFlags()[15];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], other.tags)) {
                this.tags = (List)this.data().deepCopy(this.fields()[16].schema(), other.tags);
                this.fieldSetFlags()[16] = other.fieldSetFlags()[16];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], other.timeSpans)) {
                this.timeSpans = (List)this.data().deepCopy(this.fields()[17].schema(), other.timeSpans);
                this.fieldSetFlags()[17] = other.fieldSetFlags()[17];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)((Object)other.title))) {
                this.title = (I18n)((Object)this.data().deepCopy(this.fields()[18].schema(), (Object)other.title));
                this.fieldSetFlags()[18] = other.fieldSetFlags()[18];
            }
            if (other.hasTitleBuilder()) {
                this.titleBuilder = I18n.newBuilder(other.getTitleBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)((Object)other.summary))) {
                this.summary = (I18n)((Object)this.data().deepCopy(this.fields()[19].schema(), (Object)other.summary));
                this.fieldSetFlags()[19] = other.fieldSetFlags()[19];
            }
            if (other.hasSummaryBuilder()) {
                this.summaryBuilder = I18n.newBuilder(other.getSummaryBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.titleTranslated)) {
                this.titleTranslated = (String)this.data().deepCopy(this.fields()[20].schema(), (Object)other.titleTranslated);
                this.fieldSetFlags()[20] = other.fieldSetFlags()[20];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.summaryTranslated)) {
                this.summaryTranslated = (String)this.data().deepCopy(this.fields()[21].schema(), (Object)other.summaryTranslated);
                this.fieldSetFlags()[21] = other.fieldSetFlags()[21];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], other.userRecipients)) {
                this.userRecipients = (List)this.data().deepCopy(this.fields()[22].schema(), other.userRecipients);
                this.fieldSetFlags()[22] = other.fieldSetFlags()[22];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], other.groupRecipients)) {
                this.groupRecipients = (List)this.data().deepCopy(this.fields()[23].schema(), other.groupRecipients);
                this.fieldSetFlags()[23] = other.fieldSetFlags()[23];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], other.entitiesAllowedToRespond)) {
                this.entitiesAllowedToRespond = (List)this.data().deepCopy(this.fields()[24].schema(), other.entitiesAllowedToRespond);
                this.fieldSetFlags()[24] = other.fieldSetFlags()[24];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], other.entitiesRequiredToRespond)) {
                this.entitiesRequiredToRespond = (List)this.data().deepCopy(this.fields()[25].schema(), other.entitiesRequiredToRespond);
                this.fieldSetFlags()[25] = other.fieldSetFlags()[25];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], other.entityRecipients)) {
                this.entityRecipients = (List)this.data().deepCopy(this.fields()[26].schema(), other.entityRecipients);
                this.fieldSetFlags()[26] = other.fieldSetFlags()[26];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], other.entitiesAllowedToEdit)) {
                this.entitiesAllowedToEdit = (List)this.data().deepCopy(this.fields()[27].schema(), other.entitiesAllowedToEdit);
                this.fieldSetFlags()[27] = other.fieldSetFlags()[27];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)other.wktGeometry)) {
                this.wktGeometry = (String)this.data().deepCopy(this.fields()[28].schema(), (Object)other.wktGeometry);
                this.fieldSetFlags()[28] = other.fieldSetFlags()[28];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[29], (Object)other.wktProjection)) {
                this.wktProjection = (String)this.data().deepCopy(this.fields()[29].schema(), (Object)other.wktProjection);
                this.fieldSetFlags()[29] = other.fieldSetFlags()[29];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[30], (Object)other.data)) {
                this.data = (String)this.data().deepCopy(this.fields()[30].schema(), (Object)other.data);
                this.fieldSetFlags()[30] = other.fieldSetFlags()[30];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[31], (Object)other.hasBeenAcknowledged)) {
                this.hasBeenAcknowledged = (Boolean)this.data().deepCopy(this.fields()[31].schema(), (Object)other.hasBeenAcknowledged);
                this.fieldSetFlags()[31] = other.fieldSetFlags()[31];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[32], (Object)other.hasBeenRead)) {
                this.hasBeenRead = (Boolean)this.data().deepCopy(this.fields()[32].schema(), (Object)other.hasBeenRead);
                this.fieldSetFlags()[32] = other.fieldSetFlags()[32];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[33], (Object)((Object)other.publisherType))) {
                this.publisherType = (PublisherTypeEnum)((Object)this.data().deepCopy(this.fields()[33].schema(), (Object)other.publisherType));
                this.fieldSetFlags()[33] = other.fieldSetFlags()[33];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[34], (Object)other.representative)) {
                this.representative = (String)this.data().deepCopy(this.fields()[34].schema(), (Object)other.representative);
                this.fieldSetFlags()[34] = other.fieldSetFlags()[34];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[35], (Object)((Object)other.representativeType))) {
                this.representativeType = (PublisherTypeEnum)((Object)this.data().deepCopy(this.fields()[35].schema(), (Object)other.representativeType));
                this.fieldSetFlags()[35] = other.fieldSetFlags()[35];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[36], (Object)other.secondsBeforeTimeSpanForReminder)) {
                this.secondsBeforeTimeSpanForReminder = (Integer)this.data().deepCopy(this.fields()[36].schema(), (Object)other.secondsBeforeTimeSpanForReminder);
                this.fieldSetFlags()[36] = other.fieldSetFlags()[36];
            }
        }

        private Builder(ResponseCard other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.id);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.uid)) {
                this.uid = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.uid);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.parentCardId)) {
                this.parentCardId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.parentCardId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.initialParentCardUid)) {
                this.initialParentCardUid = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.initialParentCardUid);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], other.externalRecipients)) {
                this.externalRecipients = (List)this.data().deepCopy(this.fields()[4].schema(), other.externalRecipients);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.publisher)) {
                this.publisher = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.publisher);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.processVersion)) {
                this.processVersion = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.processVersion);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.process)) {
                this.process = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.process);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.processInstanceId)) {
                this.processInstanceId = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.processInstanceId);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.state)) {
                this.state = (String)this.data().deepCopy(this.fields()[9].schema(), (Object)other.state);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.publishDate)) {
                this.publishDate = (Instant)this.data().deepCopy(this.fields()[10].schema(), (Object)other.publishDate);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.lttd)) {
                this.lttd = (Instant)this.data().deepCopy(this.fields()[11].schema(), (Object)other.lttd);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.startDate)) {
                this.startDate = (Instant)this.data().deepCopy(this.fields()[12].schema(), (Object)other.startDate);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.endDate)) {
                this.endDate = (Instant)this.data().deepCopy(this.fields()[13].schema(), (Object)other.endDate);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.expirationDate)) {
                this.expirationDate = (Instant)this.data().deepCopy(this.fields()[14].schema(), (Object)other.expirationDate);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)((Object)other.severity))) {
                this.severity = (SeverityType)((Object)this.data().deepCopy(this.fields()[15].schema(), (Object)other.severity));
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], other.tags)) {
                this.tags = (List)this.data().deepCopy(this.fields()[16].schema(), other.tags);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], other.timeSpans)) {
                this.timeSpans = (List)this.data().deepCopy(this.fields()[17].schema(), other.timeSpans);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)((Object)other.title))) {
                this.title = (I18n)((Object)this.data().deepCopy(this.fields()[18].schema(), (Object)other.title));
                this.fieldSetFlags()[18] = true;
            }
            this.titleBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)((Object)other.summary))) {
                this.summary = (I18n)((Object)this.data().deepCopy(this.fields()[19].schema(), (Object)other.summary));
                this.fieldSetFlags()[19] = true;
            }
            this.summaryBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.titleTranslated)) {
                this.titleTranslated = (String)this.data().deepCopy(this.fields()[20].schema(), (Object)other.titleTranslated);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.summaryTranslated)) {
                this.summaryTranslated = (String)this.data().deepCopy(this.fields()[21].schema(), (Object)other.summaryTranslated);
                this.fieldSetFlags()[21] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], other.userRecipients)) {
                this.userRecipients = (List)this.data().deepCopy(this.fields()[22].schema(), other.userRecipients);
                this.fieldSetFlags()[22] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], other.groupRecipients)) {
                this.groupRecipients = (List)this.data().deepCopy(this.fields()[23].schema(), other.groupRecipients);
                this.fieldSetFlags()[23] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], other.entitiesAllowedToRespond)) {
                this.entitiesAllowedToRespond = (List)this.data().deepCopy(this.fields()[24].schema(), other.entitiesAllowedToRespond);
                this.fieldSetFlags()[24] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], other.entitiesRequiredToRespond)) {
                this.entitiesRequiredToRespond = (List)this.data().deepCopy(this.fields()[25].schema(), other.entitiesRequiredToRespond);
                this.fieldSetFlags()[25] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], other.entityRecipients)) {
                this.entityRecipients = (List)this.data().deepCopy(this.fields()[26].schema(), other.entityRecipients);
                this.fieldSetFlags()[26] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], other.entitiesAllowedToEdit)) {
                this.entitiesAllowedToEdit = (List)this.data().deepCopy(this.fields()[27].schema(), other.entitiesAllowedToEdit);
                this.fieldSetFlags()[27] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)other.wktGeometry)) {
                this.wktGeometry = (String)this.data().deepCopy(this.fields()[28].schema(), (Object)other.wktGeometry);
                this.fieldSetFlags()[28] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[29], (Object)other.wktProjection)) {
                this.wktProjection = (String)this.data().deepCopy(this.fields()[29].schema(), (Object)other.wktProjection);
                this.fieldSetFlags()[29] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[30], (Object)other.data)) {
                this.data = (String)this.data().deepCopy(this.fields()[30].schema(), (Object)other.data);
                this.fieldSetFlags()[30] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[31], (Object)other.hasBeenAcknowledged)) {
                this.hasBeenAcknowledged = (Boolean)this.data().deepCopy(this.fields()[31].schema(), (Object)other.hasBeenAcknowledged);
                this.fieldSetFlags()[31] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[32], (Object)other.hasBeenRead)) {
                this.hasBeenRead = (Boolean)this.data().deepCopy(this.fields()[32].schema(), (Object)other.hasBeenRead);
                this.fieldSetFlags()[32] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[33], (Object)((Object)other.publisherType))) {
                this.publisherType = (PublisherTypeEnum)((Object)this.data().deepCopy(this.fields()[33].schema(), (Object)other.publisherType));
                this.fieldSetFlags()[33] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[34], (Object)other.representative)) {
                this.representative = (String)this.data().deepCopy(this.fields()[34].schema(), (Object)other.representative);
                this.fieldSetFlags()[34] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[35], (Object)((Object)other.representativeType))) {
                this.representativeType = (PublisherTypeEnum)((Object)this.data().deepCopy(this.fields()[35].schema(), (Object)other.representativeType));
                this.fieldSetFlags()[35] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[36], (Object)other.secondsBeforeTimeSpanForReminder)) {
                this.secondsBeforeTimeSpanForReminder = (Integer)this.data().deepCopy(this.fields()[36].schema(), (Object)other.secondsBeforeTimeSpanForReminder);
                this.fieldSetFlags()[36] = true;
            }
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String value) {
            this.validate(this.fields()[0], value);
            this.id = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasId() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearId() {
            this.id = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getUid() {
            return this.uid;
        }

        public Builder setUid(String value) {
            this.validate(this.fields()[1], value);
            this.uid = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasUid() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearUid() {
            this.uid = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getParentCardId() {
            return this.parentCardId;
        }

        public Builder setParentCardId(String value) {
            this.validate(this.fields()[2], value);
            this.parentCardId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasParentCardId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearParentCardId() {
            this.parentCardId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getInitialParentCardUid() {
            return this.initialParentCardUid;
        }

        public Builder setInitialParentCardUid(String value) {
            this.validate(this.fields()[3], value);
            this.initialParentCardUid = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasInitialParentCardUid() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearInitialParentCardUid() {
            this.initialParentCardUid = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public List<String> getExternalRecipients() {
            return this.externalRecipients;
        }

        public Builder setExternalRecipients(List<String> value) {
            this.validate(this.fields()[4], value);
            this.externalRecipients = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasExternalRecipients() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearExternalRecipients() {
            this.externalRecipients = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getPublisher() {
            return this.publisher;
        }

        public Builder setPublisher(String value) {
            this.validate(this.fields()[5], value);
            this.publisher = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasPublisher() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearPublisher() {
            this.publisher = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public String getProcessVersion() {
            return this.processVersion;
        }

        public Builder setProcessVersion(String value) {
            this.validate(this.fields()[6], value);
            this.processVersion = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasProcessVersion() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearProcessVersion() {
            this.processVersion = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public String getProcess() {
            return this.process;
        }

        public Builder setProcess(String value) {
            this.validate(this.fields()[7], value);
            this.process = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasProcess() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearProcess() {
            this.process = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public String getProcessInstanceId() {
            return this.processInstanceId;
        }

        public Builder setProcessInstanceId(String value) {
            this.validate(this.fields()[8], value);
            this.processInstanceId = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasProcessInstanceId() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearProcessInstanceId() {
            this.processInstanceId = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public String getState() {
            return this.state;
        }

        public Builder setState(String value) {
            this.validate(this.fields()[9], value);
            this.state = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasState() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearState() {
            this.state = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Instant getPublishDate() {
            return this.publishDate;
        }

        public Builder setPublishDate(Instant value) {
            this.validate(this.fields()[10], value);
            this.publishDate = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasPublishDate() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearPublishDate() {
            this.publishDate = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Instant getLttd() {
            return this.lttd;
        }

        public Builder setLttd(Instant value) {
            this.validate(this.fields()[11], value);
            this.lttd = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasLttd() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearLttd() {
            this.lttd = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Instant getStartDate() {
            return this.startDate;
        }

        public Builder setStartDate(Instant value) {
            this.validate(this.fields()[12], value);
            this.startDate = value.truncatedTo(ChronoUnit.MILLIS);
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasStartDate() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearStartDate() {
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Instant getEndDate() {
            return this.endDate;
        }

        public Builder setEndDate(Instant value) {
            this.validate(this.fields()[13], value);
            this.endDate = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasEndDate() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearEndDate() {
            this.endDate = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Instant getExpirationDate() {
            return this.expirationDate;
        }

        public Builder setExpirationDate(Instant value) {
            this.validate(this.fields()[14], value);
            this.expirationDate = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasExpirationDate() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearExpirationDate() {
            this.expirationDate = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public SeverityType getSeverity() {
            return this.severity;
        }

        public Builder setSeverity(SeverityType value) {
            this.validate(this.fields()[15], (Object)value);
            this.severity = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasSeverity() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearSeverity() {
            this.severity = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public Builder setTags(List<String> value) {
            this.validate(this.fields()[16], value);
            this.tags = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasTags() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearTags() {
            this.tags = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public List<TimeSpan> getTimeSpans() {
            return this.timeSpans;
        }

        public Builder setTimeSpans(List<TimeSpan> value) {
            this.validate(this.fields()[17], value);
            this.timeSpans = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasTimeSpans() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearTimeSpans() {
            this.timeSpans = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public I18n getTitle() {
            return this.title;
        }

        public Builder setTitle(I18n value) {
            this.validate(this.fields()[18], (Object)value);
            this.titleBuilder = null;
            this.title = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasTitle() {
            return this.fieldSetFlags()[18];
        }

        public I18n.Builder getTitleBuilder() {
            if (this.titleBuilder == null) {
                if (this.hasTitle()) {
                    this.setTitleBuilder(I18n.newBuilder(this.title));
                } else {
                    this.setTitleBuilder(I18n.newBuilder());
                }
            }
            return this.titleBuilder;
        }

        public Builder setTitleBuilder(I18n.Builder value) {
            this.clearTitle();
            this.titleBuilder = value;
            return this;
        }

        public boolean hasTitleBuilder() {
            return this.titleBuilder != null;
        }

        public Builder clearTitle() {
            this.title = null;
            this.titleBuilder = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public I18n getSummary() {
            return this.summary;
        }

        public Builder setSummary(I18n value) {
            this.validate(this.fields()[19], (Object)value);
            this.summaryBuilder = null;
            this.summary = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasSummary() {
            return this.fieldSetFlags()[19];
        }

        public I18n.Builder getSummaryBuilder() {
            if (this.summaryBuilder == null) {
                if (this.hasSummary()) {
                    this.setSummaryBuilder(I18n.newBuilder(this.summary));
                } else {
                    this.setSummaryBuilder(I18n.newBuilder());
                }
            }
            return this.summaryBuilder;
        }

        public Builder setSummaryBuilder(I18n.Builder value) {
            this.clearSummary();
            this.summaryBuilder = value;
            return this;
        }

        public boolean hasSummaryBuilder() {
            return this.summaryBuilder != null;
        }

        public Builder clearSummary() {
            this.summary = null;
            this.summaryBuilder = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public String getTitleTranslated() {
            return this.titleTranslated;
        }

        public Builder setTitleTranslated(String value) {
            this.validate(this.fields()[20], value);
            this.titleTranslated = value;
            this.fieldSetFlags()[20] = true;
            return this;
        }

        public boolean hasTitleTranslated() {
            return this.fieldSetFlags()[20];
        }

        public Builder clearTitleTranslated() {
            this.titleTranslated = null;
            this.fieldSetFlags()[20] = false;
            return this;
        }

        public String getSummaryTranslated() {
            return this.summaryTranslated;
        }

        public Builder setSummaryTranslated(String value) {
            this.validate(this.fields()[21], value);
            this.summaryTranslated = value;
            this.fieldSetFlags()[21] = true;
            return this;
        }

        public boolean hasSummaryTranslated() {
            return this.fieldSetFlags()[21];
        }

        public Builder clearSummaryTranslated() {
            this.summaryTranslated = null;
            this.fieldSetFlags()[21] = false;
            return this;
        }

        public List<String> getUserRecipients() {
            return this.userRecipients;
        }

        public Builder setUserRecipients(List<String> value) {
            this.validate(this.fields()[22], value);
            this.userRecipients = value;
            this.fieldSetFlags()[22] = true;
            return this;
        }

        public boolean hasUserRecipients() {
            return this.fieldSetFlags()[22];
        }

        public Builder clearUserRecipients() {
            this.userRecipients = null;
            this.fieldSetFlags()[22] = false;
            return this;
        }

        public List<String> getGroupRecipients() {
            return this.groupRecipients;
        }

        public Builder setGroupRecipients(List<String> value) {
            this.validate(this.fields()[23], value);
            this.groupRecipients = value;
            this.fieldSetFlags()[23] = true;
            return this;
        }

        public boolean hasGroupRecipients() {
            return this.fieldSetFlags()[23];
        }

        public Builder clearGroupRecipients() {
            this.groupRecipients = null;
            this.fieldSetFlags()[23] = false;
            return this;
        }

        public List<String> getEntitiesAllowedToRespond() {
            return this.entitiesAllowedToRespond;
        }

        public Builder setEntitiesAllowedToRespond(List<String> value) {
            this.validate(this.fields()[24], value);
            this.entitiesAllowedToRespond = value;
            this.fieldSetFlags()[24] = true;
            return this;
        }

        public boolean hasEntitiesAllowedToRespond() {
            return this.fieldSetFlags()[24];
        }

        public Builder clearEntitiesAllowedToRespond() {
            this.entitiesAllowedToRespond = null;
            this.fieldSetFlags()[24] = false;
            return this;
        }

        public List<String> getEntitiesRequiredToRespond() {
            return this.entitiesRequiredToRespond;
        }

        public Builder setEntitiesRequiredToRespond(List<String> value) {
            this.validate(this.fields()[25], value);
            this.entitiesRequiredToRespond = value;
            this.fieldSetFlags()[25] = true;
            return this;
        }

        public boolean hasEntitiesRequiredToRespond() {
            return this.fieldSetFlags()[25];
        }

        public Builder clearEntitiesRequiredToRespond() {
            this.entitiesRequiredToRespond = null;
            this.fieldSetFlags()[25] = false;
            return this;
        }

        public List<String> getEntityRecipients() {
            return this.entityRecipients;
        }

        public Builder setEntityRecipients(List<String> value) {
            this.validate(this.fields()[26], value);
            this.entityRecipients = value;
            this.fieldSetFlags()[26] = true;
            return this;
        }

        public boolean hasEntityRecipients() {
            return this.fieldSetFlags()[26];
        }

        public Builder clearEntityRecipients() {
            this.entityRecipients = null;
            this.fieldSetFlags()[26] = false;
            return this;
        }

        public List<String> getEntitiesAllowedToEdit() {
            return this.entitiesAllowedToEdit;
        }

        public Builder setEntitiesAllowedToEdit(List<String> value) {
            this.validate(this.fields()[27], value);
            this.entitiesAllowedToEdit = value;
            this.fieldSetFlags()[27] = true;
            return this;
        }

        public boolean hasEntitiesAllowedToEdit() {
            return this.fieldSetFlags()[27];
        }

        public Builder clearEntitiesAllowedToEdit() {
            this.entitiesAllowedToEdit = null;
            this.fieldSetFlags()[27] = false;
            return this;
        }

        public String getWktGeometry() {
            return this.wktGeometry;
        }

        public Builder setWktGeometry(String value) {
            this.validate(this.fields()[28], value);
            this.wktGeometry = value;
            this.fieldSetFlags()[28] = true;
            return this;
        }

        public boolean hasWktGeometry() {
            return this.fieldSetFlags()[28];
        }

        public Builder clearWktGeometry() {
            this.wktGeometry = null;
            this.fieldSetFlags()[28] = false;
            return this;
        }

        public String getWktProjection() {
            return this.wktProjection;
        }

        public Builder setWktProjection(String value) {
            this.validate(this.fields()[29], value);
            this.wktProjection = value;
            this.fieldSetFlags()[29] = true;
            return this;
        }

        public boolean hasWktProjection() {
            return this.fieldSetFlags()[29];
        }

        public Builder clearWktProjection() {
            this.wktProjection = null;
            this.fieldSetFlags()[29] = false;
            return this;
        }

        public String getData() {
            return this.data;
        }

        public Builder setData(String value) {
            this.validate(this.fields()[30], value);
            this.data = value;
            this.fieldSetFlags()[30] = true;
            return this;
        }

        public boolean hasData() {
            return this.fieldSetFlags()[30];
        }

        public Builder clearData() {
            this.data = null;
            this.fieldSetFlags()[30] = false;
            return this;
        }

        public Boolean getHasBeenAcknowledged() {
            return this.hasBeenAcknowledged;
        }

        public Builder setHasBeenAcknowledged(Boolean value) {
            this.validate(this.fields()[31], value);
            this.hasBeenAcknowledged = value;
            this.fieldSetFlags()[31] = true;
            return this;
        }

        public boolean hasHasBeenAcknowledged() {
            return this.fieldSetFlags()[31];
        }

        public Builder clearHasBeenAcknowledged() {
            this.hasBeenAcknowledged = null;
            this.fieldSetFlags()[31] = false;
            return this;
        }

        public Boolean getHasBeenRead() {
            return this.hasBeenRead;
        }

        public Builder setHasBeenRead(Boolean value) {
            this.validate(this.fields()[32], value);
            this.hasBeenRead = value;
            this.fieldSetFlags()[32] = true;
            return this;
        }

        public boolean hasHasBeenRead() {
            return this.fieldSetFlags()[32];
        }

        public Builder clearHasBeenRead() {
            this.hasBeenRead = null;
            this.fieldSetFlags()[32] = false;
            return this;
        }

        public PublisherTypeEnum getPublisherType() {
            return this.publisherType;
        }

        public Builder setPublisherType(PublisherTypeEnum value) {
            this.validate(this.fields()[33], (Object)value);
            this.publisherType = value;
            this.fieldSetFlags()[33] = true;
            return this;
        }

        public boolean hasPublisherType() {
            return this.fieldSetFlags()[33];
        }

        public Builder clearPublisherType() {
            this.publisherType = null;
            this.fieldSetFlags()[33] = false;
            return this;
        }

        public String getRepresentative() {
            return this.representative;
        }

        public Builder setRepresentative(String value) {
            this.validate(this.fields()[34], value);
            this.representative = value;
            this.fieldSetFlags()[34] = true;
            return this;
        }

        public boolean hasRepresentative() {
            return this.fieldSetFlags()[34];
        }

        public Builder clearRepresentative() {
            this.representative = null;
            this.fieldSetFlags()[34] = false;
            return this;
        }

        public PublisherTypeEnum getRepresentativeType() {
            return this.representativeType;
        }

        public Builder setRepresentativeType(PublisherTypeEnum value) {
            this.validate(this.fields()[35], (Object)value);
            this.representativeType = value;
            this.fieldSetFlags()[35] = true;
            return this;
        }

        public boolean hasRepresentativeType() {
            return this.fieldSetFlags()[35];
        }

        public Builder clearRepresentativeType() {
            this.representativeType = null;
            this.fieldSetFlags()[35] = false;
            return this;
        }

        public Integer getSecondsBeforeTimeSpanForReminder() {
            return this.secondsBeforeTimeSpanForReminder;
        }

        public Builder setSecondsBeforeTimeSpanForReminder(Integer value) {
            this.validate(this.fields()[36], value);
            this.secondsBeforeTimeSpanForReminder = value;
            this.fieldSetFlags()[36] = true;
            return this;
        }

        public boolean hasSecondsBeforeTimeSpanForReminder() {
            return this.fieldSetFlags()[36];
        }

        public Builder clearSecondsBeforeTimeSpanForReminder() {
            this.secondsBeforeTimeSpanForReminder = null;
            this.fieldSetFlags()[36] = false;
            return this;
        }

        public ResponseCard build() {
            try {
                ResponseCard record = new ResponseCard();
                record.id = this.fieldSetFlags()[0] ? this.id : (String)this.defaultValue(this.fields()[0]);
                record.uid = this.fieldSetFlags()[1] ? this.uid : (String)this.defaultValue(this.fields()[1]);
                record.parentCardId = this.fieldSetFlags()[2] ? this.parentCardId : (String)this.defaultValue(this.fields()[2]);
                record.initialParentCardUid = this.fieldSetFlags()[3] ? this.initialParentCardUid : (String)this.defaultValue(this.fields()[3]);
                record.externalRecipients = this.fieldSetFlags()[4] ? this.externalRecipients : (List)this.defaultValue(this.fields()[4]);
                record.publisher = this.fieldSetFlags()[5] ? this.publisher : (String)this.defaultValue(this.fields()[5]);
                record.processVersion = this.fieldSetFlags()[6] ? this.processVersion : (String)this.defaultValue(this.fields()[6]);
                record.process = this.fieldSetFlags()[7] ? this.process : (String)this.defaultValue(this.fields()[7]);
                record.processInstanceId = this.fieldSetFlags()[8] ? this.processInstanceId : (String)this.defaultValue(this.fields()[8]);
                record.state = this.fieldSetFlags()[9] ? this.state : (String)this.defaultValue(this.fields()[9]);
                record.publishDate = this.fieldSetFlags()[10] ? this.publishDate : (Instant)this.defaultValue(this.fields()[10]);
                record.lttd = this.fieldSetFlags()[11] ? this.lttd : (Instant)this.defaultValue(this.fields()[11]);
                record.startDate = this.fieldSetFlags()[12] ? this.startDate : (Instant)this.defaultValue(this.fields()[12]);
                record.endDate = this.fieldSetFlags()[13] ? this.endDate : (Instant)this.defaultValue(this.fields()[13]);
                record.expirationDate = this.fieldSetFlags()[14] ? this.expirationDate : (Instant)this.defaultValue(this.fields()[14]);
                record.severity = this.fieldSetFlags()[15] ? this.severity : (SeverityType)((Object)this.defaultValue(this.fields()[15]));
                record.tags = this.fieldSetFlags()[16] ? this.tags : (List)this.defaultValue(this.fields()[16]);
                List<TimeSpan> list = record.timeSpans = this.fieldSetFlags()[17] ? this.timeSpans : (List<TimeSpan>)this.defaultValue(this.fields()[17]);
                if (this.titleBuilder != null) {
                    try {
                        record.title = this.titleBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("title"));
                        throw e;
                    }
                } else {
                    I18n i18n = record.title = this.fieldSetFlags()[18] ? this.title : (I18n)((Object)this.defaultValue(this.fields()[18]));
                }
                if (this.summaryBuilder != null) {
                    try {
                        record.summary = this.summaryBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("summary"));
                        throw e;
                    }
                } else {
                    record.summary = this.fieldSetFlags()[19] ? this.summary : (I18n)((Object)this.defaultValue(this.fields()[19]));
                }
                record.titleTranslated = this.fieldSetFlags()[20] ? this.titleTranslated : (String)this.defaultValue(this.fields()[20]);
                record.summaryTranslated = this.fieldSetFlags()[21] ? this.summaryTranslated : (String)this.defaultValue(this.fields()[21]);
                record.userRecipients = this.fieldSetFlags()[22] ? this.userRecipients : (List)this.defaultValue(this.fields()[22]);
                record.groupRecipients = this.fieldSetFlags()[23] ? this.groupRecipients : (List)this.defaultValue(this.fields()[23]);
                record.entitiesAllowedToRespond = this.fieldSetFlags()[24] ? this.entitiesAllowedToRespond : (List)this.defaultValue(this.fields()[24]);
                record.entitiesRequiredToRespond = this.fieldSetFlags()[25] ? this.entitiesRequiredToRespond : (List)this.defaultValue(this.fields()[25]);
                record.entityRecipients = this.fieldSetFlags()[26] ? this.entityRecipients : (List)this.defaultValue(this.fields()[26]);
                record.entitiesAllowedToEdit = this.fieldSetFlags()[27] ? this.entitiesAllowedToEdit : (List)this.defaultValue(this.fields()[27]);
                record.wktGeometry = this.fieldSetFlags()[28] ? this.wktGeometry : (String)this.defaultValue(this.fields()[28]);
                record.wktProjection = this.fieldSetFlags()[29] ? this.wktProjection : (String)this.defaultValue(this.fields()[29]);
                record.data = this.fieldSetFlags()[30] ? this.data : (String)this.defaultValue(this.fields()[30]);
                record.hasBeenAcknowledged = this.fieldSetFlags()[31] ? this.hasBeenAcknowledged : (Boolean)this.defaultValue(this.fields()[31]);
                record.hasBeenRead = this.fieldSetFlags()[32] ? this.hasBeenRead : (Boolean)this.defaultValue(this.fields()[32]);
                record.publisherType = this.fieldSetFlags()[33] ? this.publisherType : (PublisherTypeEnum)((Object)this.defaultValue(this.fields()[33]));
                record.representative = this.fieldSetFlags()[34] ? this.representative : (String)this.defaultValue(this.fields()[34]);
                record.representativeType = this.fieldSetFlags()[35] ? this.representativeType : (PublisherTypeEnum)((Object)this.defaultValue(this.fields()[35]));
                record.secondsBeforeTimeSpanForReminder = this.fieldSetFlags()[36] ? this.secondsBeforeTimeSpanForReminder : (Integer)this.defaultValue(this.fields()[36]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

