/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.opoo.ootp.client.ExsClient;
import org.opoo.ootp.client.OotpException;
import org.springframework.util.StreamUtils;

public interface OotpClient {
    public static final String STORAGE_DEFAULT = "default";
    public static final String STORAGE_FS = "fs";

    public ExsClient getExsClient();

    default public String uploadToFsStorage(String repo, String contentType, File file) throws IOException, OotpException {
        return this.upload(STORAGE_FS, repo, contentType, file);
    }

    default public String uploadToFsStorage(String repo, String contentType, File file, String pathInfo) throws IOException, OotpException {
        return this.upload(STORAGE_FS, repo, contentType, file, pathInfo);
    }

    default public String uploadToFsStorage(String repo, String contentType, InputStream file, String fileName, long fileSize, long lastModified) throws IOException, OotpException {
        return this.upload(STORAGE_FS, repo, contentType, file, fileName, fileSize, lastModified);
    }

    default public String uploadToFsStorage(String repo, String contentType, InputStream file, String fileName, long fileSize, long lastModified, String pathInfo) throws IOException, OotpException {
        return this.upload(STORAGE_FS, repo, contentType, file, fileName, fileSize, lastModified, pathInfo);
    }

    default public String uploadToDefaultStorage(String to, String contentType, File file) throws IOException, OotpException {
        return this.upload(STORAGE_DEFAULT, to, contentType, file);
    }

    default public String uploadToDefaultStorage(String to, String contentType, File file, String pathInfo) throws IOException, OotpException {
        return this.upload(STORAGE_DEFAULT, to, contentType, file, pathInfo);
    }

    default public String uploadToDefaultStorage(String to, String contentType, InputStream file, String fileName, long fileSize, long lastModified) throws IOException, OotpException {
        return this.upload(STORAGE_DEFAULT, to, contentType, file, fileName, fileSize, lastModified);
    }

    default public String uploadToDefaultStorage(String to, String contentType, InputStream file, String fileName, long fileSize, long lastModified, String pathInfo) throws IOException, OotpException {
        return this.upload(STORAGE_DEFAULT, to, contentType, file, fileName, fileSize, lastModified, pathInfo);
    }

    default public String uploadToCustomStorage(String storage, String contentType, File file) throws IOException, OotpException {
        return this.upload(storage, null, contentType, file);
    }

    default public String uploadToCustomStorage(String storage, String contentType, File file, String pathInfo) throws IOException, OotpException {
        return this.upload(storage, null, contentType, file, pathInfo);
    }

    default public String uploadToCustomStorage(String storage, String contentType, InputStream file, String fileName, long fileSize, long lastModified) throws IOException, OotpException {
        return this.upload(storage, null, contentType, file, fileName, fileSize, lastModified);
    }

    default public String uploadToCustomStorage(String storage, String contentType, InputStream file, String fileName, long fileSize, long lastModified, String pathInfo) throws IOException, OotpException {
        return this.upload(storage, null, contentType, file, fileName, fileSize, lastModified, pathInfo);
    }

    default public String upload(String storage, String to, String contentType, File file) throws IOException, OotpException {
        return this.upload(storage, to, contentType, file, null);
    }

    default public String upload(String storage, String to, String contentType, File file, String pathInfo) throws IOException, OotpException {
        try (FileInputStream fis = new FileInputStream(file);){
            String string = this.upload(storage, to, contentType, fis, file.getName(), file.length(), file.lastModified(), pathInfo);
            return string;
        }
    }

    default public String upload(String storage, String to, String contentType, InputStream file, String fileName, long fileSize, long lastModified) throws IOException, OotpException {
        return this.upload(storage, to, contentType, file, fileName, fileSize, lastModified, null);
    }

    public String upload(String var1, String var2, String var3, InputStream var4, String var5, long var6, long var8, String var10) throws IOException, OotpException;

    public InputStream download(String var1);

    default public void copy(String fileId, File destination) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(destination);){
            this.copy(fileId, fos);
        }
    }

    default public void copy(String fileId, Path destination) throws IOException {
        try (InputStream inputStream = this.download(fileId);){
            Files.copy(inputStream, destination, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    default public void copy(String fileId, OutputStream outputStream) throws IOException {
        try (InputStream inputStream = this.download(fileId);){
            StreamUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }
}

