/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opoo.ootp.client.OotpClient;
import org.opoo.ootp.client.OotpException;
import org.opoo.ootp.signer.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractOotpClient
implements OotpClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractOotpClient.class);
    public static final String RFC822_FORMAT = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    public static DateTimeFormatter RFC822 = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withZone(ZoneId.of("GMT")).withLocale(Locale.US);
    public static final String FILE_ID_FIELD = "fileId";
    protected final RestTemplate restTemplate;

    AbstractOotpClient(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @Override
    public String upload(String storage, String to, String contentType, InputStream file, String fileName, long fileSize, long lastModified, String pathInfo) throws IOException, OotpException {
        Objects.requireNonNull(storage, "storage is required.");
        Objects.requireNonNull(contentType, "contentType is required.");
        Objects.requireNonNull(file, "file is required.");
        Objects.requireNonNull(fileName, "fileName is required.");
        String path = "/upload";
        if (pathInfo != null) {
            path = path + pathInfo;
        }
        path = path + "?storage=" + storage;
        RequestEntity.BodyBuilder builder = (RequestEntity.BodyBuilder)RequestEntity.put((URI)URI.create(path)).contentType(MediaType.parseMediaType((String)contentType)).header(Signer.HEADER_NAME_PREFIX + "meta-file-name", new String[]{URLEncoder.encode(fileName, "UTF-8")});
        if ("fs".equals(storage)) {
            String repo = Objects.requireNonNull(to, "repo is required.");
            builder.header(Signer.HEADER_NAME_PREFIX + "repo", new String[]{repo});
        } else if ("default".equals(storage)) {
            Objects.requireNonNull(to, "to is required.");
            builder.header(Signer.HEADER_NAME_PREFIX + "exs-to", new String[]{to});
        }
        if (lastModified > 0L) {
            builder.header(Signer.HEADER_NAME_PREFIX + "meta-last-modified", new String[]{RFC822.format(Instant.ofEpochMilli(lastModified))});
        }
        if (fileSize > 0L) {
            builder.contentLength(fileSize);
        }
        RequestEntity requestEntity = builder.body((Object)new InputStreamResource(file));
        ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, Map.class);
        return Optional.ofNullable(responseEntity.getBody()).map(m -> (String)m.get(FILE_ID_FIELD)).orElseThrow(() -> new OotpException("\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a", 500, "ResponseEmptyBody"));
    }

    protected <T> T downloadInternal(String fileId, ResponseExtractor<T> extractor) {
        Objects.requireNonNull(fileId, "fileId is required.");
        return (T)this.restTemplate.execute("/file/" + fileId, HttpMethod.GET, null, extractor, new Object[0]);
    }

    @Override
    public InputStream download(String fileId) {
        return (InputStream)this.downloadInternal(fileId, response -> OotpFileCachedInputStream.of(response.getBody(), fileId));
    }

    @Override
    public void copy(String fileId, File destination) throws IOException {
        this.downloadInternal(fileId, response -> {
            Files.copy(response.getBody(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return null;
        });
    }

    @Override
    public void copy(String fileId, Path destination) throws IOException {
        this.downloadInternal(fileId, response -> {
            Files.copy(response.getBody(), destination, StandardCopyOption.REPLACE_EXISTING);
            return null;
        });
    }

    @Override
    public void copy(String fileId, OutputStream outputStream) throws IOException {
        this.downloadInternal(fileId, response -> {
            StreamUtils.copy((InputStream)response.getBody(), (OutputStream)outputStream);
            return null;
        });
    }

    static class OotpFileCachedInputStream
    extends FilterInputStream {
        private static final Logger log = LoggerFactory.getLogger(OotpFileCachedInputStream.class);
        private final Path file;

        protected OotpFileCachedInputStream(InputStream in, Path file) {
            super(in);
            this.file = file;
        }

        @Override
        public void close() throws IOException {
            super.close();
            boolean result = Files.deleteIfExists(this.file);
            log.debug("\u5173\u95ed\u65f6\u5220\u9664\u4e34\u65f6\u6587\u4ef6\uff1a{} - {}", (Object)this.file, (Object)result);
        }

        static OotpFileCachedInputStream of(InputStream originalInputStream, String fileId) throws IOException {
            Path path = Files.createTempFile("ootp", fileId, new FileAttribute[0]);
            log.debug("\u590d\u5236\u5230\u4e34\u65f6\u6587\u4ef6\uff1a{}", (Object)path);
            Files.copy(originalInputStream, path, StandardCopyOption.REPLACE_EXISTING);
            return new OotpFileCachedInputStream(Files.newInputStream(path, new OpenOption[0]), path);
        }
    }
}

