/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.constant.Constable;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opoo.ootp.client.ExsClient;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsMessageContent;
import org.opoo.ootp.client.OotpException;
import org.opoo.ootp.client.impl.AbstractOotpClient;
import org.opoo.ootp.signer.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.web.client.RestTemplate;

class ExsClientV1
extends AbstractOotpClient
implements ExsClient {
    private static final Logger log = LoggerFactory.getLogger(ExsClientV1.class);
    private final ObjectMapper objectMapper = Jackson2ObjectMapperBuilder.json().failOnEmptyBeans(false).failOnUnknownProperties(false).build();

    ExsClientV1(RestTemplate restTemplate) {
        super(restTemplate);
    }

    @Override
    public ExsClient getExsClient() {
        return this;
    }

    @Override
    public void send(String type, String to, String contentType, String body) throws OotpException {
        this.sendInternal(type, to, contentType, body);
    }

    @Override
    public void send(String type, String to, String contentType, byte[] body) throws OotpException {
        this.sendInternal(type, to, contentType, body);
    }

    void sendInternal(String type, String to, String contentType, Object body) throws OotpException {
        Objects.requireNonNull(type, "type is required.");
        Objects.requireNonNull(to, "to is required.");
        Objects.requireNonNull(contentType, "contentType is required.");
        Objects.requireNonNull(body, "body is required.");
        RequestEntity requestEntity = ((RequestEntity.BodyBuilder)((RequestEntity.BodyBuilder)RequestEntity.put((URI)URI.create("/exs/api/messages/v1")).header(Signer.HEADER_NAME_PREFIX + "exs-type", new String[]{type})).header(Signer.HEADER_NAME_PREFIX + "exs-to", new String[]{to})).contentType(MediaType.parseMediaType((String)contentType)).body(body);
        ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, MessageWrapper.class);
        MessageWrapper messageWrapper = (MessageWrapper)Optional.ofNullable(responseEntity.getBody()).orElseThrow(() -> new OotpException("\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a", 500, "ResponseEmptyBody"));
        log.debug("send result: {}", (Object)messageWrapper);
        if (!messageWrapper.isSuccess()) {
            throw new OotpException(messageWrapper.getErrMsg(), messageWrapper.getCode(), messageWrapper.getErrMsg());
        }
    }

    @Override
    public List<ExsMessage> poll(int limit, boolean autoAck, boolean full) throws OotpException {
        if (limit <= 0 || limit > 100) {
            limit = 100;
        }
        LinkedHashMap<String, Constable> request = new LinkedHashMap<String, Constable>();
        request.put("limit", Integer.valueOf(limit));
        request.put("autoAck", Boolean.valueOf(autoAck));
        request.put("full", Boolean.valueOf(full));
        MessageWrapper messageWrapper = (MessageWrapper)this.restTemplate.postForObject("/exs/api/messages/v1", request, MessageWrapper.class, new Object[0]);
        if (messageWrapper == null) {
            throw new OotpException("\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a", 500, "ResponseEmptyBody");
        }
        if (!messageWrapper.isSuccess()) {
            throw new OotpException(messageWrapper.getErrMsg(), messageWrapper.getCode(), messageWrapper.getErrMsg());
        }
        return Optional.ofNullable(messageWrapper.getResultData()).orElseGet(ArrayList::new).stream().map(ExsClientV1::toMessage).collect(Collectors.toList());
    }

    @Override
    public ExsMessageContent getMessageContent(String id) throws OotpException {
        Map map;
        Object success;
        Objects.requireNonNull(id, "id is required.");
        ResponseEntity responseEntity = this.restTemplate.getForEntity("/exs/api/messages/" + id + "/v1", String.class, new Object[0]);
        HttpHeaders headers = responseEntity.getHeaders();
        String body = (String)Optional.ofNullable(responseEntity.getBody()).orElseThrow(() -> new OotpException("\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a", 500, "ResponseEmptyBody"));
        MediaType contentType = Optional.ofNullable(headers.getContentType()).orElseThrow(() -> new OotpException("\u54cd\u5e94\u7f3a\u5c11\u7c7b\u578b", 500, "ResponseNoContentType"));
        if (MediaType.APPLICATION_JSON.isCompatibleWith(contentType) && (success = (map = (Map)this.objectMapper.readValue(body, Map.class)).get("success")) instanceof Boolean && !((Boolean)success).booleanValue()) {
            throw new OotpException((String)map.get("errMsg"));
        }
        return new ExsMessageContent(contentType.toString(), body);
    }

    @Override
    public void ack(List<String> ids) throws OotpException {
        if (ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("ids \u4e0d\u80fd\u4e3a\u7a7a");
        }
        LinkedHashMap<String, Object> request = new LinkedHashMap<String, Object>();
        if (ids.size() == 1) {
            request.put("id", ids.iterator().next());
        } else {
            request.put("ids", ids);
        }
        MessageWrapper messageWrapper = (MessageWrapper)this.restTemplate.postForObject("/exs/api/messages/ack/v1", request, MessageWrapper.class, new Object[0]);
        if (messageWrapper == null) {
            throw new OotpException("\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a", 500, "ResponseEmptyBody");
        }
        log.debug("ack result: {}", (Object)messageWrapper);
        if (!messageWrapper.isSuccess()) {
            throw new OotpException(messageWrapper.getErrMsg(), messageWrapper.getCode(), messageWrapper.getErrMsg());
        }
    }

    private static ExsMessage toMessage(MessageV1 messageV1) {
        ExsMessage exsMessage = new ExsMessage();
        exsMessage.setId(messageV1.getId());
        exsMessage.setType(messageV1.getBizType());
        exsMessage.setFrom(messageV1.getFromSysId());
        exsMessage.setContentType(messageV1.getContentType());
        exsMessage.setBody(messageV1.getMsgBody());
        return exsMessage;
    }

    public static class MessageV1 {
        private String id;
        private String bizType;
        private String fromSysId;
        private String contentType;
        private String msgBody;

        public String getId() {
            return this.id;
        }

        public String getBizType() {
            return this.bizType;
        }

        public String getFromSysId() {
            return this.fromSysId;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getMsgBody() {
            return this.msgBody;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setBizType(String bizType) {
            this.bizType = bizType;
        }

        public void setFromSysId(String fromSysId) {
            this.fromSysId = fromSysId;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public void setMsgBody(String msgBody) {
            this.msgBody = msgBody;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageV1)) {
                return false;
            }
            MessageV1 other = (MessageV1)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$bizType = this.getBizType();
            String other$bizType = other.getBizType();
            if (this$bizType == null ? other$bizType != null : !this$bizType.equals(other$bizType)) {
                return false;
            }
            String this$fromSysId = this.getFromSysId();
            String other$fromSysId = other.getFromSysId();
            if (this$fromSysId == null ? other$fromSysId != null : !this$fromSysId.equals(other$fromSysId)) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
                return false;
            }
            String this$msgBody = this.getMsgBody();
            String other$msgBody = other.getMsgBody();
            return !(this$msgBody == null ? other$msgBody != null : !this$msgBody.equals(other$msgBody));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageV1;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $bizType = this.getBizType();
            result = result * 59 + ($bizType == null ? 43 : $bizType.hashCode());
            String $fromSysId = this.getFromSysId();
            result = result * 59 + ($fromSysId == null ? 43 : $fromSysId.hashCode());
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            String $msgBody = this.getMsgBody();
            result = result * 59 + ($msgBody == null ? 43 : $msgBody.hashCode());
            return result;
        }

        public String toString() {
            return "ExsClientV1.MessageV1(id=" + this.getId() + ", bizType=" + this.getBizType() + ", fromSysId=" + this.getFromSysId() + ", contentType=" + this.getContentType() + ", msgBody=" + this.getMsgBody() + ")";
        }
    }

    public static class MessageWrapper {
        private boolean success;
        private int code;
        private String errMsg;
        private List<MessageV1> resultData;

        public boolean isSuccess() {
            return this.success;
        }

        public int getCode() {
            return this.code;
        }

        public String getErrMsg() {
            return this.errMsg;
        }

        public List<MessageV1> getResultData() {
            return this.resultData;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setErrMsg(String errMsg) {
            this.errMsg = errMsg;
        }

        public void setResultData(List<MessageV1> resultData) {
            this.resultData = resultData;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageWrapper)) {
                return false;
            }
            MessageWrapper other = (MessageWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$errMsg = this.getErrMsg();
            String other$errMsg = other.getErrMsg();
            if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
                return false;
            }
            List<MessageV1> this$resultData = this.getResultData();
            List<MessageV1> other$resultData = other.getResultData();
            return !(this$resultData == null ? other$resultData != null : !((Object)this$resultData).equals(other$resultData));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            result = result * 59 + this.getCode();
            String $errMsg = this.getErrMsg();
            result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
            List<MessageV1> $resultData = this.getResultData();
            result = result * 59 + ($resultData == null ? 43 : ((Object)$resultData).hashCode());
            return result;
        }

        public String toString() {
            return "ExsClientV1.MessageWrapper(success=" + this.isSuccess() + ", code=" + this.getCode() + ", errMsg=" + this.getErrMsg() + ", resultData=" + this.getResultData() + ")";
        }
    }
}

