/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import java.lang.constant.Constable;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opoo.ootp.client.ExsClient;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsMessageContent;
import org.opoo.ootp.client.OotpClient;
import org.opoo.ootp.client.OotpException;
import org.opoo.ootp.client.impl.AbstractOotpClient;
import org.opoo.ootp.signer.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

class ExsClientV2
extends AbstractOotpClient
implements ExsClient,
OotpClient {
    private static final Logger log = LoggerFactory.getLogger(ExsClientV2.class);

    ExsClientV2(RestTemplate restTemplate) {
        super(restTemplate);
    }

    @Override
    public ExsClient getExsClient() {
        return this;
    }

    @Override
    public void send(String type, String to, String contentType, String body) throws OotpException {
        this.sendInternal(type, to, contentType, body);
    }

    @Override
    public void send(String type, String to, String contentType, byte[] body) throws OotpException {
        this.sendInternal(type, to, contentType, body);
    }

    void sendInternal(String type, String to, String contentType, Object body) throws OotpException {
        Objects.requireNonNull(type, "type is required.");
        Objects.requireNonNull(to, "to is required.");
        Objects.requireNonNull(contentType, "contentType is required.");
        Objects.requireNonNull(body, "body is required.");
        RequestEntity requestEntity = ((RequestEntity.BodyBuilder)((RequestEntity.BodyBuilder)RequestEntity.put((URI)URI.create("/exs/api/messages/v2")).header(Signer.HEADER_NAME_PREFIX + "exs-type", new String[]{type})).header(Signer.HEADER_NAME_PREFIX + "exs-to", new String[]{to})).contentType(MediaType.parseMediaType((String)contentType)).body(body);
        ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, String.class);
        log.debug("send result: {}", responseEntity.getBody());
    }

    @Override
    public List<ExsMessage> poll(int limit, boolean autoAck, boolean full) throws OotpException {
        if (limit <= 0 || limit > 100) {
            limit = 100;
        }
        LinkedHashMap<String, Constable> request = new LinkedHashMap<String, Constable>();
        request.put("limit", Integer.valueOf(limit));
        request.put("autoAck", Boolean.valueOf(autoAck));
        request.put("full", Boolean.valueOf(full));
        ExsMessage[] messages = (ExsMessage[])this.restTemplate.postForObject("/exs/api/messages/v2", request, ExsMessage[].class, new Object[0]);
        return Arrays.asList((Object[])Objects.requireNonNull(messages));
    }

    @Override
    public ExsMessageContent getMessageContent(String id) throws OotpException {
        Objects.requireNonNull(id, "id is required.");
        ResponseEntity responseEntity = this.restTemplate.getForEntity("/exs/api/messages/" + id + "/v2", String.class, new Object[0]);
        HttpHeaders headers = responseEntity.getHeaders();
        String body = (String)Optional.ofNullable(responseEntity.getBody()).orElseThrow(() -> new OotpException("\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a", 500, "ResponseEmptyBody"));
        MediaType contentType = Optional.ofNullable(headers.getContentType()).orElseThrow(() -> new OotpException("\u54cd\u5e94\u7f3a\u5c11\u7c7b\u578b", 500, "ResponseNoContentType"));
        return new ExsMessageContent(contentType.toString(), body);
    }

    @Override
    public void ack(List<String> ids) throws OotpException {
        if (ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("ids \u4e0d\u80fd\u4e3a\u7a7a");
        }
        LinkedHashMap<String, Object> request = new LinkedHashMap<String, Object>();
        if (ids.size() == 1) {
            request.put("id", ids.iterator().next());
        } else {
            request.put("ids", ids);
        }
        String result = (String)this.restTemplate.postForObject("/exs/api/messages/ack/v2", request, String.class, new Object[0]);
        log.debug("ack result: {}", (Object)result);
    }
}

