/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import java.net.URI;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.opoo.ootp.client.OotpClient;
import org.opoo.ootp.client.impl.ExsClientV1;
import org.opoo.ootp.client.impl.ExsClientV2;
import org.opoo.ootp.signer.SM3Signer;
import org.opoo.ootp.signer.Signer;
import org.opoo.ootp.signer.spring.SignerClientHttpRequestInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.support.HttpRequestWrapper;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class OotpClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(OotpClientBuilder.class);
    private URI endpoint;
    private Signer signer;
    private RestTemplate restTemplate;
    private boolean version2 = false;
    private String accessKey;
    private String secretKey;

    private OotpClientBuilder() {
    }

    public static OotpClient defaultClient(URI endpoint, Signer signer) {
        return new OotpClientBuilder().endpoint(endpoint).signer(signer).build();
    }

    public static OotpClient defaultClient(String endpoint, Signer signer) {
        return OotpClientBuilder.defaultClient(URI.create(endpoint), signer);
    }

    public static OotpClientBuilder custom() {
        return new OotpClientBuilder();
    }

    public OotpClientBuilder credentials(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        return this;
    }

    public OotpClientBuilder signer(Signer signer) {
        this.signer = signer;
        return this;
    }

    public OotpClientBuilder endpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public OotpClientBuilder endpoint(String endpoint) {
        this.endpoint = URI.create(endpoint);
        return this;
    }

    public OotpClientBuilder restTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        return this;
    }

    public OotpClientBuilder useVersion2() {
        this.version2 = true;
        return this;
    }

    public RestTemplate buildRestTemplate() {
        Assert.notNull((Object)this.endpoint, (String)"\u5fc5\u987b\u8bbe\u7f6e endpoint");
        Signer signer = this.signer;
        RestTemplate restTemplate = this.restTemplate;
        if (signer == null) {
            if (this.accessKey == null || this.secretKey == null) {
                throw new IllegalArgumentException("\u5fc5\u987b\u8bbe\u7f6e signer \u6216\u8005 accessKey/secretKey");
            }
            log.debug("\u9ed8\u8ba4\u4f7f\u7528 SMSigner");
            signer = new SM3Signer(this.accessKey, this.secretKey);
        }
        if (restTemplate == null) {
            restTemplate = new RestTemplate();
            if (ClassUtils.isPresent((String)"org.apache.http.impl.client.HttpClients", (ClassLoader)OotpClientBuilder.class.getClassLoader())) {
                log.debug("Using Apache HttpComponents as ClientRequestFactory ...");
                restTemplate.setRequestFactory(HttpComponentsClientHttpRequestFactoryCreator.create());
            }
        }
        List interceptors = restTemplate.getInterceptors();
        interceptors.add((request, body, execution) -> execution.execute((HttpRequest)new EndpointProcessingHttpRequestWrapper(request, this.endpoint), body));
        interceptors.add(new SignerClientHttpRequestInterceptor(signer));
        return restTemplate;
    }

    public OotpClient build() {
        RestTemplate restTemplate = this.buildRestTemplate();
        return this.version2 ? new ExsClientV2(restTemplate) : new ExsClientV1(restTemplate);
    }

    static class EndpointProcessingHttpRequestWrapper
    extends HttpRequestWrapper {
        private final URI endpoint;
        private URI uri;

        public EndpointProcessingHttpRequestWrapper(HttpRequest request, URI endpoint) {
            super(request);
            this.endpoint = endpoint;
        }

        public URI getURI() {
            if (this.uri == null) {
                this.uri = this.processUri(super.getURI());
            }
            return this.uri;
        }

        private URI processUri(URI originalUri) {
            if (originalUri.isAbsolute()) {
                return originalUri;
            }
            URI uri = UriComponentsBuilder.fromUri((URI)originalUri).scheme(this.endpoint.getScheme()).host(this.endpoint.getHost()).port(this.endpoint.getPort()).build().toUri();
            log.debug("URI \u8865\u5168\uff1a{} -> {}", (Object)originalUri, (Object)uri);
            return uri;
        }
    }

    static class HttpComponentsClientHttpRequestFactoryCreator {
        HttpComponentsClientHttpRequestFactoryCreator() {
        }

        static ClientHttpRequestFactory create() {
            CloseableHttpClient httpClient = HttpClients.custom().disableAuthCaching().disableCookieManagement().disableRedirectHandling().setMaxConnPerRoute(20).setMaxConnTotal(20).build();
            return new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        }
    }
}

