package org.opoo.ootp.client.impl;

import com.emc.codec.encryption.KeyProvider;
import org.opoo.ootp.client.KeyProviderManager;
import org.opoo.ootp.codec.encryption.KeyAndSpecProvider;
import org.opoo.ootp.codec.encryption.PrivateKeyProvider;

import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;

public class BasicKeyProviderManager implements KeyProviderManager {
    private final Map<String, KeyAndSpecProvider> sm4KeyProviders = new HashMap<>();
    private final Map<String, PublicKey> sm2PublicKeys = new HashMap<>();
    private final Map<String, KeyProvider> rsaKeyProviders = new HashMap<>();
    private PrivateKeyProvider sm2PrivateKeyProvider;

    @Override
    public PrivateKeyProvider getSM2PrivateKeyProvider() {
        return sm2PrivateKeyProvider;
    }

    public void setSM2PrivateKeyProvider(PrivateKeyProvider sm2PrivateKeyProvider) {
        this.sm2PrivateKeyProvider = sm2PrivateKeyProvider;
    }

    @Override
    public KeyAndSpecProvider getSM4KeyProvider(String to) {
        return sm4KeyProviders.get(to);
    }

    @Override
    public PublicKey getSM2PublicKey(String to) {
        return sm2PublicKeys.get(to);
    }

    @Override
    public KeyProvider getRSAKeyProvider(String to) {
        return rsaKeyProviders.get(to);
    }

    public BasicKeyProviderManager addSM4KeyProvider(String to, KeyAndSpecProvider keyProvider) {
        sm4KeyProviders.put(to, keyProvider);
        return this;
    }

    public BasicKeyProviderManager addSM2PublicKey(String to, PublicKey publicKey) {
        sm2PublicKeys.put(to, publicKey);
        return this;
    }

    public BasicKeyProviderManager addRSAKeyProvider(String to, KeyProvider keyProvider) {
        rsaKeyProviders.put(to, keyProvider);
        return this;
    }
}
