/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client;

import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.opoo.ootp.client.EntityBody;
import org.opoo.ootp.client.ExsBody;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsMessageInfo;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.client.OotpException;
import org.opoo.ootp.client.PollRequest;
import org.opoo.ootp.client.PollResult;
import org.opoo.ootp.client.StringBody;

public interface MessageClient {
    public static final int DEFAULT_LIMIT = 100;
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    public String send(ExsMessage var1) throws OotpException;

    default public String send(ExsBody body, ExsMetadata metadata) throws OotpException {
        return this.send(new ExsMessage(body, metadata));
    }

    default public String send(String body, ExsMetadata metadata) throws OotpException {
        StringBody stringBody = new StringBody(body);
        return this.send(new ExsMessage(stringBody, metadata));
    }

    default public String send(String type, String to, String contentType, String body) throws OotpException {
        ExsMetadata metadata = new ExsMetadata();
        metadata.setTo(to);
        metadata.setType(type);
        metadata.setContentType(contentType);
        return this.send(body, metadata);
    }

    @Deprecated
    default public String send(String type, String to, String contentType, byte[] body) throws OotpException {
        ExsMetadata metadata = new ExsMetadata();
        metadata.setTo(to);
        metadata.setType(type);
        metadata.setContentType(contentType);
        EntityBody entityBody = new EntityBody((HttpEntity)new ByteArrayEntity(body));
        return this.send(new ExsMessage(entityBody, metadata));
    }

    public PollResult poll(PollRequest var1) throws OotpException;

    default public PollResult poll(int limit, boolean autoAck, boolean full) throws OotpException {
        PollRequest request = new PollRequest(limit, autoAck, full);
        return this.poll(request);
    }

    default public PollResult poll() throws OotpException {
        return this.poll(100, false, false);
    }

    /*
     * Exception decompiling
     */
    default public String getMessageBody(String id) throws OotpException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ExsMessage getMessage(String var1) throws OotpException;

    public ExsMessageInfo getMessageInfo(String var1) throws OotpException;

    default public int ack(String ... ids) throws OotpException {
        return this.ack(Arrays.asList(ids));
    }

    public int ack(List<String> var1) throws OotpException;

    default public int ret(String ... ids) throws OotpException {
        return this.ret(Arrays.asList(ids));
    }

    public int ret(List<String> var1) throws OotpException;
}

