/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsMessageInfo;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.client.FileClient;
import org.opoo.ootp.client.MessageClient;
import org.opoo.ootp.client.OotpClient;
import org.opoo.ootp.client.OotpException;
import org.opoo.ootp.client.PollRequest;
import org.opoo.ootp.client.PollResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartMessageClient
implements MessageClient {
    private static final Logger log = LoggerFactory.getLogger(SmartMessageClient.class);
    public static final String META_FILE_REF = "file-ref";
    private final MessageClient messageClient;
    private final FileClient fileClient;

    public SmartMessageClient(MessageClient messageClient, FileClient fileClient) {
        this.messageClient = messageClient;
        this.fileClient = fileClient;
    }

    public SmartMessageClient(OotpClient ootpClient) {
        this.messageClient = ootpClient.getMessageClient();
        this.fileClient = ootpClient.getFileClient();
    }

    @Override
    public String send(ExsMessage message) throws OotpException {
        String fileId;
        ExsMetadata metadata = message.getMetadata();
        Long contentLength = metadata.getContentLength();
        String contentType = metadata.getContentType();
        String to = metadata.getTo();
        String type = metadata.getType();
        HashMap<String, String> userMetadata = new HashMap<String, String>(metadata.getUserMetadata());
        boolean isText = Optional.ofNullable(contentType).map(String::toLowerCase).filter(s -> s.startsWith("text/") || s.startsWith("application/") && s.contains("json")).isPresent();
        if (isText && (contentLength == null || contentLength <= 15000L)) {
            log.info("\u6587\u672c\u6d88\u606f\u5e76\u4e14\u6587\u4ef6\u5c0f\u4e8e 15000\uff0c\u53d1\u9001\u666e\u901a\u6d88\u606f\uff1a{}, {}", (Object)contentType, (Object)contentLength);
            return this.messageClient.send(message);
        }
        log.info("\u4e0d\u662f\u6587\u672c\u6d88\u606f\u6216\u8005\u6d88\u606f\u4f53\u8fc7\u5927\uff0c\u4f7f\u7528\u6587\u4ef6\u4f20\u8f93\uff1a{}, {}", (Object)contentType, (Object)contentLength);
        this.processFileName(message);
        try {
            fileId = this.fileClient.upload(message);
        }
        catch (IOException e) {
            throw new OotpException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", e);
        }
        String text = "file-ref:" + fileId;
        ExsMetadata exsMetadata = new ExsMetadata().withContentType("text/plain;charset=UTF-8").withContentLength(text.getBytes(StandardCharsets.UTF_8).length).withTo(to).withType(type);
        exsMetadata.setUserMetadata(userMetadata);
        exsMetadata.addUserMetadata(META_FILE_REF, fileId);
        exsMetadata.addUserMetadata("meta-codec-required", "false");
        return this.messageClient.send(text, exsMetadata);
    }

    void processFileName(ExsMessage message) {
        ExsMetadata metadata = message.getMetadata();
        if (metadata.getUserMetadata("file-name") == null) {
            metadata.addUserMetadata("file-name", "file-ref.bin").withLastModified(new Date());
        }
    }

    @Override
    public PollResult poll(PollRequest request) throws OotpException {
        return this.messageClient.poll(request);
    }

    @Override
    public ExsMessage getMessage(String id) throws OotpException {
        ExsMessage message = this.messageClient.getMessage(id);
        String fileRef = message.getMetadata().getUserMetadata(META_FILE_REF);
        if (fileRef == null) {
            return message;
        }
        try {
            ExsMessage file = this.fileClient.getFile(fileRef);
            file.getMetadata().setId(id);
            return file;
        }
        catch (IOException e) {
            throw new OotpException("\u4e0b\u8f7d\u6587\u4ef6\u51fa\u9519", e);
        }
    }

    @Override
    public ExsMessageInfo getMessageInfo(String id) throws OotpException {
        return this.messageClient.getMessageInfo(id);
    }

    @Override
    public int ack(List<String> ids) throws OotpException {
        return this.messageClient.ack(ids);
    }

    @Override
    public int ret(List<String> ids) throws OotpException {
        return this.messageClient.ret(ids);
    }
}

