/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.opoo.ootp.client.EntityBody;
import org.opoo.ootp.client.ExsBody;
import org.opoo.ootp.client.ExsCodec;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.client.MessageClient;
import org.opoo.ootp.client.OotpException;
import org.opoo.ootp.client.StringBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageClient
implements MessageClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractMessageClient.class);
    private static final String DEFAULT_BASE_PATH = "/exs-api";
    private final URI endpoint;
    protected final CloseableHttpClient httpClient;
    protected final ObjectMapper objectMapper;
    protected final String basePath;
    private ExsCodec codec;

    public AbstractMessageClient(URI endpoint, CloseableHttpClient httpClient, ObjectMapper objectMapper, String basePath) {
        this.endpoint = endpoint;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
        this.basePath = basePath != null ? basePath : DEFAULT_BASE_PATH;
    }

    public ExsCodec getCodec() {
        return this.codec;
    }

    public void setCodec(ExsCodec codec) {
        this.codec = codec;
    }

    protected void processUri(HttpUriRequest request) {
        try {
            URI uri = request.getURI();
            URI newUri = URIUtils.rewriteURI((URI)uri, (HttpHost)new HttpHost(this.endpoint.getHost(), this.endpoint.getPort(), this.endpoint.getScheme()));
            ((HttpRequestBase)request).setURI(newUri);
            log.debug("URI \u8865\u5168\u5230\uff1a{} -> {}", (Object)uri, (Object)newUri);
        }
        catch (URISyntaxException ex) {
            throw new OotpException("URI \u5904\u7406\u5931\u8d25", ex);
        }
    }

    protected static HttpEntity toEntity(ExsBody body, ExsMetadata metadata) throws IOException {
        if (body instanceof EntityBody) {
            return ((EntityBody)body).getEntity();
        }
        ContentType contentType = ContentType.parse((String)metadata.getContentType());
        if (body instanceof StringBody) {
            StringBody stringBody = (StringBody)body;
            ContentType contentType2 = Optional.ofNullable(stringBody.getCharset()).map(arg_0 -> ((ContentType)contentType).withCharset(arg_0)).orElse(contentType);
            return new StringEntity(stringBody.getString(), contentType2);
        }
        long contentLength = Optional.ofNullable(metadata.getContentLength()).filter(l -> l > 0L).orElse(-1L);
        return new InputStreamEntity(body.getContent(), contentLength, contentType);
    }

    protected HttpEntity codecEncode(HttpEntity entity, ExsMetadata metadata) throws IOException {
        if (this.codec == null) {
            log.debug("ExsCodec \u6ca1\u6709\u914d\u7f6e\uff0c\u6d88\u606f\u65e0\u9700\uff08\u65e0\u6cd5\uff09\u7f16\u7801/\u52a0\u5bc6");
            return entity;
        }
        return this.codec.encode(entity, metadata);
    }

    protected HttpEntity codecDecode(HttpEntity entity, ExsMetadata metadata) throws IOException {
        if (this.codec == null) {
            log.debug("ExsCodec \u6ca1\u6709\u914d\u7f6e\uff0c\u6d88\u606f\u65e0\u9700\uff08\u65e0\u6cd5\uff09\u89e3\u7801/\u89e3\u5bc6");
            return entity;
        }
        return this.codec.decode(entity, metadata);
    }
}

