/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import com.emc.codec.encryption.KeyProvider;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import org.opoo.ootp.client.KeyProviderManager;
import org.opoo.ootp.codec.encryption.KeyAndSpecProvider;
import org.opoo.ootp.codec.encryption.PrivateKeyProvider;

public class BasicKeyProviderManager
implements KeyProviderManager {
    private final Map<String, KeyAndSpecProvider> sm4KeyProviders = new HashMap<String, KeyAndSpecProvider>();
    private final Map<String, PublicKey> sm2PublicKeys = new HashMap<String, PublicKey>();
    private final Map<String, KeyProvider> rsaKeyProviders = new HashMap<String, KeyProvider>();
    private PrivateKeyProvider sm2PrivateKeyProvider;

    @Override
    public PrivateKeyProvider getSM2PrivateKeyProvider() {
        return this.sm2PrivateKeyProvider;
    }

    public void setSM2PrivateKeyProvider(PrivateKeyProvider sm2PrivateKeyProvider) {
        this.sm2PrivateKeyProvider = sm2PrivateKeyProvider;
    }

    @Override
    public KeyAndSpecProvider getSM4KeyProvider(String to) {
        return this.sm4KeyProviders.get(to);
    }

    @Override
    public PublicKey getSM2PublicKey(String to) {
        return this.sm2PublicKeys.get(to);
    }

    @Override
    public KeyProvider getRSAKeyProvider(String to) {
        return this.rsaKeyProviders.get(to);
    }

    public BasicKeyProviderManager addSM4KeyProvider(String to, KeyAndSpecProvider keyProvider) {
        this.sm4KeyProviders.put(to, keyProvider);
        return this;
    }

    public BasicKeyProviderManager addSM2PublicKey(String to, PublicKey publicKey) {
        this.sm2PublicKeys.put(to, publicKey);
        return this;
    }

    public BasicKeyProviderManager addRSAKeyProvider(String to, KeyProvider keyProvider) {
        this.rsaKeyProviders.put(to, keyProvider);
        return this;
    }
}

