/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import cn.hutool.core.io.IoUtil;
import com.emc.codec.encryption.EncryptionUtil;
import com.emc.codec.util.CodecUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.opoo.ootp.client.ExsCodec;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.client.KeyProviderManager;
import org.opoo.ootp.client.impl.FileCachedInputStream;
import org.opoo.ootp.codec.Codec;
import org.opoo.ootp.codec.CodecDecoder;
import org.opoo.ootp.codec.CodecEncoder;
import org.opoo.ootp.codec.binary.BinaryEncodeConstants;
import org.opoo.ootp.codec.encryption.EncryptionException;
import org.opoo.ootp.codec.encryption.EncryptionUtils;
import org.opoo.ootp.codec.encryption.sm4.SM4EncryptionConstants;
import org.opoo.ootp.codec.encryption.smx.SMXEncryptionConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExsCodecImpl
implements ExsCodec {
    private static final Logger log = LoggerFactory.getLogger(ExsCodecImpl.class);
    public static final long DEFAULT_DISK_CACHE_SIZE_THRESHOLD = 0x100000L;
    private final CodecEncoder encoder;
    private final CodecDecoder decoder;
    private final KeyProviderManager keyProviderManager;
    private final ExsCodec.CodecMode mode;
    private long diskCacheSizeThreshold = 0x100000L;

    public ExsCodecImpl(KeyProviderManager keyProviderManager, ExsCodec.CodecMode mode, String ... encodeSpecs) {
        this.keyProviderManager = keyProviderManager;
        this.encoder = new CodecEncoder(encodeSpecs);
        this.decoder = (CodecDecoder)new CodecDecoder().withProperty("org.opoo.ootp.codec.encryption.smx.SMXEncryptionCodec.privateKeyProvider", (Object)keyProviderManager.getSM2PrivateKeyProvider());
        this.mode = mode;
    }

    public CodecEncoder getEncoder() {
        return this.encoder;
    }

    public CodecDecoder getDecoder() {
        return this.decoder;
    }

    public KeyProviderManager getKeyProviderManager() {
        return this.keyProviderManager;
    }

    public ExsCodec.CodecMode getMode() {
        return this.mode;
    }

    public long getDiskCacheSizeThreshold() {
        return this.diskCacheSizeThreshold;
    }

    public void setDiskCacheSizeThreshold(long diskCacheSizeThreshold) {
        this.diskCacheSizeThreshold = diskCacheSizeThreshold;
    }

    protected Map<String, Object> buildEncodeContext(ExsMetadata metadata) {
        String to = metadata.getTo();
        HashMap<String, Object> context = new HashMap<String, Object>();
        Optional.ofNullable(this.keyProviderManager.getSM4KeyProvider(to)).ifPresent(o -> context.put("org.opoo.ootp.codec.encryption.sm4.SM4EncryptionCodec.keyProvider", o));
        Optional.ofNullable(this.keyProviderManager.getSM2PublicKey(to)).ifPresent(o -> context.put("org.opoo.ootp.codec.encryption.smx.SMXEncryptionCodec.publicKey", o));
        Optional.ofNullable(this.keyProviderManager.getRSAKeyProvider(to)).ifPresent(o -> context.put("com.emc.codec.encryption.EncryptionCodec.keyProvider", o));
        return context;
    }

    protected MessageDigest getSM3Digest() {
        try {
            return MessageDigest.getInstance("SM3", EncryptionUtils.SECURITY_PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("\u83b7\u53d6\u54c8\u5e0c\u7b97\u6cd5\u5931\u8d25", (Throwable)e);
        }
    }

    protected Path createTempFile(ExsMetadata metadata) throws IOException {
        Long contentLength = metadata.getContentLength();
        if (contentLength != null && contentLength > this.diskCacheSizeThreshold) {
            String fileName = Optional.ofNullable(metadata.getUserMetadata("file-name")).orElse("entity.bin");
            Path tempFile = Files.createTempFile("ootp", fileName, new FileAttribute[0]);
            log.debug("Codec \u5185\u5bb9\u8f83\u5927\uff1a{}, \u521b\u5efa\u6587\u4ef6\u7f13\u5b58\uff1a{}", (Object)contentLength, (Object)tempFile);
            return tempFile;
        }
        return null;
    }

    private boolean isRequired(ExsMetadata metadata) {
        if (ExsCodec.CodecMode.NONE == this.mode) {
            log.debug("\u5904\u7406\u6a21\u5f0f\u4e3a NONE\uff0c\u4e0d\u5fc5\u8fdb\u884c Codec \u5904\u7406");
            return false;
        }
        String required = metadata.getUserMetadata("meta-codec-required");
        if (Boolean.FALSE.toString().equalsIgnoreCase(required)) {
            log.debug("\u5f53\u524d\u6d88\u606f\u5143\u6570\u636e\u660e\u786e\u6307\u51fa\u4e0d\u5fc5\u5904\u7406\uff0c\u4e0d\u5fc5\u8fdb\u884c Codec \u5904\u7406");
            return false;
        }
        if (ExsCodec.CodecMode.BY_REQUIRED == this.mode && Boolean.TRUE.toString().equalsIgnoreCase(required)) {
            log.debug("\u5904\u7406\u6a21\u5f0f\u4e3a BY_REQUIRED\uff0c\u5e76\u4e14 meta \u6570\u636e REQUIRED \u4e3a true\uff0c\u9700\u8981\u8fdb\u884c Codec \u5904\u7406");
            return true;
        }
        if (ExsCodec.CodecMode.ALL == this.mode) {
            log.debug("\u5904\u7406\u6a21\u5f0f\u4e3a ALL\uff0c\u9664\u4e86\u660e\u786e\u4e0d\u5904\u7406\u7684\u6d88\u606f\u5916\uff0c\u90fd\u8981\u8fdb\u884c Codec \u5904\u7406");
            return true;
        }
        return false;
    }

    @Override
    public HttpEntity encode(HttpEntity entity, ExsMetadata metadata) throws IOException {
        Object digester;
        if (!this.isRequired(metadata)) {
            return entity;
        }
        MessageDigest sm3 = this.getSM3Digest();
        Map<String, Object> context = this.buildEncodeContext(metadata);
        Path tempFile = this.createTempFile(metadata);
        byte[] bytes = null;
        try (InputStream encodeStream = this.encoder.getEncodeStream(entity.getContent(), metadata.getUserMetadata(), context);){
            digester = new DigestInputStream(encodeStream, sm3);
            Throwable throwable = null;
            try {
                if (tempFile != null) {
                    Files.copy((InputStream)digester, tempFile, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    bytes = IoUtil.readBytes((InputStream)digester, (boolean)false);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (digester != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)digester).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)digester).close();
                    }
                }
            }
        }
        catch (com.emc.codec.encryption.EncryptionException | EncryptionException e) {
            log.error("\u7f16\u7801/\u52a0\u5bc6\u51fa\u9519\uff0c\u76ee\u6807\u63a5\u5165\u65b9\uff1a{}\uff0c\u539f\u56e0\uff1a{}", new Object[]{metadata.getTo(), e.getMessage(), e});
            throw e;
        }
        catch (UnsupportedOperationException ex) {
            log.debug("ExsBody \u4e0d\u652f\u6301 InputStream \u6a21\u5f0f\uff0c\u8f6c\u4e3a OutputStream \u6a21\u5f0f\uff1a{}", (Object)metadata);
            try {
                OutputStream outputStream = tempFile != null ? Files.newOutputStream(tempFile, new OpenOption[0]) : new ByteArrayOutputStream();
                digester = null;
                try (DigestOutputStream digester2 = new DigestOutputStream(outputStream, sm3);
                     OutputStream encodeStream2 = this.encoder.getEncodeStream((OutputStream)digester2, metadata.getUserMetadata(), context);){
                    entity.writeTo(encodeStream2);
                    if (outputStream instanceof ByteArrayOutputStream) {
                        bytes = ((ByteArrayOutputStream)outputStream).toByteArray();
                    }
                }
                catch (Throwable throwable) {
                    digester = throwable;
                    throw throwable;
                }
                finally {
                    if (outputStream != null) {
                        if (digester != null) {
                            try {
                                outputStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)digester).addSuppressed(throwable);
                            }
                        } else {
                            outputStream.close();
                        }
                    }
                }
            }
            catch (com.emc.codec.encryption.EncryptionException | EncryptionException e) {
                log.error("\u7f16\u7801/\u52a0\u5bc6\u51fa\u9519\uff0c\u76ee\u6807\u63a5\u5165\u65b9\uff1a{}\uff0c\u539f\u56e0\uff1a{}", new Object[]{metadata.getTo(), e.getMessage(), e});
                throw e;
            }
        }
        metadata.setContentHash(EncryptionUtil.toHexPadded((byte[])sm3.digest()));
        if (tempFile != null) {
            long size = Files.size(tempFile);
            log.debug("\u7f16\u7801/\u52a0\u5bc6\u540e\u4f7f\u7528\u6587\u4ef6\u8868\u793a\uff1a{} - {}", (Object)tempFile, (Object)size);
            metadata.setContentLength(size);
            FileCachedInputStream inputStream = new FileCachedInputStream(tempFile);
            return new InputStreamEntity((InputStream)inputStream, size, ContentType.get((HttpEntity)entity));
        }
        log.debug("\u7f16\u7801/\u52a0\u5bc6\u540e\u4f7f\u7528 byte[] \u8868\u793a\uff1a{}", (Object)bytes.length);
        metadata.setContentLength(Long.valueOf(bytes.length));
        return new ByteArrayEntity(bytes, ContentType.get((HttpEntity)entity));
    }

    @Override
    public InputStream encode(InputStream inputStream, ExsMetadata metadata) throws IOException {
        if (!this.isRequired(metadata)) {
            return inputStream;
        }
        MessageDigest sm3 = this.getSM3Digest();
        Map<String, Object> context = this.buildEncodeContext(metadata);
        Path tempFile = this.createTempFile(metadata);
        byte[] bytes = null;
        try (InputStream encodeStream = this.encoder.getEncodeStream(inputStream, metadata.getUserMetadata(), context);
             DigestInputStream digester = new DigestInputStream(encodeStream, sm3);){
            if (tempFile != null) {
                Files.copy(digester, tempFile, StandardCopyOption.REPLACE_EXISTING);
            } else {
                bytes = IoUtil.readBytes((InputStream)digester, (boolean)false);
            }
        }
        catch (com.emc.codec.encryption.EncryptionException | EncryptionException e) {
            log.error("\u7f16\u7801/\u52a0\u5bc6\u51fa\u9519\uff0c\u76ee\u6807\u63a5\u5165\u65b9\uff1a{}\uff0c\u539f\u56e0\uff1a{}", new Object[]{metadata.getTo(), e.getMessage(), e});
            throw e;
        }
        metadata.setContentHash(EncryptionUtil.toHexPadded((byte[])sm3.digest()));
        if (tempFile != null) {
            long size = Files.size(tempFile);
            log.debug("\u7f16\u7801/\u52a0\u5bc6\u540e\u4f7f\u7528\u6587\u4ef6\u8868\u793a\uff1a{} - {}", (Object)tempFile, (Object)size);
            metadata.setContentLength(size);
            return new FileCachedInputStream(tempFile);
        }
        log.debug("\u7f16\u7801/\u52a0\u5bc6\u540e\u4f7f\u7528 byte[] \u8868\u793a\uff1a{}", (Object)bytes.length);
        metadata.setContentLength(Long.valueOf(bytes.length));
        return new ByteArrayInputStream(bytes);
    }

    protected Map<String, Object> buildDecodeContext(ExsMetadata metadata) {
        String from = metadata.getFrom();
        HashMap<String, Object> context = new HashMap<String, Object>();
        Optional.ofNullable(this.keyProviderManager.getSM4KeyProvider(from)).ifPresent(o -> context.put("org.opoo.ootp.codec.encryption.sm4.SM4EncryptionCodec.keyProvider", o));
        Optional.ofNullable(this.keyProviderManager.getRSAKeyProvider(from)).ifPresent(o -> context.put("com.emc.codec.encryption.EncryptionCodec.keyProvider", o));
        return context;
    }

    protected String getUnencodeSize(String transformMode, ExsMetadata metadata) {
        String encodeType = CodecUtil.getEncodeType((String)transformMode);
        log.debug("\u7b2c\u4e00\u4e2a Codec \u7684\u7c7b\u578b\uff1a{}", (Object)encodeType);
        switch (encodeType) {
            case "SMX": {
                return metadata.getUserMetadata(SMXEncryptionConstants.META_ENCRYPTION_UNENC_SIZE);
            }
            case "SM4": {
                return metadata.getUserMetadata(SM4EncryptionConstants.META_ENCRYPTION_UNENC_SIZE);
            }
            case "BIN": {
                return metadata.getUserMetadata(BinaryEncodeConstants.META_BIN_UNENCODED_SIZE);
            }
            case "ENC": {
                return metadata.getUserMetadata("x-emc-enc-unencrypted-size");
            }
            case "COMP": {
                return metadata.getUserMetadata("x-emc-comp-uncompressed-size");
            }
        }
        return null;
    }

    @Override
    public HttpEntity decode(HttpEntity entity, ExsMetadata metadata) throws IOException {
        String transformMode = metadata.getUserMetadata(Codec.META_TRANSFORM_MODE);
        if (transformMode == null || "".equals(transformMode.trim())) {
            log.debug("{} \u4e3a\u7a7a\uff0c\u4e0d\u5fc5\u89e3\u5bc6\u6216\u8005\u89e3\u7801", (Object)Codec.META_TRANSFORM_MODE);
            return entity;
        }
        Map<String, Object> context = this.buildDecodeContext(metadata);
        try {
            Optional.ofNullable(this.getUnencodeSize(transformMode, metadata)).ifPresent(size -> metadata.setContentLength(Long.parseLong(size)));
            InputStream decodeStream = this.decoder.getDecodeStream(entity.getContent(), metadata.getUserMetadata(), context);
            return new InputStreamEntity(decodeStream, ContentType.get((HttpEntity)entity));
        }
        catch (com.emc.codec.encryption.EncryptionException | EncryptionException e) {
            log.error("\u89e3\u7801/\u89e3\u5bc6\u51fa\u9519\uff0c\u76ee\u6807\u63a5\u5165\u65b9\uff1a{}\uff0c\u539f\u56e0\uff1a{}", new Object[]{metadata.getFrom(), e.getMessage(), e});
            throw e;
        }
        catch (UnsupportedOperationException ex) {
            log.debug("ExsBody \u4e0d\u652f\u6301 InputStream \u6a21\u5f0f\uff0c\u8f6c\u4e3a OutputStream \u6a21\u5f0f\uff1a{}", (Object)metadata);
            Path tempFile = this.createTempFile(metadata);
            byte[] bytes = null;
            try (OutputStream outputStream = tempFile != null ? Files.newOutputStream(tempFile, new OpenOption[0]) : new ByteArrayOutputStream();
                 OutputStream decodeStream = this.decoder.getDecodeStream(outputStream, metadata.getUserMetadata(), context);){
                entity.writeTo(decodeStream);
                if (outputStream instanceof ByteArrayOutputStream) {
                    bytes = ((ByteArrayOutputStream)outputStream).toByteArray();
                }
            }
            catch (com.emc.codec.encryption.EncryptionException | EncryptionException e) {
                log.error("\u89e3\u7801/\u89e3\u5bc6\u51fa\u9519\uff0c\u76ee\u6807\u63a5\u5165\u65b9\uff1a{}\uff0c\u539f\u56e0\uff1a{}", new Object[]{metadata.getFrom(), e.getMessage(), e});
                throw e;
            }
            if (tempFile != null) {
                FileCachedInputStream inputStream = new FileCachedInputStream(tempFile);
                metadata.setContentLength(Files.size(tempFile));
                return new InputStreamEntity((InputStream)inputStream, Files.size(tempFile), ContentType.get((HttpEntity)entity));
            }
            metadata.setContentLength(Long.valueOf(bytes.length));
            return new ByteArrayEntity(bytes, ContentType.get((HttpEntity)entity));
        }
    }

    @Override
    public InputStream decode(InputStream inputStream, ExsMetadata metadata) throws IOException {
        String transformMode = metadata.getUserMetadata(Codec.META_TRANSFORM_MODE);
        if (transformMode == null || "".equals(transformMode.trim())) {
            log.debug("{} \u4e3a\u7a7a\uff0c\u4e0d\u5fc5\u89e3\u5bc6\u6216\u8005\u89e3\u7801", (Object)Codec.META_TRANSFORM_MODE);
            return inputStream;
        }
        Optional.ofNullable(this.getUnencodeSize(transformMode, metadata)).ifPresent(size -> metadata.setContentLength(Long.parseLong(size)));
        Map<String, Object> context = this.buildDecodeContext(metadata);
        return this.decoder.getDecodeStream(inputStream, metadata.getUserMetadata(), context);
    }

    @Override
    public OutputStream decode(OutputStream outputStream, ExsMetadata metadata) throws IOException {
        String transformMode = metadata.getUserMetadata(Codec.META_TRANSFORM_MODE);
        if (transformMode == null || "".equals(transformMode.trim())) {
            log.debug("{} \u4e3a\u7a7a\uff0c\u4e0d\u5fc5\u89e3\u5bc6\u6216\u8005\u89e3\u7801", (Object)Codec.META_TRANSFORM_MODE);
            return outputStream;
        }
        Optional.ofNullable(this.getUnencodeSize(transformMode, metadata)).ifPresent(size -> metadata.setContentLength(Long.parseLong(size)));
        Map<String, Object> context = this.buildDecodeContext(metadata);
        return this.decoder.getDecodeStream(outputStream, metadata.getUserMetadata(), context);
    }
}

