/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileCachedInputStream
extends FilterInputStream {
    private static final Logger log = LoggerFactory.getLogger(FileCachedInputStream.class);
    private final Path file;

    private FileCachedInputStream(InputStream in, Path file) {
        super(in);
        this.file = file;
    }

    FileCachedInputStream(Path file) throws IOException {
        super(Files.newInputStream(file, new OpenOption[0]));
        this.file = file;
    }

    @Override
    public void close() throws IOException {
        super.close();
        boolean result = Files.deleteIfExists(this.file);
        log.debug("\u5173\u95ed\u65f6\u5220\u9664\u4e34\u65f6\u6587\u4ef6\uff1a{} - {}", (Object)this.file, (Object)result);
    }

    public Path getFile() {
        return this.file;
    }

    static FileCachedInputStream create(InputStream originalInputStream) throws IOException {
        return FileCachedInputStream.create(originalInputStream, "tmp.bin");
    }

    static FileCachedInputStream create(InputStream originalInputStream, String fileId) throws IOException {
        Path path = Files.createTempFile("ootp", fileId, new FileAttribute[0]);
        log.debug("\u590d\u5236\u5230\u4e34\u65f6\u6587\u4ef6\uff1a{}", (Object)path);
        try (InputStream inputStream = originalInputStream;){
            Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
        }
        return new FileCachedInputStream(Files.newInputStream(path, new OpenOption[0]), path);
    }
}

