/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.opoo.ootp.client.EntityBody;
import org.opoo.ootp.client.ExsBody;
import org.opoo.ootp.client.ExsCodec;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.client.FileClient;
import org.opoo.ootp.client.OotpException;
import org.opoo.ootp.client.impl.AbstractMessageClient;
import org.opoo.ootp.client.impl.FileCachedInputStream;

public class FileClientImpl
implements FileClient {
    public static final String FILE_ID_FIELD = "fileId";
    private final URI endpoint;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper objectMapper;
    private ExsCodec codec;

    public FileClientImpl(URI endpoint, CloseableHttpClient httpClient, ObjectMapper objectMapper) {
        this.endpoint = endpoint;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    public ExsCodec getCodec() {
        return this.codec;
    }

    public void setCodec(ExsCodec codec) {
        this.codec = codec;
    }

    @Override
    public String upload(ExsMessage message, String storage, String pathInfo) throws IOException, OotpException {
        ExsBody body = message.getBody();
        ExsMetadata metadata = message.getMetadata();
        Objects.requireNonNull(storage, "storage is required.");
        Objects.requireNonNull(metadata, "metadata is required.");
        Objects.requireNonNull(metadata.getContentType(), "contentType is required.");
        Objects.requireNonNull(body, "file is required.");
        Objects.requireNonNull(metadata.getUserMetadata("file-name"), "fileName is required.");
        if ("fs".equals(storage)) {
            Objects.requireNonNull(metadata.getTo(), "repo is required.");
        } else if ("default".equals(storage)) {
            Objects.requireNonNull(metadata.getTo(), "to is required.");
        }
        String path = this.endpoint.toString() + "/file-api/upload";
        if (pathInfo != null) {
            path = path + pathInfo;
        }
        path = path + "?storage=" + storage;
        HttpEntity entity2 = AbstractMessageClient.toEntity(body, metadata);
        HttpEntity entity = this.codec != null ? this.codec.encode(entity2, metadata) : entity2;
        HttpPut httpPut = new HttpPut(path);
        httpPut.setEntity(entity);
        metadata.toHeaders((arg_0, arg_1) -> ((HttpPut)httpPut).setHeader(arg_0, arg_1));
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPut);){
            Map map;
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            try (InputStream inputStream = response.getEntity().getContent();){
                map = (Map)this.objectMapper.readValue(inputStream, Map.class);
            }
            if (statusCode < 200 || statusCode >= 300) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                throw new OotpException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + statusCode, statusCode, statusLine.getReasonPhrase());
            }
            String string = Optional.ofNullable(map).map(m -> (String)m.get(FILE_ID_FIELD)).orElseThrow(() -> new OotpException("\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a", 500, "ResponseEmptyBody"));
            return string;
        }
    }

    @Override
    public ExsMessage getFile(String fileId) throws IOException {
        Objects.requireNonNull(fileId, "fileId is required.");
        HttpGet httpGet = new HttpGet(this.endpoint.toString() + "/file-api/file/" + fileId);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                throw new OotpException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a" + statusCode, statusCode, statusLine.getReasonPhrase());
            }
            HttpEntity entity = response.getEntity();
            ContentType contentType = ContentType.get((HttpEntity)entity);
            HashMap<String, String> headers = new HashMap<String, String>();
            Arrays.stream(response.getAllHeaders()).forEach(h -> headers.putIfAbsent(h.getName().toLowerCase(), h.getValue()));
            ExsMetadata metadata = ExsMetadata.fromHeaders(headers);
            metadata.setId(fileId);
            InputStream content = entity.getContent();
            InputStream decodeStream = this.codec != null ? this.codec.decode(content, metadata) : content;
            FileCachedInputStream ootpFileCachedInputStream = FileCachedInputStream.create(decodeStream, fileId);
            long size = Files.size(ootpFileCachedInputStream.getFile());
            InputStreamEntity inputStreamEntity = new InputStreamEntity((InputStream)ootpFileCachedInputStream, size, contentType);
            EntityBody entityBody = new EntityBody((HttpEntity)inputStreamEntity);
            ExsMessage exsMessage = new ExsMessage(entityBody, metadata);
            return exsMessage;
        }
    }
}

