/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.VersionInfo;
import org.opoo.ootp.client.ExsCodec;
import org.opoo.ootp.client.FileClient;
import org.opoo.ootp.client.MessageClient;
import org.opoo.ootp.client.OotpClient;
import org.opoo.ootp.client.impl.AbstractMessageClient;
import org.opoo.ootp.client.impl.FileClientImpl;
import org.opoo.ootp.client.impl.V1MessageClientImpl;
import org.opoo.ootp.client.impl.V2MessageClientImpl;
import org.opoo.ootp.signer.Signer;
import org.opoo.ootp.signer.httpclient.SignerHttpRequestInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OotpClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(OotpClientBuilder.class);
    public static final String HTTP_VERSION = VersionInfo.getUserAgent((String)"Apache-HttpClient", (String)"org.apache.http.client", HttpClientBuilder.class);
    public static final String PACKAGE_VERSION = OotpClientBuilder.class.getPackage().getImplementationVersion();
    public static final String DEFAULT_USER_AGENT = String.format("Ootp Java Client%s %s (%s; %s; %s)", PACKAGE_VERSION != null ? " v" + PACKAGE_VERSION : "", HTTP_VERSION, System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
    private URI endpoint;
    private Signer signer;
    private HttpClientBuilder httpClientBuilder;
    private CloseableHttpClient httpClient;
    private ObjectMapper objectMapper;
    private boolean version1 = false;
    private String basePath;
    private ExsCodec messageCodec;
    private ExsCodec fileCodec;

    private OotpClientBuilder() {
    }

    public static OotpClient defaultClient(URI endpoint, Signer signer) {
        return new OotpClientBuilder().endpoint(endpoint).signer(signer).build();
    }

    public static OotpClient defaultClient(String endpoint, Signer signer) {
        return OotpClientBuilder.defaultClient(URI.create(endpoint), signer);
    }

    public static OotpClientBuilder custom() {
        return new OotpClientBuilder();
    }

    public OotpClientBuilder signer(Signer signer) {
        this.signer = signer;
        return this;
    }

    public OotpClientBuilder endpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public OotpClientBuilder endpoint(String endpoint) {
        this.endpoint = URI.create(endpoint);
        return this;
    }

    public OotpClientBuilder basePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public OotpClientBuilder objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public OotpClientBuilder httpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
        return this;
    }

    public OotpClientBuilder useVersion1() {
        this.version1 = true;
        return this;
    }

    public OotpClientBuilder messageCodec(ExsCodec codec) {
        this.messageCodec = codec;
        return this;
    }

    public OotpClientBuilder fileCodec(ExsCodec codec) {
        this.fileCodec = codec;
        return this;
    }

    public OotpClientBuilder httpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public OotpClient build() {
        Objects.requireNonNull(this.endpoint, "\u5fc5\u987b\u8bbe\u7f6e endpoint");
        CloseableHttpClient httpClient = Optional.ofNullable(this.httpClient).orElseGet(() -> OotpClientBuilder.buildDefaultOotpHttpClient(this.signer, this.httpClientBuilder));
        ObjectMapper objectMapper = Optional.ofNullable(this.objectMapper).orElseGet(() -> new ObjectMapper().disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS));
        AbstractMessageClient messageClient = this.version1 ? new V1MessageClientImpl(this.endpoint, httpClient, objectMapper, this.basePath) : new V2MessageClientImpl(this.endpoint, httpClient, objectMapper, this.basePath);
        FileClientImpl fileClient = new FileClientImpl(this.endpoint, httpClient, objectMapper);
        Optional.ofNullable(this.messageCodec).ifPresent(messageClient::setCodec);
        Optional.ofNullable(this.fileCodec).ifPresent(fileClient::setCodec);
        return new OotpClientImpl(messageClient, fileClient, httpClient == this.httpClient ? null : httpClient);
    }

    public static CloseableHttpClient buildDefaultOotpHttpClient(Signer signer) {
        return OotpClientBuilder.buildDefaultOotpHttpClient(signer, null);
    }

    public static CloseableHttpClient buildDefaultOotpHttpClient(Signer signer, HttpClientBuilder httpClientBuilder) {
        Objects.requireNonNull(signer, "signer \u4e0d\u80fd\u4e3a\u7a7a");
        HttpClientBuilder newHttpClientBuilder = Optional.ofNullable(httpClientBuilder).orElseGet(() -> HttpClients.custom().disableAuthCaching().disableCookieManagement().disableRedirectHandling().disableAutomaticRetries().setMaxConnPerRoute(20).setMaxConnTotal(20));
        newHttpClientBuilder.setUserAgent(DEFAULT_USER_AGENT);
        return newHttpClientBuilder.addInterceptorFirst((HttpRequestInterceptor)new SignerHttpRequestInterceptor(signer)).build();
    }

    public static class OotpClientImpl
    implements OotpClient,
    AutoCloseable {
        private final MessageClient messageClient;
        private final FileClient fileClient;
        private final CloseableHttpClient httpClient;

        @Override
        public void close() throws Exception {
            if (this.httpClient != null) {
                log.info("\u5173\u95ed HttpClient");
                try {
                    this.httpClient.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public MessageClient getMessageClient() {
            return this.messageClient;
        }

        @Override
        public FileClient getFileClient() {
            return this.fileClient;
        }

        public CloseableHttpClient getHttpClient() {
            return this.httpClient;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OotpClientImpl)) {
                return false;
            }
            OotpClientImpl other = (OotpClientImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MessageClient this$messageClient = this.getMessageClient();
            MessageClient other$messageClient = other.getMessageClient();
            if (this$messageClient == null ? other$messageClient != null : !this$messageClient.equals(other$messageClient)) {
                return false;
            }
            FileClient this$fileClient = this.getFileClient();
            FileClient other$fileClient = other.getFileClient();
            if (this$fileClient == null ? other$fileClient != null : !this$fileClient.equals(other$fileClient)) {
                return false;
            }
            CloseableHttpClient this$httpClient = this.getHttpClient();
            CloseableHttpClient other$httpClient = other.getHttpClient();
            return !(this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OotpClientImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MessageClient $messageClient = this.getMessageClient();
            result = result * 59 + ($messageClient == null ? 43 : $messageClient.hashCode());
            FileClient $fileClient = this.getFileClient();
            result = result * 59 + ($fileClient == null ? 43 : $fileClient.hashCode());
            CloseableHttpClient $httpClient = this.getHttpClient();
            result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
            return result;
        }

        public String toString() {
            return "OotpClientBuilder.OotpClientImpl(messageClient=" + this.getMessageClient() + ", fileClient=" + this.getFileClient() + ", httpClient=" + this.getHttpClient() + ")";
        }

        public OotpClientImpl(MessageClient messageClient, FileClient fileClient, CloseableHttpClient httpClient) {
            this.messageClient = messageClient;
            this.fileClient = fileClient;
            this.httpClient = httpClient;
        }
    }
}

