/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.opoo.ootp.client.EntityBody;
import org.opoo.ootp.client.ExsBody;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsMessageInfo;
import org.opoo.ootp.client.ExsMessageLite;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.client.MessageClient;
import org.opoo.ootp.client.OotpException;
import org.opoo.ootp.client.PollRequest;
import org.opoo.ootp.client.PollResult;
import org.opoo.ootp.client.impl.AbstractMessageClient;
import org.opoo.ootp.codec.Codec;
import org.opoo.ootp.signer.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V2MessageClientImpl
extends AbstractMessageClient
implements MessageClient {
    private static final Logger log = LoggerFactory.getLogger(V2MessageClientImpl.class);

    public V2MessageClientImpl(URI endpoint, CloseableHttpClient httpClient, ObjectMapper objectMapper) {
        this(endpoint, httpClient, objectMapper, null);
    }

    public V2MessageClientImpl(URI endpoint, CloseableHttpClient httpClient, ObjectMapper objectMapper, String basePath) {
        super(endpoint, httpClient, objectMapper, basePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T exec(HttpUriRequest request, Handler<T> handler) {
        this.processUri(request);
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            int statusCode = statusLine.getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                try {
                    InputStream inputStream = entity.getContent();
                    Throwable throwable = null;
                    try {
                        try {
                            Map map = (Map)this.objectMapper.readValue(inputStream, Map.class);
                            String error = (String)map.get("error");
                            String message = (String)map.get("message");
                            throw new OotpException(message, statusCode, error);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (inputStream == null) throw throwable3;
                        if (throwable == null) {
                            inputStream.close();
                            throw throwable3;
                        }
                        try {
                            inputStream.close();
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                            throw throwable3;
                        }
                    }
                }
                catch (Exception exception) {
                    throw new OotpException("\u6d88\u606fAPI\u8c03\u7528\u5931\u8d25\uff1a" + statusCode, statusCode, statusLine.getReasonPhrase());
                }
            }
            T t = handler.apply(response, entity);
            return t;
        }
        catch (IOException ex) {
            throw new OotpException("\u6d88\u606fAPI\u8c03\u7528\u5931\u8d25\uff1a" + ex.getMessage(), ex);
        }
    }

    @Override
    public String send(ExsMessage message) throws OotpException {
        ExsMetadata metadata = Objects.requireNonNull(message.getMetadata(), "metadata is required.");
        Objects.requireNonNull(metadata.getType(), "type is required.");
        Objects.requireNonNull(metadata.getTo(), "to is required.");
        Objects.requireNonNull(metadata.getContentType(), "contentType is required.");
        ExsBody body = message.getBody();
        Objects.requireNonNull(body, "body is required.");
        HttpPut request = new HttpPut(this.basePath + "/api/messages/v2");
        try {
            HttpEntity entity2 = V2MessageClientImpl.toEntity(body, metadata);
            request.setEntity(this.codecEncode(entity2, metadata));
        }
        catch (IOException e) {
            throw new OotpException("\u5904\u7406\u8bf7\u6c42\u8f93\u5165\u65f6\u51fa\u9519", e);
        }
        metadata.toHeaders((arg_0, arg_1) -> ((HttpPut)request).setHeader(arg_0, arg_1));
        return this.exec((HttpUriRequest)request, (response, entity) -> {
            try (InputStream inputStream = entity.getContent();){
                Map map = (Map)this.objectMapper.readValue(inputStream, Map.class);
                String string = (String)map.get("id");
                return string;
            }
        });
    }

    @Override
    public PollResult poll(PollRequest request) throws OotpException {
        byte[] bytes;
        int limit = request.getLimit();
        if (limit <= 0 || limit > 100) {
            log.warn("\u4fee\u6539 poll \u8bf7\u6c42\u7684\u6d88\u606f\u6570\u91cf\uff1a{} -> {}", (Object)limit, (Object)100);
            request.setLimit(100);
        }
        try {
            bytes = this.objectMapper.writeValueAsBytes((Object)request);
        }
        catch (JsonProcessingException e) {
            throw new OotpException("\u5e8f\u5217\u5316\u8f6e\u8be2\u8bf7\u6c42\u51fa\u9519", e);
        }
        HttpPost httpPost = new HttpPost(this.basePath + "/api/messages/v2");
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(bytes, ContentType.APPLICATION_JSON));
        Optional.ofNullable(request.getClientId()).ifPresent(s -> httpPost.setHeader(Signer.HEADER_NAME_PREFIX + "client-id", s));
        return this.exec((HttpUriRequest)httpPost, (response, entity) -> {
            MessageV2[] arr;
            PollResult pollResult = new PollResult();
            try (InputStream inputStream = entity.getContent();){
                arr = (MessageV2[])this.objectMapper.readValue(inputStream, MessageV2[].class);
            }
            if (arr != null) {
                List<ExsMessageLite> messages = Arrays.stream(arr).map(m -> {
                    ExsMessageLite lite = new ExsMessageLite();
                    lite.setBody(m.getBody());
                    ExsMetadata meta = new ExsMetadata();
                    meta.setId(m.getId());
                    meta.setFrom(m.getFrom());
                    meta.setType(m.getType());
                    meta.setContentType(m.getContentType());
                    lite.setMetadata(meta);
                    return lite;
                }).collect(Collectors.toList());
                pollResult.setMessages(messages);
            }
            Optional.ofNullable(response.getFirstHeader(Signer.HEADER_NAME_PREFIX + "exs-latest-id")).ifPresent(h -> pollResult.setLatestId(h.getValue()));
            return pollResult;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExsMessage getMessage(String id) throws OotpException {
        Objects.requireNonNull(id, "id is required.");
        HttpGet httpGet = new HttpGet(this.basePath + "/api/messages/v2?id=" + id);
        this.processUri((HttpUriRequest)httpGet);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            ContentType contentType = ContentType.get((HttpEntity)entity);
            int statusCode = statusLine.getStatusCode();
            HashMap<String, String> headers = new HashMap<String, String>();
            Arrays.stream(response.getAllHeaders()).forEach(h -> headers.putIfAbsent(h.getName().toLowerCase(), h.getValue()));
            ExsMetadata metadata = ExsMetadata.fromHeaders(headers);
            HttpEntity decodedEntity = this.codecDecode(entity, metadata);
            if (statusCode < 200 || statusCode >= 300) {
                String str;
                if (contentType != null && (str = contentType.toString().toLowerCase()).startsWith("application/") && str.contains("json") && metadata.getUserMetadata(Codec.META_TRANSFORM_MODE) == null) {
                    byte[] bytes = EntityUtils.toByteArray((HttpEntity)decodedEntity);
                    Map map = (Map)this.objectMapper.readValue(bytes, Map.class);
                    String error = (String)map.get("error");
                    String message = (String)map.get("message");
                    if (error != null || message != null) {
                        String string;
                        if (error != null) {
                            string = error;
                            throw new OotpException(message, statusCode, string);
                        }
                        string = statusLine.getReasonPhrase();
                        throw new OotpException(message, statusCode, string);
                    }
                }
                if (statusCode != 404) throw new OotpException("\u83b7\u53d6\u6d88\u606f\u5931\u8d25\uff1a" + id, statusCode, statusLine.getReasonPhrase());
                throw new OotpException("\u627e\u4e0d\u5230\u6d88\u606f\uff1a" + id, statusCode, "MessageNotFound");
            }
            BufferedHttpEntity httpEntity = new BufferedHttpEntity(decodedEntity);
            ExsMessage exsMessage = new ExsMessage(new EntityBody((HttpEntity)httpEntity), metadata);
            return exsMessage;
        }
        catch (IOException ex) {
            throw new OotpException("\u83b7\u53d6\u6d88\u606f\u5931\u8d25", ex);
        }
    }

    @Override
    public ExsMessageInfo getMessageInfo(String id) throws OotpException {
        Objects.requireNonNull(id, "id is required.");
        HttpGet httpGet = new HttpGet(this.basePath + "/api/messages/info/v2?id=" + id);
        return this.exec((HttpUriRequest)httpGet, (response, entity) -> {
            try (InputStream inputStream = entity.getContent();){
                ExsMessageInfo exsMessageInfo = (ExsMessageInfo)this.objectMapper.readValue(inputStream, ExsMessageInfo.class);
                return exsMessageInfo;
            }
        });
    }

    @Override
    public int ack(List<String> ids) throws OotpException {
        return this.processIds(ids, "ack");
    }

    @Override
    public int ret(List<String> ids) throws OotpException {
        return this.processIds(ids, "ret");
    }

    int processIds(List<String> ids, String action) throws OotpException {
        byte[] bytes;
        if (ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("ids \u4e0d\u80fd\u4e3a\u7a7a");
        }
        LinkedHashMap<String, List<String>> request = new LinkedHashMap<String, List<String>>();
        request.put("ids", ids);
        try {
            bytes = this.objectMapper.writeValueAsBytes(request);
        }
        catch (JsonProcessingException e) {
            throw new OotpException("\u5e8f\u5217\u5316 " + action + " \u8bf7\u6c42\u51fa\u9519", e);
        }
        HttpPost httpPost = new HttpPost(this.basePath + "/api/messages/" + action + "/v2");
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(bytes, ContentType.APPLICATION_JSON));
        return this.exec((HttpUriRequest)httpPost, (response, entity) -> {
            Map result;
            try (InputStream inputStream = entity.getContent();){
                result = (Map)this.objectMapper.readValue(inputStream, Map.class);
            }
            log.debug("{} result: {}", (Object)action, (Object)result);
            return ((Number)result.get("count")).intValue();
        });
    }

    @FunctionalInterface
    static interface Handler<T> {
        public T apply(CloseableHttpResponse var1, HttpEntity var2) throws IOException;
    }

    public static class MessageV2 {
        private String id;
        private String type;
        private String from;
        private String contentType;
        private String body;

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getFrom() {
            return this.from;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getBody() {
            return this.body;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageV2)) {
                return false;
            }
            MessageV2 other = (MessageV2)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$from = this.getFrom();
            String other$from = other.getFrom();
            if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageV2;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : $from.hashCode());
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        public String toString() {
            return "V2MessageClientImpl.MessageV2(id=" + this.getId() + ", type=" + this.getType() + ", from=" + this.getFrom() + ", contentType=" + this.getContentType() + ", body=" + this.getBody() + ")";
        }
    }
}

