package org.opoo.ootp.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayBody implements ExsBody {
    private final byte[] content;

    public ByteArrayBody(byte[] content) {
        this.content = content;
    }

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(content);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(content);
        outputStream.flush();
    }

    public byte[] toByteArray() {
        return content;
    }
}
