package org.opoo.ootp.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

/**
 * 注意，没有执行编码时使用 UTF-8
 */
public class StringBody implements ExsBody {
    private final String string;
    private final Charset charset;

    public StringBody(String string) {
        this(string, null);
    }

    public StringBody(String string, Charset charset) {
        this.string = string;
        this.charset = Optional.ofNullable(charset).orElse(StandardCharsets.UTF_8);
    }

    @Override
    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return new ByteArrayInputStream(string.getBytes(charset));
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        // IOUtils.write(string, outputStream, charset)
        outputStream.write(string.getBytes(charset));
    }

    public String getString() {
        return string;
    }

    public Charset getCharset() {
        return charset;
    }
}
