/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.opoo.ootp.client.EntityBody;
import org.opoo.ootp.client.ExsBody;
import org.opoo.ootp.client.ExsCodec;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.client.FileClient;
import org.opoo.ootp.client.OotpException;
import org.opoo.ootp.client.impl.AbstractMessageClient;
import org.opoo.ootp.client.impl.FileCachedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileClientImpl
implements FileClient {
    private static final Logger log = LoggerFactory.getLogger(FileClientImpl.class);
    public static final String FILE_ID_FIELD = "fileId";
    private static final String S3_META_PREFIX = "x-amz-meta-";
    private static final int S3_META_PREFIX_LENGTH = "x-amz-meta-".length();
    private final URI endpoint;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper objectMapper;
    private ExsCodec codec;

    public FileClientImpl(URI endpoint, CloseableHttpClient httpClient, ObjectMapper objectMapper) {
        this.endpoint = endpoint;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    public ExsCodec getCodec() {
        return this.codec;
    }

    public void setCodec(ExsCodec codec) {
        this.codec = codec;
    }

    @Override
    public String upload(ExsMessage message, String storage, String pathInfo) throws IOException, OotpException {
        ExsBody body = message.getBody();
        ExsMetadata metadata = message.getMetadata();
        Objects.requireNonNull(storage, "storage is required.");
        Objects.requireNonNull(metadata, "metadata is required.");
        Objects.requireNonNull(metadata.getContentType(), "contentType is required.");
        Objects.requireNonNull(body, "file is required.");
        Objects.requireNonNull(metadata.getUserMetadata("file-name"), "fileName is required.");
        if ("fs".equals(storage)) {
            Objects.requireNonNull(metadata.getRepo(), "repo is required.");
        } else if ("default".equals(storage)) {
            Objects.requireNonNull(metadata.getTo(), "to is required.");
        }
        String path = this.endpoint.toString() + "/file-api/upload";
        if (pathInfo != null) {
            path = path + pathInfo;
        }
        path = path + "?storage=" + storage;
        HttpEntity entity2 = AbstractMessageClient.toEntity(body, metadata);
        HttpEntity entity = this.codec != null ? this.codec.encode(entity2, metadata) : entity2;
        HttpPut httpPut = new HttpPut(path);
        httpPut.setEntity(entity);
        metadata.toHeaders((arg_0, arg_1) -> ((HttpPut)httpPut).setHeader(arg_0, arg_1));
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPut);){
            Map map;
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            try (InputStream inputStream = response.getEntity().getContent();){
                map = (Map)this.objectMapper.readValue(inputStream, Map.class);
            }
            if (statusCode < 200 || statusCode >= 300) {
                String error = Optional.ofNullable(map).map(m -> m.get("error")).map(s -> " - " + s).orElse("");
                throw new OotpException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + statusCode + error, statusCode, statusLine.getReasonPhrase());
            }
            String string = Optional.ofNullable(map).map(m -> (String)m.get(FILE_ID_FIELD)).orElseThrow(() -> new OotpException("\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a", 500, "ResponseEmptyBody"));
            return string;
        }
    }

    protected <T> T getFile(String fileId, ResponseHandler<T> responseHandler) throws IOException {
        Objects.requireNonNull(fileId, "fileId is required.");
        HttpGet httpGet = new HttpGet(this.endpoint.toString() + "/file-api/file/" + fileId);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                throw new OotpException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a" + statusCode + " - " + statusLine.getReasonPhrase() + "\n" + string, statusCode, statusLine.getReasonPhrase());
            }
            HttpEntity entity = response.getEntity();
            ContentType contentType = ContentType.get((HttpEntity)entity);
            HashMap<String, String> headers = new HashMap<String, String>();
            Arrays.stream(response.getAllHeaders()).forEach(h -> headers.putIfAbsent(h.getName().toLowerCase(), h.getValue()));
            ExsMetadata metadata = ExsMetadata.fromHeaders(headers);
            metadata.setId(fileId);
            log.debug("ExsMetadata for '{}': {}", (Object)fileId, (Object)metadata);
            InputStream content = entity.getContent();
            InputStream decodeStream = this.codec != null ? this.codec.decode(content, metadata) : content;
            T t = responseHandler.handle(decodeStream, contentType, metadata);
            return t;
        }
    }

    @Override
    public ExsMessage getFile(String fileId) throws IOException {
        return this.getFile(fileId, (inputStream, contentType, metadata) -> {
            log.debug("\u6784\u5efa\u81ea\u52a8\u5220\u9664\u7684\u6587\u4ef6\u7f13\u5b58\u8f93\u5165\u6d41: {}", (Object)fileId);
            FileCachedInputStream ootpFileCachedInputStream = FileCachedInputStream.create(inputStream, fileId);
            long size = Files.size(ootpFileCachedInputStream.getFile());
            InputStreamEntity inputStreamEntity = new InputStreamEntity((InputStream)ootpFileCachedInputStream, size, contentType);
            EntityBody entityBody = new EntityBody((HttpEntity)inputStreamEntity);
            return new ExsMessage(entityBody, metadata);
        });
    }

    @Override
    public InputStream getStream(String fileId) throws IOException {
        log.debug("\u6784\u5efa\u81ea\u52a8\u5220\u9664\u7684\u6587\u4ef6\u7f13\u5b58\u8f93\u5165\u6d41\uff1a{}", (Object)fileId);
        return this.getFile(fileId, (inputStream, contentType, metadata) -> FileCachedInputStream.create(inputStream, fileId));
    }

    @Override
    public void copy(String fileId, Path destination) throws IOException {
        this.getFile(fileId, (inputStream, contentType, metadata) -> {
            log.debug("\u76f4\u63a5\u5c06\u6587\u4ef6\u590d\u5236\u5230\u6587\u4ef6: {} -> {}", (Object)fileId, (Object)destination);
            try (InputStream in = inputStream;){
                Files.copy(in, destination, StandardCopyOption.REPLACE_EXISTING);
            }
        });
    }

    @Override
    public void copy(String fileId, OutputStream outputStream) throws IOException {
        this.getFile(fileId, (inputStream, contentType, metadata) -> {
            log.debug("\u76f4\u63a5\u5c06\u6587\u4ef6\u590d\u5236\u5230\u8f93\u51fa\u6d41: {}", (Object)fileId);
            try (InputStream in = inputStream;){
                FileClient.copy(in, outputStream);
            }
        });
    }

    protected <T> T getUri(URI uri, ResponseHandler<T> responseHandler) throws IOException {
        Objects.requireNonNull(uri, "uri is required.");
        HttpGet httpGet = new HttpGet(uri);
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute("signer.skip", (Object)"true");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet, (HttpContext)httpContext);){
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                throw new OotpException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a" + statusCode + " - " + statusLine.getReasonPhrase() + "\n" + string, statusCode, statusLine.getReasonPhrase());
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            Arrays.stream(response.getAllHeaders()).map(h -> new AbstractMap.SimpleEntry<String, String>(h.getName().toLowerCase(), h.getValue())).filter(e -> ((String)e.getKey()).startsWith(S3_META_PREFIX)).forEach(e -> {
                String cfr_ignored_0 = (String)headers.putIfAbsent(((String)e.getKey()).substring(S3_META_PREFIX_LENGTH), (String)e.getValue());
            });
            ExsMetadata metadata = ExsMetadata.fromHeaders(headers);
            log.debug("ExsMetadata for uri: {}", (Object)metadata);
            HttpEntity entity = response.getEntity();
            InputStream content = entity.getContent();
            InputStream decodeStream = this.codec != null ? this.codec.decode(content, metadata) : content;
            T t = responseHandler.handle(decodeStream, ContentType.get((HttpEntity)entity), metadata);
            return t;
        }
    }

    @Override
    public ExsMessage getUri(URI uri) throws IOException {
        return this.getUri(uri, (inputStream, contentType, metadata) -> {
            log.debug("\u6784\u5efa\u81ea\u52a8\u5220\u9664\u7684\u6587\u4ef6\u7f13\u5b58\u8f93\u5165\u6d41\uff1a{}", (Object)uri.getHost());
            FileCachedInputStream ootpFileCachedInputStream = FileCachedInputStream.create(inputStream);
            long size = Files.size(ootpFileCachedInputStream.getFile());
            InputStreamEntity inputStreamEntity = new InputStreamEntity((InputStream)ootpFileCachedInputStream, size, contentType);
            EntityBody entityBody = new EntityBody((HttpEntity)inputStreamEntity);
            return new ExsMessage(entityBody, metadata);
        });
    }

    @Override
    public InputStream getStream(URI uri) throws IOException {
        log.debug("\u6784\u5efa\u81ea\u52a8\u5220\u9664\u7684\u6587\u4ef6\u7f13\u5b58\u8f93\u5165\u6d41\uff1a{}", (Object)uri.getHost());
        return this.getUri(uri, (inputStream, contentType, metadata) -> FileCachedInputStream.create(inputStream));
    }

    @Override
    public void copy(URI uri, OutputStream outputStream) throws IOException {
        this.getUri(uri, (inputStream, contentType, metadata) -> {
            log.debug("\u76f4\u63a5\u5c06URI\u590d\u5236\u5230\u8f93\u51fa\u6d41\uff1a{}", (Object)uri.getHost());
            try (InputStream in = inputStream;){
                FileClient.copy(in, outputStream);
            }
        });
    }

    @Override
    public void copy(URI uri, Path destination) throws IOException {
        this.getUri(uri, (inputStream, contentType, metadata) -> {
            log.debug("\u76f4\u63a5\u5c06URI\u590d\u5236\u5230\u6587\u4ef6: {} -> {}", (Object)uri.getHost(), (Object)destination);
            try (InputStream in = inputStream;){
                Files.copy(in, destination, StandardCopyOption.REPLACE_EXISTING);
            }
        });
    }

    @FunctionalInterface
    static interface ResponseHandlerWithoutResult
    extends ResponseHandler<Object> {
        @Override
        default public Object handle(InputStream inputStream, ContentType contentType, ExsMetadata metadata) throws IOException {
            this.handleWithoutResult(inputStream, contentType, metadata);
            return null;
        }

        public void handleWithoutResult(InputStream var1, ContentType var2, ExsMetadata var3) throws IOException;
    }

    @FunctionalInterface
    static interface ResponseHandler<T> {
        public T handle(InputStream var1, ContentType var2, ExsMetadata var3) throws IOException;
    }
}

