package org.opoo.ootp.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * 消息体。
 */
public interface ExsBody {

    /**
     * 消息主体。
     *
     * @return 输入流
     * @throws IOException IO 操作异常
     * @throws UnsupportedOperationException 不能创建相应的输入流时抛出此异常，此时可能需要调用
     *  {@link #writeTo(OutputStream)} 方法获取消息的内容
     */
    InputStream getContent() throws IOException, UnsupportedOperationException;

    /**
     * 将消息主体写入输出流。
     *
     * @param outputStream 输出流
     * @throws IOException IO 操作异常
     */
    void writeTo(OutputStream outputStream) throws IOException;

}
