package org.opoo.ootp.client;

import org.apache.http.HttpEntity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EntityBody implements ExsBody {
    private final HttpEntity entity;

    public EntityBody(HttpEntity entity) {
        this.entity = entity;
    }

    @Override
    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return entity.getContent();
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        entity.writeTo(outputStream);
    }

    public HttpEntity getEntity() {
        return entity;
    }
}
