package org.opoo.ootp.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class PollRequest {
    /**
     * 默认上限。
     */
    public static final int DEFAULT_LIMIT = 100;

    private int limit = DEFAULT_LIMIT;
    private boolean autoAck = false;
    private boolean full = false;
    private String latestId;
    @JsonIgnore
    private String clientId;

    public PollRequest(int limit, boolean autoAck, boolean full) {
        this.limit = limit;
        this.autoAck = autoAck;
        this.full = full;
    }

    public PollRequest(int limit, boolean autoAck, boolean full, String latestId) {
        this.limit = limit;
        this.autoAck = autoAck;
        this.full = full;
        this.latestId = latestId;
    }

}
