package org.opoo.ootp.client.impl;

import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.protocol.HttpContext;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Consumer;

@Deprecated
@Slf4j
public class EndpointProcessingHttpRequestInterceptor implements HttpRequestInterceptor {
    private final URI endpoint;

    public EndpointProcessingHttpRequestInterceptor(URI endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        URI uri = null;
        Consumer<URI> uriSetter = null;

        if (request instanceof HttpRequestBase) {
            uri = ((HttpRequestBase) request).getURI();
            uriSetter = ((HttpRequestBase) request)::setURI;
        } else if (request instanceof HttpRequestWrapper) {
            uri = ((HttpRequestWrapper) request).getURI();
            uriSetter = ((HttpRequestWrapper) request)::setURI;
        }

        if (uri == null) {
            log.warn("URI 无法处理，不能增加 endpoint：{}", uri);
            return;
        }

        try {
            final URI newUri = URIUtils.rewriteURI(uri, new HttpHost(endpoint.getHost(), endpoint.getPort(), endpoint.getScheme()));
            log.debug("重写后的 URI：{}", newUri);
            uriSetter.accept(newUri);
        } catch (URISyntaxException e) {
            throw new IllegalArgumentException("重写 URI 时出错", e);
        }
    }
}
