/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EntityUtils;
import org.opoo.ootp.client.EntityBody;
import org.opoo.ootp.client.ExsBody;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsMessageInfo;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.client.OotpException;
import org.opoo.ootp.client.PollRequest;
import org.opoo.ootp.client.PollResult;
import org.opoo.ootp.client.StringBody;

public interface MessageClient {
    public static final int DEFAULT_LIMIT = 100;
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    public String send(ExsMessage var1) throws OotpException;

    default public String send(ExsBody body, ExsMetadata metadata) throws OotpException {
        return this.send(new ExsMessage(body, metadata));
    }

    default public String send(String body, ExsMetadata metadata) throws OotpException {
        StringBody stringBody = new StringBody(body);
        return this.send(new ExsMessage(stringBody, metadata));
    }

    default public String send(String type, String to, String contentType, String body) throws OotpException {
        ExsMetadata metadata = new ExsMetadata();
        metadata.setTo(to);
        metadata.setType(type);
        metadata.setContentType(contentType);
        return this.send(body, metadata);
    }

    @Deprecated
    default public String send(String type, String to, String contentType, byte[] body) throws OotpException {
        ExsMetadata metadata = new ExsMetadata();
        metadata.setTo(to);
        metadata.setType(type);
        metadata.setContentType(contentType);
        EntityBody entityBody = new EntityBody((HttpEntity)new ByteArrayEntity(body));
        return this.send(new ExsMessage(entityBody, metadata));
    }

    public PollResult poll(PollRequest var1) throws OotpException;

    default public PollResult poll(int limit, boolean autoAck, boolean full) throws OotpException {
        PollRequest request = new PollRequest(limit, autoAck, full);
        return this.poll(request);
    }

    default public PollResult poll() throws OotpException {
        return this.poll(100, false, false);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    default public String getMessageBody(String id) throws OotpException {
        ExsBody body = this.getMessage(id).getBody();
        if (body instanceof EntityBody) {
            try {
                return EntityUtils.toString((HttpEntity)((EntityBody)body).getEntity());
            }
            catch (IOException e) {
                throw new OotpException("\u8bfb\u53d6\u6d88\u606f\u5185\u5bb9\u51fa\u9519", e);
            }
        }
        try (InputStream content = body.getContent();){
            String string;
            try (InputStreamReader reader = new InputStreamReader(content, StandardCharsets.UTF_8);){
                int l;
                CharArrayBuffer buffer = new CharArrayBuffer(4096);
                char[] tmp = new char[1024];
                while ((l = reader.read(tmp)) != -1) {
                    buffer.append(tmp, 0, l);
                }
                string = buffer.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new OotpException("\u8bfb\u53d6\u6d88\u606f\u5185\u5bb9\u51fa\u9519", e);
        }
    }

    public ExsMessage getMessage(String var1) throws OotpException;

    public ExsMessageInfo getMessageInfo(String var1) throws OotpException;

    default public int ack(String ... ids) throws OotpException {
        return this.ack(Arrays.asList(ids));
    }

    public int ack(List<String> var1) throws OotpException;

    default public int ret(String ... ids) throws OotpException {
        return this.ret(Arrays.asList(ids));
    }

    default public int ret(List<String> ids) throws OotpException {
        return this.ret(ids, null);
    }

    public int ret(List<String> var1, Consumer<Object> var2) throws OotpException;
}

