/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.opoo.ootp.client.EntityBody;
import org.opoo.ootp.client.ExsBody;
import org.opoo.ootp.client.ExsCodec;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.client.MessageClient;
import org.opoo.ootp.client.OotpException;
import org.opoo.ootp.client.StringBody;
import org.opoo.ootp.codec.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageClient
implements MessageClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractMessageClient.class);
    private static final String DEFAULT_BASE_PATH = "/exs-api";
    private final URI endpoint;
    protected final CloseableHttpClient httpClient;
    protected final ObjectMapper objectMapper;
    protected final String basePath;
    private ExsCodec codec;

    public AbstractMessageClient(URI endpoint, CloseableHttpClient httpClient, ObjectMapper objectMapper, String basePath) {
        this.endpoint = endpoint;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
        this.basePath = basePath != null ? basePath : DEFAULT_BASE_PATH;
    }

    public ExsCodec getCodec() {
        return this.codec;
    }

    public void setCodec(ExsCodec codec) {
        this.codec = codec;
    }

    protected void processUri(HttpUriRequest request) {
        try {
            URI uri = request.getURI();
            URI newUri = URIUtils.rewriteURI((URI)uri, (HttpHost)new HttpHost(this.endpoint.getHost(), this.endpoint.getPort(), this.endpoint.getScheme()));
            ((HttpRequestBase)request).setURI(newUri);
            log.debug("URI \u8865\u5168\u5230\uff1a{} -> {}", (Object)uri, (Object)newUri);
        }
        catch (URISyntaxException ex) {
            throw new OotpException("URI \u5904\u7406\u5931\u8d25", ex);
        }
    }

    protected static HttpEntity toEntity(ExsBody body, ExsMetadata metadata) throws IOException {
        if (body instanceof EntityBody) {
            return ((EntityBody)body).getEntity();
        }
        ContentType contentType = ContentType.parse((String)metadata.getContentType());
        if (body instanceof StringBody) {
            StringBody stringBody = (StringBody)body;
            ContentType contentType2 = Optional.ofNullable(stringBody.getCharset()).map(arg_0 -> ((ContentType)contentType).withCharset(arg_0)).orElse(contentType);
            return new StringEntity(stringBody.getString(), contentType2);
        }
        long contentLength = Optional.ofNullable(metadata.getContentLength()).filter(l -> l > 0L).orElse(-1L);
        return new InputStreamEntity(body.getContent(), contentLength, contentType);
    }

    protected HttpEntity codecEncode(HttpEntity entity, ExsMetadata metadata) throws IOException {
        if (this.codec == null) {
            log.debug("ExsCodec \u6ca1\u6709\u914d\u7f6e\uff0c\u6d88\u606f\u65e0\u9700\uff08\u65e0\u6cd5\uff09\u7f16\u7801/\u52a0\u5bc6");
            return entity;
        }
        return this.codec.encode(entity, metadata);
    }

    protected HttpEntity codecDecode(HttpEntity entity, ExsMetadata metadata) throws IOException {
        if (this.codec == null) {
            log.debug("ExsCodec \u6ca1\u6709\u914d\u7f6e\uff0c\u6d88\u606f\u65e0\u9700\uff08\u65e0\u6cd5\uff09\u89e3\u7801/\u89e3\u5bc6");
            return entity;
        }
        return this.codec.decode(entity, metadata);
    }

    protected void validateResponse(CloseableHttpResponse response) throws IOException, OotpException {
        this.validateResponse(response, () -> true, null);
    }

    protected void validateResponse(CloseableHttpResponse response, Supplier<Boolean> parseErrorBody, String baseExceptionMessage) throws IOException, OotpException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        int statusCode = statusLine.getStatusCode();
        if (statusCode < 200 || statusCode >= 300) {
            if (this.hasContent(response) && parseErrorBody.get().booleanValue()) {
                InputStream inputStream = entity.getContent();
                try {
                    Map map = (Map)this.objectMapper.readValue(inputStream, Map.class);
                    String error = (String)map.get("error");
                    String message = (String)map.get("message");
                    String errMsg = (String)map.get("errMsg");
                    if (errMsg != null) {
                        throw new OotpException(statusCode + " " + errMsg, statusCode, statusLine.getReasonPhrase());
                    }
                    String exceptionMessage = "\u6d88\u606fAPI\u8c03\u7528\u5931\u8d25\uff1a" + statusCode;
                    if (error != null) {
                        exceptionMessage = exceptionMessage + " " + error;
                    }
                    if (message != null) {
                        exceptionMessage = exceptionMessage + " - " + message;
                    }
                    throw new OotpException(exceptionMessage, statusCode, error);
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            log.debug("Response status: {}, content length: {}", (Object)statusCode, (Object)response.getFirstHeader("content-length"));
            EntityUtils.consumeQuietly((HttpEntity)entity);
            String msg = Optional.ofNullable(baseExceptionMessage).orElse("\u6d88\u606fAPI\u8c03\u7528\u5931\u8d25");
            throw new OotpException(msg + "\uff1a" + statusCode + " " + statusLine.getReasonPhrase(), statusCode, statusLine.getReasonPhrase());
        }
    }

    protected boolean hasContent(CloseableHttpResponse response) {
        Long length = Optional.ofNullable(response.getFirstHeader("content-length")).map(NameValuePair::getValue).map(Long::parseLong).orElse(0L);
        if (length > 0L) {
            return true;
        }
        String transferEncoding = Optional.ofNullable(response.getFirstHeader("Transfer-Encoding")).map(NameValuePair::getValue).orElse(null);
        return "chunked".equals(transferEncoding);
    }

    protected ExsMessage getMessage(String id, Function<String, String> idToPath) throws OotpException {
        ExsMessage exsMessage;
        block8: {
            Objects.requireNonNull(id, "id is required.");
            Objects.requireNonNull(idToPath, "idToPath function is required.");
            HttpGet httpGet = new HttpGet(this.basePath + idToPath.apply(id));
            this.processUri((HttpUriRequest)httpGet);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
            try {
                HttpEntity entity = response.getEntity();
                HashMap<String, String> headers = new HashMap<String, String>();
                Arrays.stream(response.getAllHeaders()).forEach(h -> headers.putIfAbsent(h.getName().toLowerCase(), h.getValue()));
                ExsMetadata metadata = ExsMetadata.fromHeaders(headers);
                this.validateResponse(response, () -> {
                    ContentType contentType = ContentType.get((HttpEntity)entity);
                    if (contentType == null) {
                        return false;
                    }
                    String str = contentType.toString().toLowerCase();
                    return str.startsWith("application/") && str.contains("json") && metadata.getUserMetadata(Codec.META_TRANSFORM_MODE) == null;
                }, "\u83b7\u53d6\u6d88\u606f[" + id + "]\u5931\u8d25");
                HttpEntity decodedEntity = this.codecDecode(entity, metadata);
                BufferedHttpEntity httpEntity = new BufferedHttpEntity(decodedEntity);
                exsMessage = new ExsMessage(new EntityBody((HttpEntity)httpEntity), metadata);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new OotpException("\u83b7\u53d6\u6d88\u606f[" + id + "]\u5931\u8d25\uff1a" + ex.getMessage(), ex);
                }
            }
            response.close();
        }
        return exsMessage;
    }

    protected int processIds(List<String> ids, Consumer<Object> requestConfigurer, String path, Function<HttpPost, Integer> resultHandler) throws OotpException {
        byte[] bytes;
        if (ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("ids \u4e0d\u80fd\u4e3a\u7a7a");
        }
        LinkedHashMap<String, List<String>> request = new LinkedHashMap<String, List<String>>();
        request.put("ids", ids);
        Optional.ofNullable(requestConfigurer).ifPresent(c -> c.accept(request));
        try {
            bytes = this.objectMapper.writeValueAsBytes(request);
        }
        catch (JsonProcessingException e) {
            throw new OotpException("\u5e8f\u5217\u5316 " + path + " \u8bf7\u6c42\u51fa\u9519", e);
        }
        HttpPost httpPost = new HttpPost(this.basePath + path);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(bytes, ContentType.APPLICATION_JSON));
        return resultHandler.apply(httpPost);
    }
}

