package org.opoo.ootp.client;

public class OotpException extends RuntimeException {
    private int code;
    private String error;

    public OotpException() {
    }

    public OotpException(String message) {
        super(message);
    }

    public OotpException(String message, Throwable cause) {
        super(message, cause);
    }

    public OotpException(Throwable cause) {
        super(cause);
    }

    public OotpException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public OotpException(int code, String error) {
        this.code = code;
        this.error = error;
    }

    public OotpException(String message, int code, String error) {
        super(message);
        this.code = code;
        this.error = error;
    }

    public OotpException(String message, Throwable cause, int code, String error) {
        super(message, cause);
        this.code = code;
        this.error = error;
    }

    public OotpException(Throwable cause, int code, String error) {
        super(cause);
        this.code = code;
        this.error = error;
    }

    public OotpException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, int code, String error) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.code = code;
        this.error = error;
    }

    public int getCode() {
        return code;
    }

    public String getError() {
        return error;
    }
}
