/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import java.security.Key;
import java.util.Map;
import java.util.function.Consumer;
import javax.crypto.SecretKey;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.codec.Codec;
import org.opoo.ootp.codec.binary.BinaryEncodeConstants;
import org.opoo.ootp.codec.encryption.EncryptionUtils;
import org.opoo.ootp.codec.encryption.KeyAndSpecProvider;
import org.opoo.ootp.codec.encryption.sm4.SM4EncryptionConstants;

public class SimpleSM4DecodingMetadataConfigurer
implements Consumer<ExsMetadata> {
    private static final String DEFAULT_TRANSFORM_MODE = "SM4:SM4/ECB/PKCS5Padding,BIN:base64";
    private final String keyHash;
    private String transformMode = "SM4:SM4/ECB/PKCS5Padding,BIN:base64";

    public SimpleSM4DecodingMetadataConfigurer(SecretKey secretKey) {
        this(EncryptionUtils.getKeyHash((Key)secretKey));
    }

    public SimpleSM4DecodingMetadataConfigurer(String keyHash) {
        this.keyHash = keyHash;
    }

    public SimpleSM4DecodingMetadataConfigurer(KeyAndSpecProvider keyAndSpecProvider) {
        this.keyHash = keyAndSpecProvider.getMasterKeyHash();
    }

    public String getTransformMode() {
        return this.transformMode;
    }

    public void setTransformMode(String transformMode) {
        this.transformMode = transformMode;
    }

    @Override
    public void accept(ExsMetadata metadata) {
        Map<String, String> metaMap = metadata.getUserMetadata();
        metaMap.put(Codec.META_TRANSFORM_MODE, this.transformMode);
        metaMap.put(SM4EncryptionConstants.META_ENCRYPTION_KEY_HASH, this.keyHash);
        metaMap.put(SM4EncryptionConstants.META_ENCRYPTION_UNENC_SM3, "");
        metaMap.put(SM4EncryptionConstants.META_ENCRYPTION_UNENC_SIZE, "-1");
        metaMap.put(BinaryEncodeConstants.META_BIN_UNENCODED_SIZE, "-1");
        metaMap.put(BinaryEncodeConstants.META_BIN_ENCODED_SIZE, "-1");
        metaMap.put(BinaryEncodeConstants.META_BIN_UNENCODED_SM3, "");
    }
}

