/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.VersionInfo;
import org.opoo.ootp.client.ExsCodec;
import org.opoo.ootp.client.FileClient;
import org.opoo.ootp.client.MessageClient;
import org.opoo.ootp.client.OotpClient;
import org.opoo.ootp.client.impl.AbstractMessageClient;
import org.opoo.ootp.client.impl.FileClientImpl;
import org.opoo.ootp.client.impl.HttpClientConfigurer;
import org.opoo.ootp.client.impl.V1MessageClientImpl;
import org.opoo.ootp.client.impl.V2MessageClientImpl;
import org.opoo.ootp.signer.AbstractSigner;
import org.opoo.ootp.signer.Signer;
import org.opoo.ootp.signer.httpclient.SignerHttpRequestInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OotpClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(OotpClientBuilder.class);
    public static final String HTTP_VERSION = VersionInfo.getUserAgent((String)"Apache-HttpClient", (String)"org.apache.http.client", HttpClientBuilder.class);
    public static final String PACKAGE_VERSION = OotpClientBuilder.class.getPackage().getImplementationVersion();
    public static final String DEFAULT_USER_AGENT = String.format("Ootp Java Client%s %s (%s; %s; %s)", PACKAGE_VERSION != null ? " v" + PACKAGE_VERSION : "", HTTP_VERSION, System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
    private URI endpoint;
    private String systemId;
    private Signer signer;
    private ObjectMapper objectMapper;
    private boolean version1 = false;
    private String messageBasePath;
    private String fileBasePath;
    private String openApiContextPath;
    private String userAgent;
    private ExsCodec messageCodec;
    private ExsCodec fileCodec;
    private boolean defaultCjkExtensionEnabled;
    private final List<HttpClientConfigurer> httpClientConfigurers = new ArrayList<HttpClientConfigurer>();
    private final List<HttpClientConfigurer.RequestConfigConfigurer> requestConfigConfigurers = new ArrayList<HttpClientConfigurer.RequestConfigConfigurer>();

    private OotpClientBuilder() {
    }

    public static OotpClient defaultClient(URI endpoint, Signer signer) {
        return new OotpClientBuilder().endpoint(endpoint).signer(signer).build();
    }

    public static OotpClient defaultClient(String endpoint, Signer signer) {
        return OotpClientBuilder.defaultClient(URI.create(endpoint), signer);
    }

    public static OotpClientBuilder custom() {
        return new OotpClientBuilder();
    }

    public OotpClientBuilder signer(Signer signer) {
        this.signer = signer;
        return this;
    }

    public OotpClientBuilder endpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public OotpClientBuilder endpoint(String endpoint) {
        this.endpoint = URI.create(endpoint);
        return this;
    }

    @Deprecated
    public OotpClientBuilder basePath(String basePath) {
        return this;
    }

    public OotpClientBuilder messageBasePath(String messageBasePath) {
        this.messageBasePath = messageBasePath;
        return this;
    }

    public OotpClientBuilder fileBasePath(String fileBasePath) {
        this.fileBasePath = fileBasePath;
        return this;
    }

    public OotpClientBuilder openApiContextPath(String openApiContextPath) {
        this.openApiContextPath = openApiContextPath;
        return this;
    }

    public OotpClientBuilder systemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    public OotpClientBuilder objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public OotpClientBuilder useVersion1() {
        this.version1 = true;
        return this;
    }

    public OotpClientBuilder userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public OotpClientBuilder messageCodec(ExsCodec codec) {
        this.messageCodec = codec;
        return this;
    }

    public OotpClientBuilder fileCodec(ExsCodec codec) {
        this.fileCodec = codec;
        return this;
    }

    public OotpClientBuilder defaultCjkExtensionEnabled(boolean defaultCjkExtensionEnabled) {
        this.defaultCjkExtensionEnabled = defaultCjkExtensionEnabled;
        return this;
    }

    public OotpClientBuilder addHttpClientConfigurer(HttpClientConfigurer configurer) {
        this.httpClientConfigurers.add(configurer);
        return this;
    }

    public OotpClientBuilder httpClientConfigurers(List<HttpClientConfigurer> configurers) {
        this.httpClientConfigurers.clear();
        if (configurers != null) {
            this.httpClientConfigurers.addAll(configurers);
        }
        return this;
    }

    public OotpClientBuilder addHttpClientRequestConfigConfigurer(HttpClientConfigurer.RequestConfigConfigurer requestConfigConfigurer) {
        this.requestConfigConfigurers.add(requestConfigConfigurer);
        return this;
    }

    public OotpClientBuilder httpClientRequestConfigConfigurers(List<HttpClientConfigurer.RequestConfigConfigurer> requestConfigConfigurers) {
        this.requestConfigConfigurers.clear();
        if (requestConfigConfigurers != null) {
            this.requestConfigConfigurers.addAll(requestConfigConfigurers);
        }
        return this;
    }

    private CloseableHttpClient buildCloseableHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().disableAuthCaching().disableCookieManagement().disableRedirectHandling().disableAutomaticRetries().setMaxConnPerRoute(20).setMaxConnTotal(20);
        this.httpClientConfigurers.forEach(c -> c.configure(httpClientBuilder));
        RequestConfig.Builder builder = RequestConfig.custom().setConnectionRequestTimeout(3000).setConnectTimeout(5000).setSocketTimeout(30000);
        this.requestConfigConfigurers.forEach(c -> c.configure(builder));
        httpClientBuilder.setDefaultRequestConfig(builder.build());
        return httpClientBuilder.setUserAgent(this.buildUserAgent()).addInterceptorFirst((HttpRequestInterceptor)new SignerHttpRequestInterceptor(this.signer)).build();
    }

    private String buildUserAgent() {
        if (this.userAgent != null) {
            return this.userAgent;
        }
        if (this.systemId != null) {
            return DEFAULT_USER_AGENT + " (" + this.systemId + ")";
        }
        if (this.signer instanceof AbstractSigner) {
            String accessKey = ((AbstractSigner)this.signer).getAccessKey();
            String str = accessKey.length() > 10 ? accessKey.substring(0, 10) : accessKey;
            return DEFAULT_USER_AGENT + " (" + str + ")";
        }
        return DEFAULT_USER_AGENT;
    }

    public OotpClient build() {
        Objects.requireNonNull(this.endpoint, "\u5fc5\u987b\u8bbe\u7f6e endpoint");
        Objects.requireNonNull(this.signer, "signer \u4e0d\u80fd\u4e3a\u7a7a");
        CloseableHttpClient httpClient = this.buildCloseableHttpClient();
        ObjectMapper objectMapper = Optional.ofNullable(this.objectMapper).orElseGet(() -> new ObjectMapper().disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS));
        AbstractMessageClient messageClient = this.version1 ? new V1MessageClientImpl(this.endpoint, httpClient, objectMapper, this.messageBasePath, this.openApiContextPath) : new V2MessageClientImpl(this.endpoint, httpClient, objectMapper, this.messageBasePath, this.openApiContextPath);
        messageClient.setDefaultCjkExtensionEnabled(this.defaultCjkExtensionEnabled);
        FileClientImpl fileClient = new FileClientImpl(this.endpoint, httpClient, objectMapper, this.fileBasePath, this.openApiContextPath);
        Optional.ofNullable(this.messageCodec).ifPresent(messageClient::setCodec);
        Optional.ofNullable(this.fileCodec).ifPresent(fileClient::setCodec);
        return new OotpClientImpl(messageClient, fileClient, httpClient);
    }

    static class OotpClientImpl
    implements OotpClient,
    AutoCloseable {
        private final MessageClient messageClient;
        private final FileClient fileClient;
        private final CloseableHttpClient httpClient;

        @Override
        public void close() throws Exception {
            if (this.httpClient != null) {
                log.info("\u5173\u95ed HttpClient");
                try {
                    this.httpClient.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public MessageClient getMessageClient() {
            return this.messageClient;
        }

        @Override
        public FileClient getFileClient() {
            return this.fileClient;
        }

        @Override
        public CloseableHttpClient getHttpClient() {
            return this.httpClient;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OotpClientImpl)) {
                return false;
            }
            OotpClientImpl other = (OotpClientImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MessageClient this$messageClient = this.getMessageClient();
            MessageClient other$messageClient = other.getMessageClient();
            if (this$messageClient == null ? other$messageClient != null : !this$messageClient.equals(other$messageClient)) {
                return false;
            }
            FileClient this$fileClient = this.getFileClient();
            FileClient other$fileClient = other.getFileClient();
            if (this$fileClient == null ? other$fileClient != null : !this$fileClient.equals(other$fileClient)) {
                return false;
            }
            CloseableHttpClient this$httpClient = this.getHttpClient();
            CloseableHttpClient other$httpClient = other.getHttpClient();
            return !(this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OotpClientImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MessageClient $messageClient = this.getMessageClient();
            result = result * 59 + ($messageClient == null ? 43 : $messageClient.hashCode());
            FileClient $fileClient = this.getFileClient();
            result = result * 59 + ($fileClient == null ? 43 : $fileClient.hashCode());
            CloseableHttpClient $httpClient = this.getHttpClient();
            result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
            return result;
        }

        public String toString() {
            return "OotpClientBuilder.OotpClientImpl(messageClient=" + this.getMessageClient() + ", fileClient=" + this.getFileClient() + ", httpClient=" + this.getHttpClient() + ")";
        }

        public OotpClientImpl(MessageClient messageClient, FileClient fileClient, CloseableHttpClient httpClient) {
            this.messageClient = messageClient;
            this.fileClient = fileClient;
            this.httpClient = httpClient;
        }
    }
}

