/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import java.security.PrivateKey;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.codec.Codec;
import org.opoo.ootp.codec.binary.BinaryEncodeConstants;
import org.opoo.ootp.codec.encryption.EncryptionUtils;
import org.opoo.ootp.codec.encryption.smx.SMXEncryptionConstants;

public class SimpleSMXDecodingMetadataConfigurer
implements Consumer<ExsMetadata> {
    private static final String DEFAULT_TRANSFORM_MODE = "SMX:SM4/CBC/PKCS5Padding,BIN:base64";
    private final String keyId;
    private String transformMode = "SMX:SM4/CBC/PKCS5Padding,BIN:base64";

    public SimpleSMXDecodingMetadataConfigurer(PrivateKey privateKey) {
        this(EncryptionUtils.getKeyFingerprint((PrivateKey)privateKey));
    }

    public SimpleSMXDecodingMetadataConfigurer(String keyId) {
        this.keyId = keyId;
    }

    public String getTransformMode() {
        return this.transformMode;
    }

    public void setTransformMode(String transformMode) {
        this.transformMode = transformMode;
    }

    @Override
    public void accept(ExsMetadata metadata) {
        Map<String, String> metaMap = metadata.getUserMetadata();
        metaMap.put(Codec.META_TRANSFORM_MODE, this.transformMode);
        if (!this.transformMode.contains("/ECB/")) {
            Objects.requireNonNull(metaMap.get(SMXEncryptionConstants.META_ENCRYPTION_IV), "\u52a0\u5bc6\u7b97\u6cd5\u4e0d\u662f ECB \u586b\u5145\u6a21\u5f0f\uff0c\u4e14\u5143\u6570\u636e\u4e2d\u7f3a\u5c11\u7b97\u6cd5\u7684\u521d\u59cb\u5316\u5411\u91cf\uff08initialization vector, IV): " + this.transformMode);
        }
        Objects.requireNonNull(metaMap.get(SMXEncryptionConstants.META_ENCRYPTION_MESSAGE_KEY), "\u5143\u6570\u636e\u4e2d\u7f3a\u5c11\u6570\u636e\u5bf9\u79f0\u52a0\u5bc6\uff08SM4\uff09\u7684\u5bc6\u94a5");
        metaMap.put(SMXEncryptionConstants.META_ENCRYPTION_UNENC_SM3, "");
        metaMap.put(SMXEncryptionConstants.META_ENCRYPTION_UNENC_SIZE, "-1");
        metaMap.put(SMXEncryptionConstants.META_ENCRYPTION_KEY_ID, this.keyId);
        metaMap.put(BinaryEncodeConstants.META_BIN_UNENCODED_SIZE, "-1");
        metaMap.put(BinaryEncodeConstants.META_BIN_ENCODED_SIZE, "-1");
        metaMap.put(BinaryEncodeConstants.META_BIN_UNENCODED_SM3, "");
    }
}

