package org.opoo.ootp.client;

import org.apache.http.HttpEntity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * 编码解码器/加密解密器。
 */
public interface ExsCodec {
    /**
     * 该原数据名称用于标识当前请求是否需要进行 Codec 操作。
     */
    String META_CODEC_REQUIRED = "codec-required";

    /**
     * 对实体进行加密/编码。如果是文件上传，一定要指定 meta 的 ContentLength，大文件可以使用磁盘缓存，否则将使用内存
     * 处理大数据，可能消耗大量的内存。
     * @param entity 消息实体
     * @param metadata 原数据，头信息
     * @return 处理后的消息，未经处理时是原对象
     * @throws IOException IO异常
     */
    HttpEntity encode(HttpEntity entity, ExsMetadata metadata) throws IOException;

    /**
     * 对输入流进行加密/编码。如果是文件上传，一定要指定 meta 的 ContentLength，大文件可以使用磁盘缓存，否则将使用内存
     * 处理大数据，可能消耗大量的内存。
     * @param inputStream 输入流
     * @param metadata 原数据，头信息
     * @return 处理后（封装）后的输入流
     * @throws IOException IO异常
     */
    InputStream encode(InputStream inputStream, ExsMetadata metadata) throws IOException;

    /**
     * 对实体解密/解码。
     * @param entity 消息实体
     * @param metadata 原数据，头信息
     * @return 处理后的消息，未经处理时是原对象
     * @throws IOException IO异常
     */
    HttpEntity decode(HttpEntity entity, ExsMetadata metadata) throws IOException;

    /**
     * 对输入流程解密/解码。
     * @param inputStream 输入流
     * @param metadata 元数据
     * @return 处理后的输入流
     * @throws IOException IO异常
     */
    InputStream decode(InputStream inputStream, ExsMetadata metadata) throws IOException;

    /**
     * 对输出流程解密/解码。
     * @param outputStream 输出流
     * @param metadata 元数据
     * @return 输出流
     * @throws IOException IO异常
     */
    OutputStream decode(OutputStream outputStream, ExsMetadata metadata) throws IOException;

    /**
     * 编码模式
     */
    enum CodecMode {
        /**
         * 所有消息都 Codec，除非明确表示不用。
         */
        ALL,
        /**
         * 根据原数据头 {@link #META_CODEC_REQUIRED} 的值确定是否需要 Codec。
         */
        BY_REQUIRED,
        /**
         * 都不 Codec。
         */
        NONE
    }
}
