package org.opoo.ootp.client;

import java.util.Optional;
import java.util.function.Consumer;

public interface ExsMetadataConfigurerProvider {
    /**
     * 获取指定接入方的解码元数据配置器。
     * @param from 接入方，消息来源方
     * @return 配置器
     */
    Consumer<ExsMetadata> getConfigurer(String from);

    /**
     * 对接入方的消息元数据进行配置。
     * @param from 接入方，消息来源方
     * @param metadata 元数据
     */
    default void configure(String from, ExsMetadata metadata) {
        Optional.ofNullable(getConfigurer(from)).ifPresent(c -> c.accept(metadata));
    }
}
