/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.opoo.ootp.client.ExsBody;

public class StringBody
implements ExsBody {
    private final String string;
    private final Charset charset;

    public StringBody(String string) {
        this(string, null);
    }

    public StringBody(String string, Charset charset) {
        this.string = string;
        this.charset = Optional.ofNullable(charset).orElse(StandardCharsets.UTF_8);
    }

    @Override
    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return new ByteArrayInputStream(this.string.getBytes(this.charset));
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.string.getBytes(this.charset));
    }

    public String getString() {
        return this.string;
    }

    public Charset getCharset() {
        return this.charset;
    }
}

