/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.opoo.ootp.client.EntityBody;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.client.FileInfo;
import org.opoo.ootp.client.OotpException;

public interface FileClient {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final String STORAGE_DEFAULT = "default";
    public static final String STORAGE_FS = "fs";

    public FileInfo put(ExsMessage var1, String var2, String var3) throws IOException, OotpException;

    default public String upload(ExsMessage message, String storage, String pathInfo) throws IOException, OotpException {
        return this.put(message, storage, pathInfo).getFileId();
    }

    default public String upload(ExsMessage message, String storage) throws IOException, OotpException {
        return this.upload(message, storage, null);
    }

    default public String upload(ExsMessage message) throws IOException, OotpException {
        return this.upload(message, STORAGE_DEFAULT, null);
    }

    default public String upload(InputStream stream, ExsMetadata metadata, String storage, String pathInfo) throws IOException, OotpException {
        Objects.requireNonNull(metadata, "metadata is required.");
        Objects.requireNonNull(metadata.getContentType(), "contentType is required.");
        String contentType = metadata.getContentType();
        Long contentLength = metadata.getContentLength();
        InputStreamEntity entity = contentLength != null && contentLength > 0L ? new InputStreamEntity(stream, contentLength.longValue(), ContentType.parse((String)contentType)) : new InputStreamEntity(stream, ContentType.parse((String)contentType));
        return this.upload(new ExsMessage(new EntityBody((HttpEntity)entity), metadata), storage, pathInfo);
    }

    default public String upload(InputStream stream, ExsMetadata metadata, String storage) throws IOException, OotpException {
        return this.upload(stream, metadata, storage, null);
    }

    default public String upload(InputStream stream, ExsMetadata metadata) throws IOException, OotpException {
        return this.upload(stream, metadata, STORAGE_DEFAULT, null);
    }

    default public String uploadToFsStorage(String repo, String contentType, File file) throws IOException, OotpException {
        return this.uploadToFsStorage(repo, contentType, file, null);
    }

    default public String uploadToFsStorage(String repo, String contentType, File file, String pathInfo) throws IOException, OotpException {
        Objects.requireNonNull(file, "file is required.");
        ExsMetadata exsMetadata = new ExsMetadata().withRepo(repo).withContentType(contentType).withContentLength(file.length()).addEncodedUserMetadata("file-name", file.getName());
        long lastModified = file.lastModified();
        if (lastModified > 0L) {
            exsMetadata.setLastModified(new Date(lastModified));
        }
        FileEntity fileEntity = new FileEntity(file, ContentType.parse((String)contentType));
        ExsMessage exsMessage = new ExsMessage(new EntityBody((HttpEntity)fileEntity), exsMetadata);
        return this.upload(exsMessage, STORAGE_FS, pathInfo);
    }

    default public String uploadToFsStorage(String repo, String contentType, InputStream file, String fileName, long fileSize, long lastModified) throws IOException, OotpException {
        return this.uploadToFsStorage(repo, contentType, file, fileName, fileSize, lastModified, null);
    }

    default public String uploadToFsStorage(String repo, String contentType, InputStream file, String fileName, long fileSize, long lastModified, String pathInfo) throws IOException, OotpException {
        Objects.requireNonNull(file, "file is required.");
        ExsMetadata exsMetadata = new ExsMetadata().withRepo(repo).withContentType(contentType).withContentLength(fileSize).addEncodedUserMetadata("file-name", fileName);
        if (lastModified > 0L) {
            exsMetadata.setLastModified(new Date(lastModified));
        }
        return this.upload(file, exsMetadata, STORAGE_FS, pathInfo);
    }

    default public String uploadToDefaultStorage(String to, String contentType, File file) throws IOException, OotpException {
        return this.upload(STORAGE_DEFAULT, to, contentType, file);
    }

    default public String uploadToDefaultStorage(String to, String contentType, File file, String pathInfo) throws IOException, OotpException {
        return this.upload(STORAGE_DEFAULT, to, contentType, file, pathInfo);
    }

    default public String uploadToDefaultStorage(String to, String contentType, InputStream file, String fileName, long fileSize, long lastModified) throws IOException, OotpException {
        return this.upload(STORAGE_DEFAULT, to, contentType, file, fileName, fileSize, lastModified);
    }

    default public String uploadToDefaultStorage(String to, String contentType, InputStream file, String fileName, long fileSize, long lastModified, String pathInfo) throws IOException, OotpException {
        return this.upload(STORAGE_DEFAULT, to, contentType, file, fileName, fileSize, lastModified, pathInfo);
    }

    default public String uploadToCustomStorage(String storage, String contentType, File file) throws IOException, OotpException {
        return this.upload(storage, null, contentType, file);
    }

    default public String uploadToCustomStorage(String storage, String contentType, File file, String pathInfo) throws IOException, OotpException {
        return this.upload(storage, null, contentType, file, pathInfo);
    }

    default public String uploadToCustomStorage(String storage, String contentType, InputStream file, String fileName, long fileSize, long lastModified) throws IOException, OotpException {
        return this.upload(storage, null, contentType, file, fileName, fileSize, lastModified);
    }

    default public String uploadToCustomStorage(String storage, String contentType, InputStream file, String fileName, long fileSize, long lastModified, String pathInfo) throws IOException, OotpException {
        return this.upload(storage, null, contentType, file, fileName, fileSize, lastModified, pathInfo);
    }

    default public String upload(String storage, String to, String contentType, File file) throws IOException, OotpException {
        return this.upload(storage, to, contentType, file, null);
    }

    default public String upload(String storage, String to, String contentType, File file, String pathInfo) throws IOException, OotpException {
        ExsMetadata exsMetadata = new ExsMetadata().withTo(to).withContentType(contentType).withContentLength(file.length()).addEncodedUserMetadata("file-name", file.getName());
        long lastModified = file.lastModified();
        if (lastModified > 0L) {
            exsMetadata.setLastModified(new Date(lastModified));
        }
        FileEntity fileEntity = new FileEntity(file, ContentType.parse((String)contentType));
        ExsMessage exsMessage = new ExsMessage(new EntityBody((HttpEntity)fileEntity), exsMetadata);
        return this.upload(exsMessage, storage, pathInfo);
    }

    default public String upload(String storage, String to, String contentType, InputStream file, String fileName, long fileSize, long lastModified) throws IOException, OotpException {
        return this.upload(storage, to, contentType, file, fileName, fileSize, lastModified, null);
    }

    default public String upload(String storage, String to, String contentType, InputStream file, String fileName, long fileSize, long lastModified, String pathInfo) throws IOException, OotpException {
        ExsMetadata exsMetadata = new ExsMetadata().withTo(to).withContentType(contentType).withContentLength(fileSize).addEncodedUserMetadata("file-name", fileName);
        if (lastModified > 0L) {
            exsMetadata.setLastModified(new Date(lastModified));
        }
        return this.upload(file, exsMetadata, storage, pathInfo);
    }

    public ExsMessage getFile(String var1) throws IOException;

    default public InputStream getStream(String fileId) throws IOException {
        return this.getFile(fileId).getBody().getContent();
    }

    default public void copy(String fileId, File destination) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(destination);){
            this.copy(fileId, (OutputStream)fos);
        }
    }

    default public void copy(String fileId, Path destination) throws IOException {
        try (InputStream inputStream = this.getStream(fileId);){
            Files.copy(inputStream, destination, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    default public void copy(String fileId, OutputStream outputStream) throws IOException {
        try (InputStream inputStream = this.getStream(fileId);){
            FileClient.copy(inputStream, outputStream);
        }
    }

    public ExsMessage getUri(URI var1) throws IOException;

    default public InputStream getStream(URI uri) throws IOException {
        return this.getUri(uri).getBody().getContent();
    }

    default public void copy(URI uri, OutputStream outputStream) throws IOException {
        try (InputStream inputStream = this.getStream(uri);){
            FileClient.copy(inputStream, outputStream);
        }
    }

    default public void copy(URI uri, File destination) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(destination);){
            this.copy(uri, (OutputStream)fos);
        }
    }

    default public void copy(URI uri, Path destination) throws IOException {
        try (InputStream inputStream = this.getStream(uri);){
            Files.copy(inputStream, destination, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        Objects.requireNonNull(in, "No InputStream specified");
        Objects.requireNonNull(out, "No OutputStream specified");
        int byteCount = 0;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            byteCount += bytesRead;
        }
        out.flush();
        return byteCount;
    }
}

