/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.opoo.ootp.client.ExsBody;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsMessageInfo;
import org.opoo.ootp.client.ExsMessageLite;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.client.MessageClient;
import org.opoo.ootp.client.OotpException;
import org.opoo.ootp.client.PollRequest;
import org.opoo.ootp.client.PollResult;
import org.opoo.ootp.client.impl.AbstractMessageClient;
import org.opoo.ootp.signer.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V1MessageClientImpl
extends AbstractMessageClient
implements MessageClient {
    private static final Logger log = LoggerFactory.getLogger(V1MessageClientImpl.class);

    public V1MessageClientImpl(URI endpoint, CloseableHttpClient httpClient, ObjectMapper objectMapper) {
        this(endpoint, httpClient, objectMapper, null, null);
    }

    public V1MessageClientImpl(URI endpoint, CloseableHttpClient httpClient, ObjectMapper objectMapper, String basePath, String openApiContextPath) {
        super(endpoint, httpClient, objectMapper, basePath, openApiContextPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T, M extends MessageWrapper> T exec(HttpUriRequest request, Handler<T, M> handler, Class<M> messageWrapperType) {
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            MessageWrapper messageWrapper;
            this.validateResponse(response);
            try (InputStream inputStream = response.getEntity().getContent();){
                messageWrapper = (MessageWrapper)this.objectMapper.readValue(inputStream, messageWrapperType);
            }
            if (!messageWrapper.isSuccess()) {
                throw new OotpException(messageWrapper.getErrMsg(), messageWrapper.getCode(), messageWrapper.getErrMsg());
            }
            T t = handler.apply((HttpMessage)response, messageWrapper);
            return t;
        }
        catch (IOException ex) {
            throw new OotpException("\u6d88\u606fAPI\u8c03\u7528\u5931\u8d25\uff1a" + ex.getMessage(), ex);
        }
    }

    protected <T> T exec1(HttpUriRequest request, Handler1<T> handler) {
        return this.exec(request, handler, MessageWrapper1.class);
    }

    protected <T> T exec2(HttpUriRequest request, Handler2<T> handler) {
        return this.exec(request, handler, MessageWrapper2.class);
    }

    @Override
    public String send(ExsMessage message) throws OotpException {
        ExsMetadata metadata = Objects.requireNonNull(message.getMetadata(), "metadata is required.");
        Objects.requireNonNull(metadata.getType(), "type is required.");
        Objects.requireNonNull(metadata.getTo(), "to is required.");
        Objects.requireNonNull(metadata.getContentType(), "contentType is required.");
        ExsBody body = message.getBody();
        Objects.requireNonNull(body, "body is required.");
        HttpPut request = new HttpPut(this.baseUrl + "/api/messages/v1");
        try {
            HttpEntity entity = V1MessageClientImpl.toEntity(body, metadata);
            request.setEntity(this.codecEncode(entity, metadata));
        }
        catch (IOException e) {
            throw new OotpException("\u5904\u7406\u8bf7\u6c42\u8f93\u5165\u65f6\u51fa\u9519", e);
        }
        this.processCjkExtensionHeader((HttpUriRequest)request, metadata);
        metadata.toHeaders((arg_0, arg_1) -> ((HttpPut)request).setHeader(arg_0, arg_1));
        return this.exec1((HttpUriRequest)request, (response, messageWrapper) -> Optional.ofNullable(response.getFirstHeader(Signer.HEADER_NAME_PREFIX + "exs-id")).map(NameValuePair::getValue).orElse(null));
    }

    @Override
    public PollResult poll(PollRequest request) throws OotpException {
        byte[] bytes;
        int limit = request.getLimit();
        if (limit <= 0 || limit > 100) {
            log.warn("\u4fee\u6539 poll \u8bf7\u6c42\u7684\u6d88\u606f\u6570\u91cf\uff1a{} -> {}", (Object)limit, (Object)100);
            request.setLimit(100);
        }
        try {
            bytes = this.objectMapper.writeValueAsBytes((Object)request);
        }
        catch (JsonProcessingException e) {
            throw new OotpException("\u5e8f\u5217\u5316\u8f6e\u8be2\u8bf7\u6c42\u51fa\u9519", e);
        }
        HttpPost httpPost = new HttpPost(this.baseUrl + "/api/messages/v1");
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(bytes, ContentType.APPLICATION_JSON));
        Optional.ofNullable(request.getClientId()).ifPresent(s -> httpPost.setHeader(Signer.HEADER_NAME_PREFIX + "client-id", s));
        return this.exec1((HttpUriRequest)httpPost, (response, messageWrapper) -> {
            List<MessageV1> list = messageWrapper.getResultData();
            PollResult pollResult = new PollResult();
            if (list != null) {
                List<ExsMessageLite> messages = list.stream().map(m -> {
                    ExsMessageLite lite = new ExsMessageLite();
                    lite.setBody(m.getMsgBody());
                    ExsMetadata meta = new ExsMetadata();
                    meta.setId("" + m.getId());
                    meta.setContentType(m.getContentType());
                    meta.setFrom(m.getFromSysId());
                    meta.setType(m.getBizType());
                    lite.setMetadata(meta);
                    return lite;
                }).collect(Collectors.toList());
                pollResult.setMessages(messages);
            }
            Optional.ofNullable(response.getFirstHeader(Signer.HEADER_NAME_PREFIX + "exs-latest-id")).ifPresent(h -> pollResult.setLatestId(h.getValue()));
            return pollResult;
        });
    }

    @Override
    public ExsMessage getMessage(String id) throws OotpException {
        return this.getMessage(id, s -> "/api/messages/v1?id=" + s);
    }

    @Override
    public ExsMessageInfo getMessageInfo(String id) throws OotpException {
        Objects.requireNonNull(id, "id is required.");
        HttpGet httpGet = new HttpGet(this.baseUrl + "/api/messages/info/v1?id=" + id);
        return this.exec2((HttpUriRequest)httpGet, (response, messageWrapper) -> messageWrapper.getResultData());
    }

    @Override
    public int ack(List<String> ids) throws OotpException {
        return this.processIds(ids, null, "ack");
    }

    @Override
    public int ret(List<String> ids, Consumer<Object> requestConfigurer) throws OotpException {
        return this.processIds(ids, requestConfigurer, "ret");
    }

    int processIds(List<String> ids, Consumer<Object> requestConfigurer, String action) throws OotpException {
        return this.processIds(ids, requestConfigurer, "/api/messages/" + action + "/v1", httpPost -> this.exec2((HttpUriRequest)httpPost, (response, messageWrapper) -> {
            log.debug("{} result: {}", (Object)action, (Object)messageWrapper);
            return -1;
        }));
    }

    @FunctionalInterface
    static interface Handler2<T>
    extends Handler<T, MessageWrapper2> {
        @Override
        public T apply(HttpMessage var1, MessageWrapper2 var2) throws IOException;
    }

    @FunctionalInterface
    static interface Handler1<T>
    extends Handler<T, MessageWrapper1> {
        @Override
        public T apply(HttpMessage var1, MessageWrapper1 var2) throws IOException;
    }

    static interface Handler<T, M extends MessageWrapper> {
        public T apply(HttpMessage var1, M var2) throws IOException;
    }

    public static class MessageV1 {
        private Long id;
        private String bizType;
        private String fromSysId;
        private String contentType;
        private String msgBody;

        public Long getId() {
            return this.id;
        }

        public String getBizType() {
            return this.bizType;
        }

        public String getFromSysId() {
            return this.fromSysId;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getMsgBody() {
            return this.msgBody;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setBizType(String bizType) {
            this.bizType = bizType;
        }

        public void setFromSysId(String fromSysId) {
            this.fromSysId = fromSysId;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public void setMsgBody(String msgBody) {
            this.msgBody = msgBody;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageV1)) {
                return false;
            }
            MessageV1 other = (MessageV1)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$id = this.getId();
            Long other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$bizType = this.getBizType();
            String other$bizType = other.getBizType();
            if (this$bizType == null ? other$bizType != null : !this$bizType.equals(other$bizType)) {
                return false;
            }
            String this$fromSysId = this.getFromSysId();
            String other$fromSysId = other.getFromSysId();
            if (this$fromSysId == null ? other$fromSysId != null : !this$fromSysId.equals(other$fromSysId)) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
                return false;
            }
            String this$msgBody = this.getMsgBody();
            String other$msgBody = other.getMsgBody();
            return !(this$msgBody == null ? other$msgBody != null : !this$msgBody.equals(other$msgBody));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageV1;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $bizType = this.getBizType();
            result = result * 59 + ($bizType == null ? 43 : $bizType.hashCode());
            String $fromSysId = this.getFromSysId();
            result = result * 59 + ($fromSysId == null ? 43 : $fromSysId.hashCode());
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            String $msgBody = this.getMsgBody();
            result = result * 59 + ($msgBody == null ? 43 : $msgBody.hashCode());
            return result;
        }

        public String toString() {
            return "V1MessageClientImpl.MessageV1(id=" + this.getId() + ", bizType=" + this.getBizType() + ", fromSysId=" + this.getFromSysId() + ", contentType=" + this.getContentType() + ", msgBody=" + this.getMsgBody() + ")";
        }
    }

    public static class MessageWrapper2
    implements MessageWrapper {
        private boolean success;
        private int code;
        private String errMsg;
        private ExsMessageInfo resultData;

        @Override
        public boolean isSuccess() {
            return this.success;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getErrMsg() {
            return this.errMsg;
        }

        public ExsMessageInfo getResultData() {
            return this.resultData;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setErrMsg(String errMsg) {
            this.errMsg = errMsg;
        }

        public void setResultData(ExsMessageInfo resultData) {
            this.resultData = resultData;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageWrapper2)) {
                return false;
            }
            MessageWrapper2 other = (MessageWrapper2)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$errMsg = this.getErrMsg();
            String other$errMsg = other.getErrMsg();
            if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
                return false;
            }
            ExsMessageInfo this$resultData = this.getResultData();
            ExsMessageInfo other$resultData = other.getResultData();
            return !(this$resultData == null ? other$resultData != null : !((Object)this$resultData).equals(other$resultData));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageWrapper2;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            result = result * 59 + this.getCode();
            String $errMsg = this.getErrMsg();
            result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
            ExsMessageInfo $resultData = this.getResultData();
            result = result * 59 + ($resultData == null ? 43 : ((Object)$resultData).hashCode());
            return result;
        }

        public String toString() {
            return "V1MessageClientImpl.MessageWrapper2(success=" + this.isSuccess() + ", code=" + this.getCode() + ", errMsg=" + this.getErrMsg() + ", resultData=" + this.getResultData() + ")";
        }
    }

    public static class MessageWrapper1
    implements MessageWrapper {
        private boolean success;
        private int code;
        private String errMsg;
        private List<MessageV1> resultData;

        @Override
        public boolean isSuccess() {
            return this.success;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getErrMsg() {
            return this.errMsg;
        }

        public List<MessageV1> getResultData() {
            return this.resultData;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setErrMsg(String errMsg) {
            this.errMsg = errMsg;
        }

        public void setResultData(List<MessageV1> resultData) {
            this.resultData = resultData;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageWrapper1)) {
                return false;
            }
            MessageWrapper1 other = (MessageWrapper1)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$errMsg = this.getErrMsg();
            String other$errMsg = other.getErrMsg();
            if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
                return false;
            }
            List<MessageV1> this$resultData = this.getResultData();
            List<MessageV1> other$resultData = other.getResultData();
            return !(this$resultData == null ? other$resultData != null : !((Object)this$resultData).equals(other$resultData));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageWrapper1;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            result = result * 59 + this.getCode();
            String $errMsg = this.getErrMsg();
            result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
            List<MessageV1> $resultData = this.getResultData();
            result = result * 59 + ($resultData == null ? 43 : ((Object)$resultData).hashCode());
            return result;
        }

        public String toString() {
            return "V1MessageClientImpl.MessageWrapper1(success=" + this.isSuccess() + ", code=" + this.getCode() + ", errMsg=" + this.getErrMsg() + ", resultData=" + this.getResultData() + ")";
        }
    }

    static interface MessageWrapper {
        public boolean isSuccess();

        public int getCode();

        public String getErrMsg();
    }
}

