package org.opoo.ootp.client;

/**
 * API调用客户端。
 */
public interface ApiClient {
    /**
     * API的调用通常仅支持POST请求。
     *
     * @param path    API的请求路径
     * @param request 请求对象
     * @return 响应对象
     */
    ExsMessage post(String path, ExsMessage request);

    /**
     * API调用。
     *
     * @param path       API路径
     * @param request    请求对象，可以是 {@link ExsMessage} 或者 {@link String} 或者 byte[] 或者 InputStream，其它类型将自动转成 JSON 格式的报文。
     * @param resultType 结果类型
     * @param <T>        响应对象类型，可以是 {@link ExsMessage}
     * @return 响应对象。
     */
    <T> T post(String path, Object request, Class<T> resultType);
}
