package org.opoo.ootp.client;

import com.emc.codec.encryption.KeyProvider;
import org.opoo.ootp.codec.encryption.KeyAndSpecProvider;
import org.opoo.ootp.codec.encryption.PrivateKeyProvider;

import java.security.PublicKey;

/**
 * 密钥提供者管理器
 */
public interface KeyProviderManager {
    /**
     * 获取 SM4 的密钥提供者。
     *
     * @param to 对接方，一般根据不同的对接方配置不通的密钥。
     * @return 当前对接方的 SM4 密钥提供者
     */
    KeyAndSpecProvider getSM4KeyProvider(String to);

    /**
     * 获取 SM2 公钥。用于加密。
     *
     * @param to 对接方，不同的对接方有不通的公钥
     * @return 当前对接方的加密公钥
     */
    PublicKey getSM2PublicKey(String to);

    /**
     * 获取 SM2 私钥提供者。同一对接方不通时期甚至同时可能有多套
     * 公钥私钥，这里要能根据公钥私钥的指纹找到特定的解密私钥。
     * 私钥一定时自己的，所以无需根据目标方去查找。
     *
     * @return 私钥提供者
     */
    PrivateKeyProvider getSM2PrivateKeyProvider();

    /**
     * 使用 RSA 算法加密解密时的密钥提供者。
     *
     * @param to 对接方，不同的对接方有不通的公钥私钥对。
     * @return 当前对接方的密钥提供者
     */
    KeyProvider getRSAKeyProvider(String to);
}
