package org.opoo.ootp.client.httpclient;

import lombok.RequiredArgsConstructor;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.opoo.ootp.client.ExsCodec;
import org.opoo.ootp.client.ExsMetadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@RequiredArgsConstructor
public class ExsCodecHttpResponseInterceptor implements HttpResponseInterceptor {
    private final ExsCodec exsCodec;

    @Override
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws IOException {
        final Map<String, String> headers = new HashMap<>();
        Arrays.stream(httpResponse.getAllHeaders()).forEach(h -> headers.putIfAbsent(h.getName().toLowerCase(), h.getValue()));
        final ExsMetadata exsMetadata = ExsMetadata.fromHeaders(headers);
        final HttpEntity decode = exsCodec.decode(httpResponse.getEntity(), exsMetadata);
        httpResponse.setEntity(decode);
    }
}
