package org.opoo.ootp.client.impl;

import lombok.Data;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.client.ExsMetadataConfigurerProvider;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

@Data
public class BasicExsMetadataConfigurerProvider implements ExsMetadataConfigurerProvider {
    private Map<String, Consumer<ExsMetadata>> configurers;

    public BasicExsMetadataConfigurerProvider addConfigurer(String from, Consumer<ExsMetadata> configurer) {
        if (this.configurers == null) {
            this.configurers = new HashMap<>();
        }

        this.configurers.put(from, configurer);
        return this;
    }

    @Override
    public Consumer<ExsMetadata> getConfigurer(String from) {
        return configurers.get(from);
    }
}
