package org.opoo.ootp.client.impl;

import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;

@FunctionalInterface
public interface HttpClientConfigurer {

    /**
     * 对 HttpClient 进行配置，即配置个性化的 HttpClient。
     * 可以通过这个方法配置http代理，连接池大小，超时时间等。
     *
     * @param httpClientBuilder httpClient 构建器
     */
    void configure(HttpClientBuilder httpClientBuilder);

    @FunctionalInterface
    interface RequestConfigConfigurer {
        /**
         * 对 HttpClient 的 RequestConfig 进行配置。
         *
         * @param requestConfigBuilder RequestConfig 构建器
         */
        void configure(RequestConfig.Builder requestConfigBuilder);
    }
}
