package org.opoo.ootp.client.impl;

import com.emc.codec.encryption.BasicKeyProvider;
import com.emc.codec.encryption.KeyProvider;
import lombok.extern.slf4j.Slf4j;
import org.opoo.ootp.client.KeyProviderManager;
import org.opoo.ootp.codec.encryption.BasicKeyAndSpecProvider;
import org.opoo.ootp.codec.encryption.BasicPrivateKeyProvider;
import org.opoo.ootp.codec.encryption.KeyAndSpec;
import org.opoo.ootp.codec.encryption.KeyAndSpecProvider;
import org.opoo.ootp.codec.encryption.PrivateKeyProvider;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

@Slf4j
public class SingleKeyProviderManager implements KeyProviderManager {
    private final KeyPair keyPair;
    private final KeyAndSpecProvider keyAndSpecProvider;

    public SingleKeyProviderManager(KeyPair keyPair) {
        this.keyPair = keyPair;
        this.keyAndSpecProvider = null;
    }

    public SingleKeyProviderManager(PublicKey publicKey, PrivateKey privateKey) {
        this(new KeyPair(publicKey, privateKey));
    }

    public SingleKeyProviderManager(KeyAndSpec keyAndSpec) {
        this.keyPair = null;
        this.keyAndSpecProvider = new BasicKeyAndSpecProvider(keyAndSpec);
    }

    public SingleKeyProviderManager(Key key) {
        this(new KeyAndSpec(key));
    }

    @Override
    public KeyAndSpecProvider getSM4KeyProvider(String to) {
        log.debug("查询 SM4 密钥 {}", to != null ? ": " + to : "");
        return keyAndSpecProvider;
    }

    @Override
    public PublicKey getSM2PublicKey(String to) {
        if (keyPair == null) {
            return null;
        }
        log.debug("查询 SM2 公钥 {}", to != null ? ": " + to : "");
        return keyPair.getPublic();
    }

    @Override
    public PrivateKeyProvider getSM2PrivateKeyProvider() {
        if (keyPair == null) {
            return null;
        }
        log.debug("查询 SM2 私钥");
        return new BasicPrivateKeyProvider(keyPair.getPrivate());
    }

    @Override
    public KeyProvider getRSAKeyProvider(String to) {
        if (keyPair == null) {
            return null;
        }
        log.debug("查询 RSA 公钥和私钥 {}", to != null ? ": " + to : "");
        return new BasicKeyProvider(keyPair);
    }
}
